/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.PendingPost;
import org.greenrobot.eventbus.PendingPostQueue;
import org.greenrobot.eventbus.Subscription;

class AsyncPoster
implements Runnable {
    private final PendingPostQueue queue;
    private final EventBus eventBus;

    AsyncPoster(EventBus eventBus) {
        this.eventBus = eventBus;
        this.queue = new PendingPostQueue();
    }

    public void enqueue(Subscription subscription, Object object) {
        PendingPost pendingPost = PendingPost.obtainPendingPost(subscription, object);
        this.queue.enqueue(pendingPost);
        this.eventBus.getExecutorService().execute(this);
    }

    @Override
    public void run() {
        PendingPost pendingPost = this.queue.poll();
        if (pendingPost == null) {
            throw new IllegalStateException("No pending post available");
        }
        this.eventBus.invokeSubscriber(pendingPost);
    }
}

