/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import android.os.Looper;
import android.util.Log;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import org.greenrobot.eventbus.AsyncPoster;
import org.greenrobot.eventbus.BackgroundPoster;
import org.greenrobot.eventbus.EventBusBuilder;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.HandlerPoster;
import org.greenrobot.eventbus.NoSubscriberEvent;
import org.greenrobot.eventbus.PendingPost;
import org.greenrobot.eventbus.SubscriberExceptionEvent;
import org.greenrobot.eventbus.SubscriberMethod;
import org.greenrobot.eventbus.SubscriberMethodFinder;
import org.greenrobot.eventbus.Subscription;
import org.greenrobot.eventbus.ThreadMode;

public class EventBus {
    public static String TAG = "EventBus";
    static volatile EventBus defaultInstance;
    private static final EventBusBuilder DEFAULT_BUILDER;
    private static final Map<Class<?>, List<Class<?>>> eventTypesCache;
    private final Map<Class<?>, CopyOnWriteArrayList<Subscription>> subscriptionsByEventType;
    private final Map<Object, List<Class<?>>> typesBySubscriber;
    private final Map<Class<?>, Object> stickyEvents;
    private final ThreadLocal<PostingThreadState> currentPostingThreadState = new ThreadLocal<PostingThreadState>(){

        @Override
        protected PostingThreadState initialValue() {
            return new PostingThreadState();
        }
    };
    private final HandlerPoster mainThreadPoster;
    private final BackgroundPoster backgroundPoster;
    private final AsyncPoster asyncPoster;
    private final SubscriberMethodFinder subscriberMethodFinder;
    private final ExecutorService executorService;
    private final boolean throwSubscriberException;
    private final boolean logSubscriberExceptions;
    private final boolean logNoSubscriberMessages;
    private final boolean sendSubscriberExceptionEvent;
    private final boolean sendNoSubscriberEvent;
    private final boolean eventInheritance;
    private final int indexCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBus getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static EventBusBuilder builder() {
        return new EventBusBuilder();
    }

    public static void clearCaches() {
        SubscriberMethodFinder.clearCaches();
        eventTypesCache.clear();
    }

    public EventBus() {
        this(DEFAULT_BUILDER);
    }

    EventBus(EventBusBuilder eventBusBuilder) {
        this.subscriptionsByEventType = new HashMap();
        this.typesBySubscriber = new HashMap();
        this.stickyEvents = new ConcurrentHashMap();
        this.mainThreadPoster = new HandlerPoster(this, Looper.getMainLooper(), 10);
        this.backgroundPoster = new BackgroundPoster(this);
        this.asyncPoster = new AsyncPoster(this);
        this.indexCount = eventBusBuilder.subscriberInfoIndexes != null ? eventBusBuilder.subscriberInfoIndexes.size() : 0;
        this.subscriberMethodFinder = new SubscriberMethodFinder(eventBusBuilder.subscriberInfoIndexes, eventBusBuilder.strictMethodVerification, eventBusBuilder.ignoreGeneratedIndex);
        this.logSubscriberExceptions = eventBusBuilder.logSubscriberExceptions;
        this.logNoSubscriberMessages = eventBusBuilder.logNoSubscriberMessages;
        this.sendSubscriberExceptionEvent = eventBusBuilder.sendSubscriberExceptionEvent;
        this.sendNoSubscriberEvent = eventBusBuilder.sendNoSubscriberEvent;
        this.throwSubscriberException = eventBusBuilder.throwSubscriberException;
        this.eventInheritance = eventBusBuilder.eventInheritance;
        this.executorService = eventBusBuilder.executorService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Object object) {
        Class<?> clazz = object.getClass();
        List<SubscriberMethod> list = this.subscriberMethodFinder.findSubscriberMethods(clazz);
        EventBus eventBus = this;
        synchronized (eventBus) {
            for (SubscriberMethod subscriberMethod : list) {
                this.subscribe(object, subscriberMethod);
            }
        }
    }

    private void subscribe(Object object, SubscriberMethod subscriberMethod) {
        List<Class<?>> list;
        Class<?> clazz = subscriberMethod.eventType;
        Subscription subscription = new Subscription(object, subscriberMethod);
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList = this.subscriptionsByEventType.get(clazz);
        if (copyOnWriteArrayList == null) {
            copyOnWriteArrayList = new CopyOnWriteArrayList();
            this.subscriptionsByEventType.put(clazz, copyOnWriteArrayList);
        } else if (copyOnWriteArrayList.contains(subscription)) {
            throw new EventBusException("Subscriber " + object.getClass() + " already registered to event " + clazz);
        }
        int n2 = copyOnWriteArrayList.size();
        for (int i2 = 0; i2 <= n2; ++i2) {
            if (i2 != n2 && subscriberMethod.priority <= copyOnWriteArrayList.get((int)i2).subscriberMethod.priority) continue;
            copyOnWriteArrayList.add(i2, subscription);
            break;
        }
        if ((list = this.typesBySubscriber.get(object)) == null) {
            list = new ArrayList();
            this.typesBySubscriber.put(object, list);
        }
        list.add(clazz);
        if (subscriberMethod.sticky) {
            if (this.eventInheritance) {
                Set<Map.Entry<Class<?>, Object>> set = this.stickyEvents.entrySet();
                for (Map.Entry<Class<?>, Object> entry : set) {
                    Class<?> clazz2 = entry.getKey();
                    if (!clazz.isAssignableFrom(clazz2)) continue;
                    Object object2 = entry.getValue();
                    this.checkPostStickyEventToSubscription(subscription, object2);
                }
            } else {
                Object object3 = this.stickyEvents.get(clazz);
                this.checkPostStickyEventToSubscription(subscription, object3);
            }
        }
    }

    private void checkPostStickyEventToSubscription(Subscription subscription, Object object) {
        if (object != null) {
            this.postToSubscription(subscription, object, Looper.getMainLooper() == Looper.myLooper());
        }
    }

    public synchronized boolean isRegistered(Object object) {
        return this.typesBySubscriber.containsKey(object);
    }

    private void unsubscribeByEventType(Object object, Class<?> clazz) {
        List list = this.subscriptionsByEventType.get(clazz);
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Subscription subscription = (Subscription)list.get(i2);
                if (subscription.subscriber != object) continue;
                subscription.active = false;
                list.remove(i2);
                --i2;
                --n2;
            }
        }
    }

    public synchronized void unregister(Object object) {
        List<Class<?>> list = this.typesBySubscriber.get(object);
        if (list != null) {
            for (Class<?> clazz : list) {
                this.unsubscribeByEventType(object, clazz);
            }
            this.typesBySubscriber.remove(object);
        } else {
            Log.w((String)TAG, (String)("Subscriber to unregister was not registered before: " + object.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object object) {
        PostingThreadState postingThreadState = this.currentPostingThreadState.get();
        List<Object> list = postingThreadState.eventQueue;
        list.add(object);
        if (!postingThreadState.isPosting) {
            postingThreadState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
            postingThreadState.isPosting = true;
            if (postingThreadState.canceled) {
                throw new EventBusException("Internal error. Abort state was not reset");
            }
            try {
                while (!list.isEmpty()) {
                    this.postSingleEvent(list.remove(0), postingThreadState);
                }
            }
            finally {
                postingThreadState.isPosting = false;
                postingThreadState.isMainThread = false;
            }
        }
    }

    public void cancelEventDelivery(Object object) {
        PostingThreadState postingThreadState = this.currentPostingThreadState.get();
        if (!postingThreadState.isPosting) {
            throw new EventBusException("This method may only be called from inside event handling methods on the posting thread");
        }
        if (object == null) {
            throw new EventBusException("Event may not be null");
        }
        if (postingThreadState.event != object) {
            throw new EventBusException("Only the currently handled event may be aborted");
        }
        if (postingThreadState.subscription.subscriberMethod.threadMode != ThreadMode.POSTING) {
            throw new EventBusException(" event handlers may only abort the incoming event");
        }
        postingThreadState.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSticky(Object object) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.put(object.getClass(), object);
        }
        this.post(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getStickyEvent(Class<T> clazz) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return clazz.cast(this.stickyEvents.get(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeStickyEvent(Class<T> clazz) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return clazz.cast(this.stickyEvents.remove(clazz));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStickyEvent(Object object) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            Class<?> clazz = object.getClass();
            Object object2 = this.stickyEvents.get(clazz);
            if (object.equals(object2)) {
                this.stickyEvents.remove(clazz);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllStickyEvents() {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSubscriberForEvent(Class<?> clazz) {
        List<Class<?>> list = EventBus.lookupAllEventTypes(clazz);
        if (list != null) {
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                CopyOnWriteArrayList<Subscription> copyOnWriteArrayList;
                Class<?> clazz2 = list.get(i2);
                EventBus eventBus = this;
                synchronized (eventBus) {
                    copyOnWriteArrayList = this.subscriptionsByEventType.get(clazz2);
                }
                if (copyOnWriteArrayList == null || copyOnWriteArrayList.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private void postSingleEvent(Object object, PostingThreadState postingThreadState) throws Error {
        Class<?> clazz = object.getClass();
        boolean bl2 = false;
        if (this.eventInheritance) {
            List<Class<?>> list = EventBus.lookupAllEventTypes(clazz);
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                Class<?> clazz2 = list.get(i2);
                bl2 |= this.postSingleEventForEventType(object, postingThreadState, clazz2);
            }
        } else {
            bl2 = this.postSingleEventForEventType(object, postingThreadState, clazz);
        }
        if (!bl2) {
            if (this.logNoSubscriberMessages) {
                Log.d((String)TAG, (String)("No subscribers registered for event " + clazz));
            }
            if (this.sendNoSubscriberEvent && clazz != NoSubscriberEvent.class && clazz != SubscriberExceptionEvent.class) {
                this.post(new NoSubscriberEvent(this, object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean postSingleEventForEventType(Object object, PostingThreadState postingThreadState, Class<?> clazz) {
        CopyOnWriteArrayList<Subscription> copyOnWriteArrayList;
        EventBus eventBus = this;
        synchronized (eventBus) {
            copyOnWriteArrayList = this.subscriptionsByEventType.get(clazz);
        }
        if (copyOnWriteArrayList != null && !copyOnWriteArrayList.isEmpty()) {
            for (Subscription subscription : copyOnWriteArrayList) {
                postingThreadState.event = object;
                postingThreadState.subscription = subscription;
                boolean bl2 = false;
                try {
                    this.postToSubscription(subscription, object, postingThreadState.isMainThread);
                    bl2 = postingThreadState.canceled;
                }
                finally {
                    postingThreadState.event = null;
                    postingThreadState.subscription = null;
                    postingThreadState.canceled = false;
                }
                if (!bl2) continue;
                break;
            }
            return true;
        }
        return false;
    }

    private void postToSubscription(Subscription subscription, Object object, boolean bl2) {
        switch (subscription.subscriberMethod.threadMode) {
            case POSTING: {
                this.invokeSubscriber(subscription, object);
                break;
            }
            case MAIN: {
                if (bl2) {
                    this.invokeSubscriber(subscription, object);
                    break;
                }
                this.mainThreadPoster.enqueue(subscription, object);
                break;
            }
            case BACKGROUND: {
                if (bl2) {
                    this.backgroundPoster.enqueue(subscription, object);
                    break;
                }
                this.invokeSubscriber(subscription, object);
                break;
            }
            case ASYNC: {
                this.asyncPoster.enqueue(subscription, object);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown thread mode: " + (Object)((Object)subscription.subscriberMethod.threadMode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<Class<?>> lookupAllEventTypes(Class<?> clazz) {
        Map<Class<?>, List<Class<?>>> map = eventTypesCache;
        synchronized (map) {
            List<Class<?>> list = eventTypesCache.get(clazz);
            if (list == null) {
                list = new ArrayList();
                for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                    list.add(clazz2);
                    EventBus.addInterfaces(list, clazz2.getInterfaces());
                }
                eventTypesCache.put(clazz, list);
            }
            return list;
        }
    }

    static void addInterfaces(List<Class<?>> list, Class<?>[] classArray) {
        for (Class<?> clazz : classArray) {
            if (list.contains(clazz)) continue;
            list.add(clazz);
            EventBus.addInterfaces(list, clazz.getInterfaces());
        }
    }

    void invokeSubscriber(PendingPost pendingPost) {
        Object object = pendingPost.event;
        Subscription subscription = pendingPost.subscription;
        PendingPost.releasePendingPost(pendingPost);
        if (subscription.active) {
            this.invokeSubscriber(subscription, object);
        }
    }

    void invokeSubscriber(Subscription subscription, Object object) {
        try {
            subscription.subscriberMethod.method.invoke(subscription.subscriber, object);
        }
        catch (InvocationTargetException invocationTargetException) {
            this.handleSubscriberException(subscription, object, invocationTargetException.getCause());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalStateException("Unexpected exception", illegalAccessException);
        }
    }

    private void handleSubscriberException(Subscription subscription, Object object, Throwable throwable) {
        if (object instanceof SubscriberExceptionEvent) {
            if (this.logSubscriberExceptions) {
                Log.e((String)TAG, (String)("SubscriberExceptionEvent subscriber " + subscription.subscriber.getClass() + " threw an exception"), (Throwable)throwable);
                SubscriberExceptionEvent subscriberExceptionEvent = (SubscriberExceptionEvent)object;
                Log.e((String)TAG, (String)("Initial event " + subscriberExceptionEvent.causingEvent + " caused exception in " + subscriberExceptionEvent.causingSubscriber), (Throwable)subscriberExceptionEvent.throwable);
            }
        } else {
            if (this.throwSubscriberException) {
                throw new EventBusException("Invoking subscriber failed", throwable);
            }
            if (this.logSubscriberExceptions) {
                Log.e((String)TAG, (String)("Could not dispatch event: " + object.getClass() + " to subscribing class " + subscription.subscriber.getClass()), (Throwable)throwable);
            }
            if (this.sendSubscriberExceptionEvent) {
                SubscriberExceptionEvent subscriberExceptionEvent = new SubscriberExceptionEvent(this, throwable, object, subscription.subscriber);
                this.post(subscriberExceptionEvent);
            }
        }
    }

    ExecutorService getExecutorService() {
        return this.executorService;
    }

    public String toString() {
        return "EventBus[indexCount=" + this.indexCount + ", eventInheritance=" + this.eventInheritance + "]";
    }

    static {
        DEFAULT_BUILDER = new EventBusBuilder();
        eventTypesCache = new HashMap();
    }

    static interface PostCallback {
        public void onPostCompleted(List<SubscriberExceptionEvent> var1);
    }

    static final class PostingThreadState {
        final List<Object> eventQueue = new ArrayList<Object>();
        boolean isPosting;
        boolean isMainThread;
        Subscription subscription;
        Object event;
        boolean canceled;

        PostingThreadState() {
        }
    }
}

