/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import java.lang.reflect.Method;
import org.greenrobot.eventbus.ThreadMode;

public class SubscriberMethod {
    final Method method;
    final ThreadMode threadMode;
    final Class<?> eventType;
    final int priority;
    final boolean sticky;
    String methodString;

    public SubscriberMethod(Method method, Class<?> clazz, ThreadMode threadMode, int n2, boolean bl2) {
        this.method = method;
        this.threadMode = threadMode;
        this.eventType = clazz;
        this.priority = n2;
        this.sticky = bl2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SubscriberMethod) {
            this.checkMethodString();
            SubscriberMethod subscriberMethod = (SubscriberMethod)object;
            subscriberMethod.checkMethodString();
            return this.methodString.equals(subscriberMethod.methodString);
        }
        return false;
    }

    private synchronized void checkMethodString() {
        if (this.methodString == null) {
            StringBuilder stringBuilder = new StringBuilder(64);
            stringBuilder.append(this.method.getDeclaringClass().getName());
            stringBuilder.append('#').append(this.method.getName());
            stringBuilder.append('(').append(this.eventType.getName());
            this.methodString = stringBuilder.toString();
        }
    }

    public int hashCode() {
        return this.method.hashCode();
    }
}

