/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.SubscriberMethod;
import org.greenrobot.eventbus.ThreadMode;
import org.greenrobot.eventbus.meta.SubscriberInfo;
import org.greenrobot.eventbus.meta.SubscriberInfoIndex;

class SubscriberMethodFinder {
    private static final int BRIDGE = 64;
    private static final int SYNTHETIC = 4096;
    private static final int MODIFIERS_IGNORE = 5192;
    private static final Map<Class<?>, List<SubscriberMethod>> METHOD_CACHE = new ConcurrentHashMap();
    private List<SubscriberInfoIndex> subscriberInfoIndexes;
    private final boolean strictMethodVerification;
    private final boolean ignoreGeneratedIndex;
    private static final int POOL_SIZE = 4;
    private static final FindState[] FIND_STATE_POOL = new FindState[4];

    SubscriberMethodFinder(List<SubscriberInfoIndex> list, boolean bl2, boolean bl3) {
        this.subscriberInfoIndexes = list;
        this.strictMethodVerification = bl2;
        this.ignoreGeneratedIndex = bl3;
    }

    List<SubscriberMethod> findSubscriberMethods(Class<?> clazz) {
        List<SubscriberMethod> list = METHOD_CACHE.get(clazz);
        if (list != null) {
            return list;
        }
        list = this.ignoreGeneratedIndex ? this.findUsingReflection(clazz) : this.findUsingInfo(clazz);
        if (list.isEmpty()) {
            throw new EventBusException("Subscriber " + clazz + " and its super classes have no public methods with the @Subscribe annotation");
        }
        METHOD_CACHE.put(clazz, list);
        return list;
    }

    private List<SubscriberMethod> findUsingInfo(Class<?> clazz) {
        FindState findState = this.prepareFindState();
        findState.initForSubscriber(clazz);
        while (findState.clazz != null) {
            findState.subscriberInfo = this.getSubscriberInfo(findState);
            if (findState.subscriberInfo != null) {
                SubscriberMethod[] subscriberMethodArray;
                for (SubscriberMethod subscriberMethod : subscriberMethodArray = findState.subscriberInfo.getSubscriberMethods()) {
                    if (!findState.checkAdd(subscriberMethod.method, subscriberMethod.eventType)) continue;
                    findState.subscriberMethods.add(subscriberMethod);
                }
            } else {
                this.findUsingReflectionInSingleClass(findState);
            }
            findState.moveToSuperclass();
        }
        return this.getMethodsAndRelease(findState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SubscriberMethod> getMethodsAndRelease(FindState findState) {
        ArrayList<SubscriberMethod> arrayList = new ArrayList<SubscriberMethod>(findState.subscriberMethods);
        findState.recycle();
        FindState[] findStateArray = FIND_STATE_POOL;
        synchronized (FIND_STATE_POOL) {
            for (int i2 = 0; i2 < 4; ++i2) {
                if (FIND_STATE_POOL[i2] != null) continue;
                SubscriberMethodFinder.FIND_STATE_POOL[i2] = findState;
                break;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FindState prepareFindState() {
        FindState[] findStateArray = FIND_STATE_POOL;
        synchronized (FIND_STATE_POOL) {
            for (int i2 = 0; i2 < 4; ++i2) {
                FindState findState = FIND_STATE_POOL[i2];
                if (findState == null) continue;
                SubscriberMethodFinder.FIND_STATE_POOL[i2] = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return findState;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return new FindState();
        }
    }

    private SubscriberInfo getSubscriberInfo(FindState findState) {
        Object object;
        if (findState.subscriberInfo != null && findState.subscriberInfo.getSuperSubscriberInfo() != null && findState.clazz == (object = findState.subscriberInfo.getSuperSubscriberInfo()).getSubscriberClass()) {
            return object;
        }
        if (this.subscriberInfoIndexes != null) {
            for (SubscriberInfoIndex subscriberInfoIndex : this.subscriberInfoIndexes) {
                SubscriberInfo subscriberInfo = subscriberInfoIndex.getSubscriberInfo(findState.clazz);
                if (subscriberInfo == null) continue;
                return subscriberInfo;
            }
        }
        return null;
    }

    private List<SubscriberMethod> findUsingReflection(Class<?> clazz) {
        FindState findState = this.prepareFindState();
        findState.initForSubscriber(clazz);
        while (findState.clazz != null) {
            this.findUsingReflectionInSingleClass(findState);
            findState.moveToSuperclass();
        }
        return this.getMethodsAndRelease(findState);
    }

    private void findUsingReflectionInSingleClass(FindState findState) {
        Method[] methodArray;
        try {
            methodArray = findState.clazz.getDeclaredMethods();
        }
        catch (Throwable throwable) {
            methodArray = findState.clazz.getMethods();
            findState.skipSuperClasses = true;
        }
        for (Method method : methodArray) {
            Object object;
            int n2 = method.getModifiers();
            if ((n2 & 1) != 0 && (n2 & 0x1448) == 0) {
                Object object2;
                object = method.getParameterTypes();
                if (((Class<?>[])object).length == 1) {
                    Class<?> clazz;
                    object2 = method.getAnnotation(Subscribe.class);
                    if (object2 == null || !findState.checkAdd(method, clazz = object[0])) continue;
                    ThreadMode threadMode = object2.threadMode();
                    findState.subscriberMethods.add(new SubscriberMethod(method, clazz, threadMode, object2.priority(), object2.sticky()));
                    continue;
                }
                if (!this.strictMethodVerification || !method.isAnnotationPresent(Subscribe.class)) continue;
                object2 = method.getDeclaringClass().getName() + "." + method.getName();
                throw new EventBusException("@Subscribe method " + (String)object2 + "must have exactly 1 parameter but has " + ((Class<?>[])object).length);
            }
            if (!this.strictMethodVerification || !method.isAnnotationPresent(Subscribe.class)) continue;
            object = method.getDeclaringClass().getName() + "." + method.getName();
            throw new EventBusException(object + " is a illegal @Subscribe method: must be public, non-static, and non-abstract");
        }
    }

    static void clearCaches() {
        METHOD_CACHE.clear();
    }

    static class FindState {
        final List<SubscriberMethod> subscriberMethods = new ArrayList<SubscriberMethod>();
        final Map<Class, Object> anyMethodByEventType = new HashMap<Class, Object>();
        final Map<String, Class> subscriberClassByMethodKey = new HashMap<String, Class>();
        final StringBuilder methodKeyBuilder = new StringBuilder(128);
        Class<?> subscriberClass;
        Class<?> clazz;
        boolean skipSuperClasses;
        SubscriberInfo subscriberInfo;

        FindState() {
        }

        void initForSubscriber(Class<?> clazz) {
            this.clazz = clazz;
            this.subscriberClass = this.clazz;
            this.skipSuperClasses = false;
            this.subscriberInfo = null;
        }

        void recycle() {
            this.subscriberMethods.clear();
            this.anyMethodByEventType.clear();
            this.subscriberClassByMethodKey.clear();
            this.methodKeyBuilder.setLength(0);
            this.subscriberClass = null;
            this.clazz = null;
            this.skipSuperClasses = false;
            this.subscriberInfo = null;
        }

        boolean checkAdd(Method method, Class<?> clazz) {
            Object object = this.anyMethodByEventType.put(clazz, method);
            if (object == null) {
                return true;
            }
            if (object instanceof Method) {
                if (!this.checkAddWithMethodSignature((Method)object, clazz)) {
                    throw new IllegalStateException();
                }
                this.anyMethodByEventType.put(clazz, this);
            }
            return this.checkAddWithMethodSignature(method, clazz);
        }

        private boolean checkAddWithMethodSignature(Method method, Class<?> clazz) {
            this.methodKeyBuilder.setLength(0);
            this.methodKeyBuilder.append(method.getName());
            this.methodKeyBuilder.append('>').append(clazz.getName());
            String string = this.methodKeyBuilder.toString();
            Class<?> clazz2 = method.getDeclaringClass();
            Class<?> clazz3 = this.subscriberClassByMethodKey.put(string, clazz2);
            if (clazz3 == null || clazz3.isAssignableFrom(clazz2)) {
                return true;
            }
            this.subscriberClassByMethodKey.put(string, clazz3);
            return false;
        }

        void moveToSuperclass() {
            if (this.skipSuperClasses) {
                this.clazz = null;
            } else {
                this.clazz = this.clazz.getSuperclass();
                String string = this.clazz.getName();
                if (string.startsWith("java.") || string.startsWith("javax.") || string.startsWith("android.")) {
                    this.clazz = null;
                }
            }
        }
    }
}

