/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.meta;

import java.lang.reflect.Method;
import org.greenrobot.eventbus.EventBusException;
import org.greenrobot.eventbus.SubscriberMethod;
import org.greenrobot.eventbus.ThreadMode;
import org.greenrobot.eventbus.meta.SubscriberInfo;

public abstract class AbstractSubscriberInfo
implements SubscriberInfo {
    private final Class subscriberClass;
    private final Class<? extends SubscriberInfo> superSubscriberInfoClass;
    private final boolean shouldCheckSuperclass;

    protected AbstractSubscriberInfo(Class clazz, Class<? extends SubscriberInfo> clazz2, boolean bl2) {
        this.subscriberClass = clazz;
        this.superSubscriberInfoClass = clazz2;
        this.shouldCheckSuperclass = bl2;
    }

    public Class getSubscriberClass() {
        return this.subscriberClass;
    }

    @Override
    public SubscriberInfo getSuperSubscriberInfo() {
        if (this.superSubscriberInfoClass == null) {
            return null;
        }
        try {
            return this.superSubscriberInfoClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Override
    public boolean shouldCheckSuperclass() {
        return this.shouldCheckSuperclass;
    }

    protected SubscriberMethod createSubscriberMethod(String string, Class<?> clazz) {
        return this.createSubscriberMethod(string, clazz, ThreadMode.POSTING, 0, false);
    }

    protected SubscriberMethod createSubscriberMethod(String string, Class<?> clazz, ThreadMode threadMode) {
        return this.createSubscriberMethod(string, clazz, threadMode, 0, false);
    }

    protected SubscriberMethod createSubscriberMethod(String string, Class<?> clazz, ThreadMode threadMode, int n2, boolean bl2) {
        try {
            Method method = this.subscriberClass.getDeclaredMethod(string, clazz);
            return new SubscriberMethod(method, clazz, threadMode, n2, bl2);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new EventBusException("Could not find subscriber method in " + this.subscriberClass + ". Maybe a missing ProGuard rule?", noSuchMethodException);
        }
    }
}

