/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.util;

import android.app.Activity;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.util.HasExecutionScope;
import org.greenrobot.eventbus.util.ThrowableFailureEvent;

public class AsyncExecutor {
    private final Executor threadPool;
    private final Constructor<?> failureEventConstructor;
    private final EventBus eventBus;
    private final Object scope;

    public static Builder builder() {
        return new Builder();
    }

    public static AsyncExecutor create() {
        return new Builder().build();
    }

    private AsyncExecutor(Executor executor, EventBus eventBus, Class<?> clazz, Object object) {
        this.threadPool = executor;
        this.eventBus = eventBus;
        this.scope = object;
        try {
            this.failureEventConstructor = clazz.getConstructor(Throwable.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException("Failure event class must have a constructor with one parameter of type Throwable", noSuchMethodException);
        }
    }

    public void execute(final RunnableEx runnableEx) {
        this.threadPool.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    runnableEx.run();
                }
                catch (Exception exception) {
                    Object t2;
                    try {
                        t2 = AsyncExecutor.this.failureEventConstructor.newInstance(exception);
                    }
                    catch (Exception exception2) {
                        Log.e((String)EventBus.TAG, (String)"Original exception:", (Throwable)exception);
                        throw new RuntimeException("Could not create failure event", exception2);
                    }
                    if (t2 instanceof HasExecutionScope) {
                        ((HasExecutionScope)t2).setExecutionScope(AsyncExecutor.this.scope);
                    }
                    AsyncExecutor.this.eventBus.post(t2);
                }
            }
        });
    }

    public static interface RunnableEx {
        public void run() throws Exception;
    }

    public static class Builder {
        private Executor threadPool;
        private Class<?> failureEventType;
        private EventBus eventBus;

        private Builder() {
        }

        public Builder threadPool(Executor executor) {
            this.threadPool = executor;
            return this;
        }

        public Builder failureEventType(Class<?> clazz) {
            this.failureEventType = clazz;
            return this;
        }

        public Builder eventBus(EventBus eventBus) {
            this.eventBus = eventBus;
            return this;
        }

        public AsyncExecutor build() {
            return this.buildForScope(null);
        }

        public AsyncExecutor buildForActivityScope(Activity activity) {
            return this.buildForScope(activity.getClass());
        }

        public AsyncExecutor buildForScope(Object object) {
            if (this.eventBus == null) {
                this.eventBus = EventBus.getDefault();
            }
            if (this.threadPool == null) {
                this.threadPool = Executors.newCachedThreadPool();
            }
            if (this.failureEventType == null) {
                this.failureEventType = ThrowableFailureEvent.class;
            }
            return new AsyncExecutor(this.threadPool, this.eventBus, this.failureEventType, object);
        }
    }
}

