/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.util;

import android.content.res.Resources;
import android.util.Log;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.util.ExceptionToResourceMapping;

public class ErrorDialogConfig {
    final Resources resources;
    final int defaultTitleId;
    final int defaultErrorMsgId;
    final ExceptionToResourceMapping mapping;
    EventBus eventBus;
    boolean logExceptions = true;
    String tagForLoggingExceptions;
    int defaultDialogIconId;
    Class<?> defaultEventTypeOnDialogClosed;

    public ErrorDialogConfig(Resources resources, int n2, int n3) {
        this.resources = resources;
        this.defaultTitleId = n2;
        this.defaultErrorMsgId = n3;
        this.mapping = new ExceptionToResourceMapping();
    }

    public ErrorDialogConfig addMapping(Class<? extends Throwable> clazz, int n2) {
        this.mapping.addMapping(clazz, n2);
        return this;
    }

    public int getMessageIdForThrowable(Throwable throwable) {
        Integer n2 = this.mapping.mapThrowable(throwable);
        if (n2 != null) {
            return n2;
        }
        Log.d((String)EventBus.TAG, (String)("No specific message ressource ID found for " + throwable));
        return this.defaultErrorMsgId;
    }

    public void setDefaultDialogIconId(int n2) {
        this.defaultDialogIconId = n2;
    }

    public void setDefaultEventTypeOnDialogClosed(Class<?> clazz) {
        this.defaultEventTypeOnDialogClosed = clazz;
    }

    public void disableExceptionLogging() {
        this.logExceptions = false;
    }

    public void setTagForLoggingExceptions(String string) {
        this.tagForLoggingExceptions = string;
    }

    public void setEventBus(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    EventBus getEventBus() {
        return this.eventBus != null ? this.eventBus : EventBus.getDefault();
    }
}

