/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.util;

import android.annotation.TargetApi;
import android.app.Fragment;
import android.os.Bundle;
import org.greenrobot.eventbus.util.ErrorDialogConfig;
import org.greenrobot.eventbus.util.ErrorDialogFragments;
import org.greenrobot.eventbus.util.ThrowableFailureEvent;

public abstract class ErrorDialogFragmentFactory<T> {
    protected final ErrorDialogConfig config;

    protected ErrorDialogFragmentFactory(ErrorDialogConfig errorDialogConfig) {
        this.config = errorDialogConfig;
    }

    protected T prepareErrorFragment(ThrowableFailureEvent throwableFailureEvent, boolean bl2, Bundle bundle) {
        String string;
        if (throwableFailureEvent.isSuppressErrorUi()) {
            return null;
        }
        Bundle bundle2 = bundle != null ? (Bundle)bundle.clone() : new Bundle();
        if (!bundle2.containsKey("de.greenrobot.eventbus.errordialog.title")) {
            string = this.getTitleFor(throwableFailureEvent, bundle2);
            bundle2.putString("de.greenrobot.eventbus.errordialog.title", string);
        }
        if (!bundle2.containsKey("de.greenrobot.eventbus.errordialog.message")) {
            string = this.getMessageFor(throwableFailureEvent, bundle2);
            bundle2.putString("de.greenrobot.eventbus.errordialog.message", string);
        }
        if (!bundle2.containsKey("de.greenrobot.eventbus.errordialog.finish_after_dialog")) {
            bundle2.putBoolean("de.greenrobot.eventbus.errordialog.finish_after_dialog", bl2);
        }
        if (!bundle2.containsKey("de.greenrobot.eventbus.errordialog.event_type_on_close") && this.config.defaultEventTypeOnDialogClosed != null) {
            bundle2.putSerializable("de.greenrobot.eventbus.errordialog.event_type_on_close", this.config.defaultEventTypeOnDialogClosed);
        }
        if (!bundle2.containsKey("de.greenrobot.eventbus.errordialog.icon_id") && this.config.defaultDialogIconId != 0) {
            bundle2.putInt("de.greenrobot.eventbus.errordialog.icon_id", this.config.defaultDialogIconId);
        }
        return this.createErrorFragment(throwableFailureEvent, bundle2);
    }

    protected abstract T createErrorFragment(ThrowableFailureEvent var1, Bundle var2);

    protected String getTitleFor(ThrowableFailureEvent throwableFailureEvent, Bundle bundle) {
        return this.config.resources.getString(this.config.defaultTitleId);
    }

    protected String getMessageFor(ThrowableFailureEvent throwableFailureEvent, Bundle bundle) {
        int n2 = this.config.getMessageIdForThrowable(throwableFailureEvent.throwable);
        return this.config.resources.getString(n2);
    }

    @TargetApi(value=11)
    public static class Honeycomb
    extends ErrorDialogFragmentFactory<Fragment> {
        public Honeycomb(ErrorDialogConfig errorDialogConfig) {
            super(errorDialogConfig);
        }

        @Override
        protected Fragment createErrorFragment(ThrowableFailureEvent throwableFailureEvent, Bundle bundle) {
            ErrorDialogFragments.Honeycomb honeycomb = new ErrorDialogFragments.Honeycomb();
            honeycomb.setArguments(bundle);
            return honeycomb;
        }
    }

    public static class Support
    extends ErrorDialogFragmentFactory<android.support.v4.app.Fragment> {
        public Support(ErrorDialogConfig errorDialogConfig) {
            super(errorDialogConfig);
        }

        @Override
        protected android.support.v4.app.Fragment createErrorFragment(ThrowableFailureEvent throwableFailureEvent, Bundle bundle) {
            ErrorDialogFragments.Support support = new ErrorDialogFragments.Support();
            support.setArguments(bundle);
            return support;
        }
    }
}

