/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eventbus.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.Fragment;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.util.Log;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.util.ErrorDialogFragmentFactory;
import org.greenrobot.eventbus.util.ThrowableFailureEvent;

public class ErrorDialogManager {
    public static ErrorDialogFragmentFactory<?> factory;
    protected static final String TAG_ERROR_DIALOG = "de.greenrobot.eventbus.error_dialog";
    protected static final String TAG_ERROR_DIALOG_MANAGER = "de.greenrobot.eventbus.error_dialog_manager";
    public static final String KEY_TITLE = "de.greenrobot.eventbus.errordialog.title";
    public static final String KEY_MESSAGE = "de.greenrobot.eventbus.errordialog.message";
    public static final String KEY_FINISH_AFTER_DIALOG = "de.greenrobot.eventbus.errordialog.finish_after_dialog";
    public static final String KEY_ICON_ID = "de.greenrobot.eventbus.errordialog.icon_id";
    public static final String KEY_EVENT_TYPE_ON_CLOSE = "de.greenrobot.eventbus.errordialog.event_type_on_close";

    public static void attachTo(Activity activity) {
        ErrorDialogManager.attachTo(activity, false, null);
    }

    public static void attachTo(Activity activity, boolean bl2) {
        ErrorDialogManager.attachTo(activity, bl2, null);
    }

    public static void attachTo(Activity activity, boolean bl2, Bundle bundle) {
        Class<?> clazz = activity.getClass();
        ErrorDialogManager.attachTo(activity, clazz, bl2, bundle);
    }

    public static void attachTo(Activity activity, Object object, boolean bl2, Bundle bundle) {
        if (factory == null) {
            throw new RuntimeException("You must set the static factory field to configure error dialogs for your app.");
        }
        if (ErrorDialogManager.isSupportActivity(activity)) {
            SupportManagerFragment.attachTo(activity, object, bl2, bundle);
        } else {
            HoneycombManagerFragment.attachTo(activity, object, bl2, bundle);
        }
    }

    private static boolean isSupportActivity(Activity activity) {
        boolean bl2 = false;
        Class<?> clazz = activity.getClass().getSuperclass();
        while (true) {
            if (clazz == null) {
                throw new RuntimeException("Illegal activity type: " + activity.getClass());
            }
            String string2 = clazz.getName();
            if (string2.equals("android.support.v4.app.FragmentActivity")) {
                bl2 = true;
                break;
            }
            if (string2.startsWith("com.actionbarsherlock.app") && (string2.endsWith(".SherlockActivity") || string2.endsWith(".SherlockListActivity") || string2.endsWith(".SherlockPreferenceActivity"))) {
                throw new RuntimeException("Please use SherlockFragmentActivity. Illegal activity: " + string2);
            }
            if (string2.equals("android.app.Activity")) {
                if (Build.VERSION.SDK_INT >= 11) break;
                throw new RuntimeException("Illegal activity without fragment support. Either use Android 3.0+ or android.support.v4.app.FragmentActivity.");
            }
            clazz = clazz.getSuperclass();
        }
        return bl2;
    }

    protected static void checkLogException(ThrowableFailureEvent throwableFailureEvent) {
        if (ErrorDialogManager.factory.config.logExceptions) {
            String string2 = ErrorDialogManager.factory.config.tagForLoggingExceptions;
            if (string2 == null) {
                string2 = EventBus.TAG;
            }
            Log.i((String)string2, (String)"Error dialog manager received exception", (Throwable)throwableFailureEvent.throwable);
        }
    }

    private static boolean isInExecutionScope(Object object, ThrowableFailureEvent throwableFailureEvent) {
        Object object2;
        return throwableFailureEvent == null || (object2 = throwableFailureEvent.getExecutionScope()) == null || object2.equals(object);
    }

    @TargetApi(value=11)
    public static class HoneycombManagerFragment
    extends Fragment {
        protected boolean finishAfterDialog;
        protected Bundle argumentsForErrorDialog;
        private EventBus eventBus;
        private Object executionScope;

        public void onResume() {
            super.onResume();
            this.eventBus = ErrorDialogManager.factory.config.getEventBus();
            this.eventBus.register((Object)this);
        }

        public void onPause() {
            this.eventBus.unregister((Object)this);
            super.onPause();
        }

        public void onEventMainThread(ThrowableFailureEvent throwableFailureEvent) {
            android.app.DialogFragment dialogFragment;
            if (!ErrorDialogManager.isInExecutionScope(this.executionScope, throwableFailureEvent)) {
                return;
            }
            ErrorDialogManager.checkLogException(throwableFailureEvent);
            android.app.FragmentManager fragmentManager = this.getFragmentManager();
            fragmentManager.executePendingTransactions();
            android.app.DialogFragment dialogFragment2 = (android.app.DialogFragment)fragmentManager.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG);
            if (dialogFragment2 != null) {
                dialogFragment2.dismiss();
            }
            if ((dialogFragment = (android.app.DialogFragment)factory.prepareErrorFragment(throwableFailureEvent, this.finishAfterDialog, this.argumentsForErrorDialog)) != null) {
                dialogFragment.show(fragmentManager, ErrorDialogManager.TAG_ERROR_DIALOG);
            }
        }

        public static void attachTo(Activity activity, Object object, boolean bl2, Bundle bundle) {
            android.app.FragmentManager fragmentManager = activity.getFragmentManager();
            HoneycombManagerFragment honeycombManagerFragment = (HoneycombManagerFragment)fragmentManager.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER);
            if (honeycombManagerFragment == null) {
                honeycombManagerFragment = new HoneycombManagerFragment();
                fragmentManager.beginTransaction().add((Fragment)honeycombManagerFragment, ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER).commit();
                fragmentManager.executePendingTransactions();
            }
            honeycombManagerFragment.finishAfterDialog = bl2;
            honeycombManagerFragment.argumentsForErrorDialog = bundle;
            honeycombManagerFragment.executionScope = object;
        }
    }

    public static class SupportManagerFragment
    extends android.support.v4.app.Fragment {
        protected boolean finishAfterDialog;
        protected Bundle argumentsForErrorDialog;
        private EventBus eventBus;
        private boolean skipRegisterOnNextResume;
        private Object executionScope;

        public void onCreate(Bundle bundle) {
            super.onCreate(bundle);
            this.eventBus = ErrorDialogManager.factory.config.getEventBus();
            this.eventBus.register((Object)this);
            this.skipRegisterOnNextResume = true;
        }

        public void onResume() {
            super.onResume();
            if (this.skipRegisterOnNextResume) {
                this.skipRegisterOnNextResume = false;
            } else {
                this.eventBus = ErrorDialogManager.factory.config.getEventBus();
                this.eventBus.register((Object)this);
            }
        }

        public void onPause() {
            this.eventBus.unregister((Object)this);
            super.onPause();
        }

        public void onEventMainThread(ThrowableFailureEvent throwableFailureEvent) {
            DialogFragment dialogFragment;
            if (!ErrorDialogManager.isInExecutionScope(this.executionScope, throwableFailureEvent)) {
                return;
            }
            ErrorDialogManager.checkLogException(throwableFailureEvent);
            FragmentManager fragmentManager = this.getFragmentManager();
            fragmentManager.executePendingTransactions();
            DialogFragment dialogFragment2 = (DialogFragment)fragmentManager.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG);
            if (dialogFragment2 != null) {
                dialogFragment2.dismiss();
            }
            if ((dialogFragment = (DialogFragment)factory.prepareErrorFragment(throwableFailureEvent, this.finishAfterDialog, this.argumentsForErrorDialog)) != null) {
                dialogFragment.show(fragmentManager, ErrorDialogManager.TAG_ERROR_DIALOG);
            }
        }

        public static void attachTo(Activity activity, Object object, boolean bl2, Bundle bundle) {
            FragmentManager fragmentManager = ((FragmentActivity)activity).getSupportFragmentManager();
            SupportManagerFragment supportManagerFragment = (SupportManagerFragment)fragmentManager.findFragmentByTag(ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER);
            if (supportManagerFragment == null) {
                supportManagerFragment = new SupportManagerFragment();
                fragmentManager.beginTransaction().add((android.support.v4.app.Fragment)supportManagerFragment, ErrorDialogManager.TAG_ERROR_DIALOG_MANAGER).commit();
                fragmentManager.executePendingTransactions();
            }
            supportManagerFragment.finishAfterDialog = bl2;
            supportManagerFragment.argumentsForErrorDialog = bundle;
            supportManagerFragment.executionScope = object;
        }
    }
}

