/*
 * Decompiled with CFR 0.152.
 */
package io.github.workoss.jni;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0006\b&\u0018\u0000 \u000f2\u00020\u0001:\u0002\u000e\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0004J\"\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\n2\b\u0010\r\u001a\u0004\u0018\u00010\nH\u0002\u00a8\u0006\u0010"}, d2={"Lio/github/workoss/jni/Detector;", "", "<init>", "()V", "detect", "", "props", "Ljava/util/Properties;", "classifierWithLikes", "", "", "setProperty", "name", "value", "LinuxRelease", "Companion", "jni-kt"})
public abstract class Detector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String DETECTED_NAME = "os.detected.name";
    @NotNull
    public static final String DETECTED_ARCH = "os.detected.arch";
    @NotNull
    public static final String DETECTED_VERSION = "os.detected.version";
    @NotNull
    public static final String DETECTED_VERSION_MAJOR = "os.detected.version.major";
    @NotNull
    public static final String DETECTED_VERSION_MINOR = "os.detected.version.minor";
    @NotNull
    public static final String DETECTED_CLASSIFIER = "os.detected.classifier";
    @NotNull
    public static final String DETECTED_RELEASE = "os.detected.release";
    @NotNull
    public static final String DETECTED_RELEASE_VERSION = "os.detected.release.version";
    @NotNull
    public static final String DETECTED_RELEASE_LIKE_PREFIX = "os.detected.release.like.";
    @NotNull
    private static final String UNKNOWN = "unknown";
    @NotNull
    private static final String LINUX_ID_PREFIX = "ID=";
    @NotNull
    private static final String LINUX_ID_LIKE_PREFIX = "ID_LIKE=";
    @NotNull
    private static final String LINUX_VERSION_ID_PREFIX = "VERSION_ID=";
    @NotNull
    private static final String[] LINUX_OS_RELEASE_FILES;
    @NotNull
    private static final String REDHAT_RELEASE_FILE = "/etc/redhat-release";
    @NotNull
    private static final String[] DEFAULT_REDHAT_VARIANTS;
    private static final Pattern VERSION_REGEX;
    private static final Pattern REDHAT_MAJOR_VERSION_REGEX;

    protected final void detect(@NotNull Properties props, @NotNull List<String> classifierWithLikes) {
        LinuxRelease linuxRelease;
        String failOnUnknownOS;
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter(classifierWithLikes, (String)"classifierWithLikes");
        Properties allProps = new Properties(System.getProperties());
        allProps.putAll((Map<?, ?>)props);
        String osName = allProps.getProperty("os.name");
        String osArch = allProps.getProperty("os.arch");
        String osVersion = allProps.getProperty("os.version");
        Intrinsics.checkNotNull((Object)osName);
        String detectedName = Detector.Companion.normalizeOs(osName);
        Intrinsics.checkNotNull((Object)osArch);
        String detectedArch = Detector.Companion.normalizeArch(osArch);
        this.setProperty(props, DETECTED_NAME, detectedName);
        this.setProperty(props, DETECTED_ARCH, detectedArch);
        Matcher versionMatcher = VERSION_REGEX.matcher(osVersion);
        if (versionMatcher.matches()) {
            this.setProperty(props, DETECTED_VERSION, versionMatcher.group(1));
            this.setProperty(props, DETECTED_VERSION_MAJOR, versionMatcher.group(2));
            this.setProperty(props, DETECTED_VERSION_MINOR, versionMatcher.group(3));
        }
        if (!StringsKt.equals((String)"false", (String)(failOnUnknownOS = allProps.getProperty("failOnUnknownOS")), (boolean)true)) {
            if (Intrinsics.areEqual((Object)UNKNOWN, (Object)detectedName)) {
                throw new IllegalStateException(("unknown os.name: " + osName).toString());
            }
            if (Intrinsics.areEqual((Object)UNKNOWN, (Object)detectedArch)) {
                throw new IllegalStateException(("unknown os.arch: " + osArch).toString());
            }
        }
        StringBuilder detectedClassifierBuilder = new StringBuilder();
        detectedClassifierBuilder.append(detectedName);
        detectedClassifierBuilder.append('-');
        detectedClassifierBuilder.append(detectedArch);
        LinuxRelease linuxRelease2 = linuxRelease = Intrinsics.areEqual((Object)"linux", (Object)detectedName) ? Detector.Companion.getLinuxRelease() : null;
        if (linuxRelease != null) {
            this.setProperty(props, DETECTED_RELEASE, linuxRelease.getId());
            if (linuxRelease.getVersion() != null) {
                this.setProperty(props, DETECTED_RELEASE_VERSION, linuxRelease.getVersion());
            }
            for (String like : linuxRelease.getLike()) {
                String propKey = DETECTED_RELEASE_LIKE_PREFIX + like;
                this.setProperty(props, propKey, "true");
            }
            for (String classifierLike : classifierWithLikes) {
                if (!linuxRelease.getLike().contains(classifierLike)) continue;
                detectedClassifierBuilder.append('-');
                detectedClassifierBuilder.append(classifierLike);
                break;
            }
        }
        this.setProperty(props, DETECTED_CLASSIFIER, detectedClassifierBuilder.toString());
    }

    private final void setProperty(Properties props, String name, String value) {
        props.setProperty(name, value);
        if (value != null) {
            System.setProperty(name, value);
        }
    }

    static {
        String[] stringArray = new String[]{"/etc/os-release", "/usr/lib/os-release"};
        LINUX_OS_RELEASE_FILES = stringArray;
        stringArray = new String[]{"rhel", "fedora"};
        DEFAULT_REDHAT_VARIANTS = stringArray;
        VERSION_REGEX = Pattern.compile("((\\d+)\\.(\\d+)).*");
        REDHAT_MAJOR_VERSION_REGEX = Pattern.compile("(\\d+)");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0012\u0010\u001f\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0005H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010!2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u0005H\u0002J\u0012\u0010)\u001a\u00020*2\b\u0010+\u001a\u0004\u0018\u00010,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014R\u0018\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0018\u0010\u001b\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001aR\u0016\u0010 \u001a\u0004\u0018\u00010!8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006-"}, d2={"Lio/github/workoss/jni/Detector$Companion;", "", "<init>", "()V", "DETECTED_NAME", "", "DETECTED_ARCH", "DETECTED_VERSION", "DETECTED_VERSION_MAJOR", "DETECTED_VERSION_MINOR", "DETECTED_CLASSIFIER", "DETECTED_RELEASE", "DETECTED_RELEASE_VERSION", "DETECTED_RELEASE_LIKE_PREFIX", "UNKNOWN", "LINUX_ID_PREFIX", "LINUX_ID_LIKE_PREFIX", "LINUX_VERSION_ID_PREFIX", "LINUX_OS_RELEASE_FILES", "", "[Ljava/lang/String;", "REDHAT_RELEASE_FILE", "DEFAULT_REDHAT_VARIANTS", "VERSION_REGEX", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "REDHAT_MAJOR_VERSION_REGEX", "normalizeOs", "value", "normalizeArch", "normalize", "linuxRelease", "Lio/github/workoss/jni/Detector$LinuxRelease;", "getLinuxRelease", "()Lio/github/workoss/jni/Detector$LinuxRelease;", "parseLinuxOsReleaseFile", "file", "Ljava/io/File;", "parseLinuxRedhatReleaseFile", "normalizeOsReleaseValue", "closeQuietly", "", "obj", "Ljava/io/Closeable;", "jni-kt"})
    @SourceDebugExtension(value={"SMAP\nOS.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OS.kt\nio/github/workoss/jni/Detector$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,368:1\n1#2:369\n37#3,2:370\n108#4:372\n80#4,22:373\n*S KotlinDebug\n*F\n+ 1 OS.kt\nio/github/workoss/jni/Detector$Companion\n*L\n301#1:370,2\n356#1:372\n356#1:373,22\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final String normalizeOs(String value) {
            String value2 = this.normalize(value);
            if (StringsKt.startsWith$default((String)value2, (String)"aix", (boolean)false, (int)2, null)) {
                return "aix";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"hpux", (boolean)false, (int)2, null)) {
                return "hpux";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"os400", (boolean)false, (int)2, null) && (value2.length() <= 5 || !Character.isDigit(value2.charAt(5)))) {
                return "os400";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"linux", (boolean)false, (int)2, null)) {
                return "linux";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"macosx", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value2, (String)"osx", (boolean)false, (int)2, null)) {
                return "osx";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"freebsd", (boolean)false, (int)2, null)) {
                return "freebsd";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"openbsd", (boolean)false, (int)2, null)) {
                return "openbsd";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"netbsd", (boolean)false, (int)2, null)) {
                return "netbsd";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"solaris", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value2, (String)"sunos", (boolean)false, (int)2, null)) {
                return "sunos";
            }
            if (StringsKt.startsWith$default((String)value2, (String)"windows", (boolean)false, (int)2, null)) {
                return "windows";
            }
            return StringsKt.startsWith$default((String)value2, (String)"zos", (boolean)false, (int)2, null) ? "zos" : Detector.UNKNOWN;
        }

        private final String normalizeArch(String value) {
            String value2 = this.normalize(value);
            CharSequence charSequence = value2;
            if (new Regex("^(x8664|amd64|ia32e|em64t|x64)$").matches(charSequence)) {
                return "x86_64";
            }
            charSequence = value2;
            if (new Regex("^(x8632|x86|i[3-6]86|ia32|x32)$").matches(charSequence)) {
                return "x86_32";
            }
            charSequence = value2;
            if (new Regex("^(ia64w?|itanium64)$").matches(charSequence)) {
                return "itanium_64";
            }
            if (Intrinsics.areEqual((Object)"ia64n", (Object)value2)) {
                return "itanium_32";
            }
            charSequence = value2;
            if (new Regex("^(sparc|sparc32)$").matches(charSequence)) {
                return "sparc_32";
            }
            charSequence = value2;
            if (new Regex("^(sparcv9|sparc64)$").matches(charSequence)) {
                return "sparc_64";
            }
            charSequence = value2;
            if (new Regex("^(arm|arm32)$").matches(charSequence)) {
                return "arm_32";
            }
            if (Intrinsics.areEqual((Object)"aarch64", (Object)value2)) {
                return "aarch_64";
            }
            charSequence = value2;
            if (new Regex("^(mips|mips32)$").matches(charSequence)) {
                return "mips_32";
            }
            charSequence = value2;
            if (new Regex("^(mipsel|mips32el)$").matches(charSequence)) {
                return "mipsel_32";
            }
            if (Intrinsics.areEqual((Object)"mips64", (Object)value2)) {
                return "mips_64";
            }
            if (Intrinsics.areEqual((Object)"mips64el", (Object)value2)) {
                return "mipsel_64";
            }
            charSequence = value2;
            if (new Regex("^(ppc|ppc32)$").matches(charSequence)) {
                return "ppc_32";
            }
            charSequence = value2;
            if (new Regex("^(ppcle|ppc32le)$").matches(charSequence)) {
                return "ppcle_32";
            }
            if (Intrinsics.areEqual((Object)"ppc64", (Object)value2)) {
                return "ppc_64";
            }
            if (Intrinsics.areEqual((Object)"ppc64le", (Object)value2)) {
                return "ppcle_64";
            }
            if (Intrinsics.areEqual((Object)"s390", (Object)value2)) {
                return "s390_32";
            }
            return Intrinsics.areEqual((Object)"s390x", (Object)value2) ? "s390_64" : Detector.UNKNOWN;
        }

        private final String normalize(String value) {
            String string;
            block3: {
                block2: {
                    String string2;
                    CharSequence charSequence;
                    Regex regex;
                    string = value;
                    if (string == null) break block2;
                    String string3 = string;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    String string4 = string3.toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
                    string = string4;
                    if (string4 != null && (string = (regex = new Regex("[^a-z0-9]+")).replace(charSequence = (CharSequence)string, string2 = "")) != null) break block3;
                }
                string = "";
            }
            return string;
        }

        private final LinuxRelease getLinuxRelease() {
            for (String osReleaseFileName : LINUX_OS_RELEASE_FILES) {
                File file = new File(osReleaseFileName);
                if (!file.exists()) continue;
                return this.parseLinuxOsReleaseFile(file);
            }
            File file = new File(Detector.REDHAT_RELEASE_FILE);
            return file.exists() ? this.parseLinuxRedhatReleaseFile(file) : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LinuxRelease parseLinuxOsReleaseFile(File file) {
            BufferedReader reader = null;
            try {
                Object object;
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
                String id = null;
                String version = null;
                Set likeSet = new LinkedHashSet();
                Ref.ObjectRef line = new Ref.ObjectRef();
                while (true) {
                    object = reader.readLine();
                    String[] it = object;
                    boolean bl = false;
                    line.element = it;
                    if (object == null) break;
                    if (StringsKt.startsWith$default((String)((String)line.element), (String)Detector.LINUX_ID_PREFIX, (boolean)false, (int)2, null)) {
                        String string = ((String)line.element).substring(3);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        id = this.normalizeOsReleaseValue(string);
                        likeSet.add(id);
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)((String)line.element), (String)Detector.LINUX_VERSION_ID_PREFIX, (boolean)false, (int)2, null)) {
                        String string = ((String)line.element).substring(11);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        version = this.normalizeOsReleaseValue(string);
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)((String)line.element), (String)Detector.LINUX_ID_LIKE_PREFIX, (boolean)false, (int)2, null)) continue;
                    String string = ((String)line.element).substring(8);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    line.element = this.normalizeOsReleaseValue(string);
                    it = new String[]{"\\s+"};
                    Collection $this$toTypedArray$iv = StringsKt.split$default((CharSequence)((CharSequence)line.element), (String[])it, (boolean)false, (int)0, (int)6, null);
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    String[] parts = thisCollection$iv.toArray(new String[0]);
                    Collections.addAll(likeSet, Arrays.copyOf(parts, parts.length));
                }
                if (id != null) {
                    object = new LinuxRelease(id, version, likeSet);
                    return object;
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.closeQuietly(reader);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final LinuxRelease parseLinuxRedhatReleaseFile(File file) {
            try {
                Closeable closeable = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
                Throwable throwable = null;
                try {
                    BufferedReader it = (BufferedReader)closeable;
                    boolean bl = false;
                    String line = it.readLine();
                    if (line != null) {
                        String string;
                        String string2 = line;
                        Locale locale = Locale.US;
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                        String string3 = string2.toLowerCase(locale);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                        line = string3;
                        String version = null;
                        if (StringsKt.contains$default((CharSequence)line, (CharSequence)"centos", (boolean)false, (int)2, null)) {
                            string = "centos";
                        } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"fedora", (boolean)false, (int)2, null)) {
                            string = "fedora";
                        } else if (StringsKt.contains$default((CharSequence)line, (CharSequence)"red hat enterprise linux", (boolean)false, (int)2, null)) {
                            string = "rhel";
                        } else {
                            LinuxRelease linuxRelease = null;
                            return linuxRelease;
                        }
                        String id = string;
                        Matcher versionMatcher = REDHAT_MAJOR_VERSION_REGEX.matcher(line);
                        if (versionMatcher.find()) {
                            version = versionMatcher.group(1);
                        }
                        String[] stringArray = DEFAULT_REDHAT_VARIANTS;
                        Set likeSet = new LinkedHashSet(CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length)));
                        likeSet.add(id);
                        LinuxRelease linuxRelease = new LinuxRelease(id, version, likeSet);
                        return linuxRelease;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }

        private final String normalizeOsReleaseValue(String value) {
            String $this$trim$iv = value;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = $this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            return StringsKt.replace$default((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (String)"\"", (String)"", (boolean)false, (int)4, null);
        }

        private final void closeQuietly(Closeable obj) {
            try {
                Closeable closeable = obj;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0010\u0010\u0005\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/github/workoss/jni/Detector$LinuxRelease;", "", "id", "", "version", "like", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getId", "()Ljava/lang/String;", "getVersion", "", "getLike", "()Ljava/util/Collection;", "jni-kt"})
    private static final class LinuxRelease {
        @NotNull
        private final String id;
        @Nullable
        private final String version;
        @NotNull
        private final Collection<String> like;

        public LinuxRelease(@NotNull String id, @Nullable String version, @Nullable Set<String> like) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            this.id = id;
            this.version = version;
            Set<String> set = like;
            Intrinsics.checkNotNull(set);
            Collection collection = Collections.unmodifiableCollection((Collection)set);
            Intrinsics.checkNotNullExpressionValue(collection, (String)"unmodifiableCollection(...)");
            this.like = collection;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @Nullable
        public final String getVersion() {
            return this.version;
        }

        @NotNull
        public final Collection<String> getLike() {
            return this.like;
        }
    }
}

