/*
 * Decompiled with CFR 0.152.
 */
package io.github.workoss.jni;

import io.github.workoss.jni.JniLibLoader;
import io.github.workoss.jni.OS;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J*\u0010\u0004\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005J4\u0010\u0004\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0005\u00a8\u0006\u000e"}, d2={"Lio/github/workoss/jni/JniLibLoader;", "", "<init>", "()V", "loadLibrary", "", "libName", "", "withPlatformDir", "classLoader", "Ljava/lang/ClassLoader;", "tmpDir", "prefix", "Companion", "jni-kt"})
@SourceDebugExtension(value={"SMAP\nJniLibLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniLibLoader.kt\nio/github/workoss/jni/JniLibLoader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n1#2:196\n*E\n"})
public final class JniLibLoader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger((String)"io.github.workoss.jni.JniLibLoader");
    @NotNull
    private static final Lazy<JniLibLoader> instance$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, (Function0)Companion.instance.2.INSTANCE);

    public final synchronized boolean loadLibrary(@NotNull String libName, boolean withPlatformDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
        return this.loadLibrary(null, OS.INSTANCE.getTmpDir(), libName, withPlatformDir);
    }

    public static /* synthetic */ boolean loadLibrary$default(JniLibLoader jniLibLoader, String string, boolean bl, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return jniLibLoader.loadLibrary(string, bl);
    }

    public final synchronized boolean loadLibrary(@Nullable ClassLoader classLoader, @NotNull String libName, boolean withPlatformDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
        return this.loadLibrary(classLoader, OS.INSTANCE.getTmpDir(), libName, withPlatformDir);
    }

    public static /* synthetic */ boolean loadLibrary$default(JniLibLoader jniLibLoader, ClassLoader classLoader, String string, boolean bl, int n, Object object) throws IOException {
        if ((n & 4) != 0) {
            bl = false;
        }
        return jniLibLoader.loadLibrary(classLoader, string, bl);
    }

    public final synchronized boolean loadLibrary(@Nullable ClassLoader classLoader, @NotNull String tmpDir, @NotNull String libName, boolean withPlatformDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
        return this.loadLibrary(classLoader, tmpDir, null, libName, withPlatformDir);
    }

    public static /* synthetic */ boolean loadLibrary$default(JniLibLoader jniLibLoader, ClassLoader classLoader, String string, String string2, boolean bl, int n, Object object) throws IOException {
        if ((n & 8) != 0) {
            bl = false;
        }
        return jniLibLoader.loadLibrary(classLoader, string, string2, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final synchronized boolean loadLibrary(@Nullable ClassLoader classLoader, @NotNull String tmpDir, @Nullable String prefix, @NotNull String libName, boolean withPlatformDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)tmpDir, (String)"tmpDir");
        Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
        Object[] objectArray = new String[]{Companion.getJniLibNameWithoutSuffix(libName), libName};
        boolean isLoadSystem = CollectionsKt.listOf((Object[])objectArray).stream().anyMatch(arg_0 -> JniLibLoader.loadLibrary$lambda$2(arg_0 -> JniLibLoader.loadLibrary$lambda$1(libName, arg_0), arg_0));
        if (isLoadSystem) return true;
        Object object = JniLibLoader.Companion.loadLibraryFromJar-yxL6bBk(classLoader, tmpDir, prefix, libName, withPlatformDir);
        if (Result.isSuccess-impl((Object)object)) {
            Unit it = (Unit)object;
            boolean bl = false;
            log.info("[LIB] load jar lib {} success", (Object)libName);
        }
        Object object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable throwable2;
            Throwable e = throwable2 = throwable;
            boolean bl = false;
            throw new IOException("[LIB] load " + libName + " error:" + e.getMessage());
        }
        if (!Result.isSuccess-impl((Object)object2)) return false;
        return true;
    }

    public static /* synthetic */ boolean loadLibrary$default(JniLibLoader jniLibLoader, ClassLoader classLoader, String string, String string2, String string3, boolean bl, int n, Object object) throws IOException {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return jniLibLoader.loadLibrary(classLoader, string, string2, string3, bl);
    }

    private static final boolean loadLibrary$lambda$1(String $libName, String it) {
        Object object;
        block0: {
            Throwable throwable;
            object = JniLibLoader.Companion.loadSystemLibrary-IoAF18A($libName);
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block0;
            Throwable e = throwable = throwable2;
            boolean bl = false;
            log.warn("[LIB] load system lib {} error:{}", (Object)it, (Object)e.getMessage());
        }
        return Result.isSuccess-impl((Object)object);
    }

    private static final boolean loadLibrary$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @NotNull
    public static final JniLibLoader getInstance() {
        return Companion.getInstance();
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0010J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0017J$\u0010\u0015\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002J\u001d\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0013\u001a\u00020\u0010H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001dJC\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0013\u001a\u00020\u00102\b\b\u0002\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R!\u0010\b\u001a\u00020\t8FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\n\u0010\u0003\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lio/github/workoss/jni/JniLibLoader$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "Lorg/slf4j/Logger;", "instance", "Lio/github/workoss/jni/JniLibLoader;", "getInstance$annotations", "getInstance", "()Lio/github/workoss/jni/JniLibLoader;", "instance$delegate", "Lkotlin/Lazy;", "getLibName", "", "jniLibName", "getJniLibNameWithoutSuffix", "libName", "getJniLibName", "getJniLibPath", "withPlatformDir", "", "prefix", "loadSystemLibrary", "Lkotlin/Result;", "", "loadSystemLibrary-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "loadLibraryFromJar", "classLoader", "Ljava/lang/ClassLoader;", "tmpDir", "loadLibraryFromJar-yxL6bBk", "(Ljava/lang/ClassLoader;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)Ljava/lang/Object;", "jni-kt"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JniLibLoader getInstance() {
            Lazy lazy = instance$delegate;
            return (JniLibLoader)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getInstance$annotations() {
        }

        @NotNull
        public final String getLibName(@NotNull String jniLibName) {
            Intrinsics.checkNotNullParameter((Object)jniLibName, (String)"jniLibName");
            String libName = StringsKt.replace$default((String)jniLibName, (String)('-' + OS.INSTANCE.getOs() + '-' + OS.INSTANCE.getArch()), (String)"", (boolean)false, (int)4, null);
            String libSuffix = OS.INSTANCE.isWindows() ? ".dll" : (OS.INSTANCE.isOSX() ? ".dylib" : ".so");
            libName = StringsKt.replace$default((String)libName, (String)libSuffix, (String)"", (boolean)false, (int)4, null);
            if (!OS.INSTANCE.isWindows() && StringsKt.startsWith$default((String)libName, (String)"lib", (boolean)false, (int)2, null)) {
                libName = StringsKt.replaceFirst$default((String)libName, (String)"lib", (String)"", (boolean)false, (int)4, null);
            }
            return libName;
        }

        @NotNull
        public final String getJniLibNameWithoutSuffix(@NotNull String libName) {
            Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
            String libName2 = StringsKt.replace$default((String)libName, (String)"-", (String)"_", (boolean)false, (int)4, null);
            String libPrefix = OS.INSTANCE.isWindows() ? "" : "lib";
            return libPrefix + libName2;
        }

        @NotNull
        public final String getJniLibName(@NotNull String libName) {
            String libPrefix;
            Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
            String libName2 = StringsKt.replace$default((String)libName, (String)"-", (String)"_", (boolean)false, (int)4, null);
            String string = libPrefix = OS.INSTANCE.isWindows() ? "" : "lib";
            String libSuffix = OS.INSTANCE.isWindows() ? ".dll" : (OS.INSTANCE.isOSX() ? ".dylib" : ".so");
            return libPrefix + libName2 + libSuffix;
        }

        @NotNull
        public final String getJniLibPath(@NotNull String libName, boolean withPlatformDir) {
            Intrinsics.checkNotNullParameter((Object)libName, (String)"libName");
            return this.getJniLibPath(null, libName, withPlatformDir);
        }

        public static /* synthetic */ String getJniLibPath$default(Companion companion, String string, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            return companion.getJniLibPath(string, bl);
        }

        private final String getJniLibPath(String prefix, String libName, boolean withPlatformDir) {
            String libPrefix;
            String prefix2 = prefix != null ? prefix + '/' : "";
            String string = libPrefix = OS.INSTANCE.isWindows() ? "" : "lib";
            String libSuffix = OS.INSTANCE.isWindows() ? ".dll" : (OS.INSTANCE.isOSX() ? ".dylib" : ".so");
            String libName2 = StringsKt.replace$default((String)libName, (String)"-", (String)"_", (boolean)false, (int)4, null);
            if (withPlatformDir) {
                return prefix2 + OS.INSTANCE.getOs() + '-' + OS.INSTANCE.getArch() + '/' + libPrefix + libName2 + libSuffix;
            }
            return prefix2 + libPrefix + libName2 + '-' + OS.INSTANCE.getOs() + '-' + OS.INSTANCE.getArch() + libSuffix;
        }

        static /* synthetic */ String getJniLibPath$default(Companion companion, String string, String string2, boolean bl, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            return companion.getJniLibPath(string, string2, bl);
        }

        private final Object loadSystemLibrary-IoAF18A(String libName) {
            Object object;
            Companion companion = this;
            try {
                Companion $this$loadSystemLibrary_IoAF18A_u24lambda_u240 = companion;
                boolean bl = false;
                System.loadLibrary(libName);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Object loadLibraryFromJar-yxL6bBk(ClassLoader classLoader, String tmpDir, String prefix, String libName, boolean withPlatformDir) {
            Object object;
            Companion companion = this;
            try {
                Companion $this$loadLibraryFromJar_yxL6bBk_u24lambda_u243 = companion;
                boolean bl = false;
                ClassLoader classLoader2 = classLoader;
                if (classLoader2 == null) {
                    classLoader2 = JniLibLoader.class.getClassLoader();
                }
                ClassLoader classLoader3 = classLoader2;
                String fullLibraryPath = $this$loadLibraryFromJar_yxL6bBk_u24lambda_u243.getJniLibPath(prefix, libName, withPlatformDir);
                Closeable closeable = classLoader3.getResourceAsStream(fullLibraryPath);
                Throwable throwable = null;
                try {
                    boolean bl2;
                    InputStream it = (InputStream)closeable;
                    boolean bl3 = false;
                    if (it == null) {
                        throw new RuntimeException(libName + " was not found inside JAR.");
                    }
                    Path path = Paths.get(tmpDir + fullLibraryPath, new String[0]).toAbsolutePath();
                    Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toAbsolutePath(...)");
                    Path tmpLibFulPath = path;
                    boolean it2 = bl2 = tmpLibFulPath.toFile().exists();
                    boolean bl4 = false;
                    if (it2) {
                        log.info(tmpLibFulPath + " was deleted");
                    }
                    File parentFile = tmpLibFulPath.getParent().toFile();
                    if (!parentFile.exists()) {
                        parentFile.mkdirs();
                    }
                    CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                    Files.copy(it, tmpLibFulPath, copyOptionArray);
                    System.load(((Object)tmpLibFulPath).toString());
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            return object;
        }

        static /* synthetic */ Object loadLibraryFromJar-yxL6bBk$default(Companion companion, ClassLoader classLoader, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 0x10) != 0) {
                bl = false;
            }
            return companion.loadLibraryFromJar-yxL6bBk(classLoader, string, string2, string3, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

