/*
 * Decompiled with CFR 0.152.
 */
package io.github.workoss.jni;

import io.github.workoss.jni.Detector;
import java.util.Properties;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u001b\u0010\f\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\u0007R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lio/github/workoss/jni/OS;", "", "<init>", "()V", "os", "", "getOs", "()Ljava/lang/String;", "arch", "getArch", "classifier", "getClassifier", "tmpDir", "getTmpDir", "tmpDir$delegate", "Lkotlin/Lazy;", "WINDOWS", "LINUX", "OSX", "X86_32", "X86_64", "isWindows", "", "()Z", "isLinux", "isOSX", "is32bit", "is64bit", "OSDetector", "jni-kt"})
public final class OS {
    @NotNull
    public static final OS INSTANCE = new OS();
    @NotNull
    private static final String os = OSDetector.INSTANCE.getOs();
    @NotNull
    private static final String arch = OSDetector.INSTANCE.getArch();
    @NotNull
    private static final String classifier = OSDetector.INSTANCE.getClassifier();
    @NotNull
    private static final Lazy tmpDir$delegate = LazyKt.lazy(OS::tmpDir_delegate$lambda$0);
    @NotNull
    private static final String WINDOWS = "windows";
    @NotNull
    private static final String LINUX = "linux";
    @NotNull
    private static final String OSX = "osx";
    @NotNull
    private static final String X86_32 = "x86_32";
    @NotNull
    private static final String X86_64 = "x86_64";
    private static final boolean isWindows = Intrinsics.areEqual((Object)os, (Object)"windows");
    private static final boolean isLinux = Intrinsics.areEqual((Object)os, (Object)"linux");
    private static final boolean isOSX = Intrinsics.areEqual((Object)os, (Object)"osx");
    private static final boolean is32bit = Intrinsics.areEqual((Object)arch, (Object)"x86_32");
    private static final boolean is64bit = Intrinsics.areEqual((Object)arch, (Object)"x86_64");

    private OS() {
    }

    @NotNull
    public final String getOs() {
        return os;
    }

    @NotNull
    public final String getArch() {
        return arch;
    }

    @NotNull
    public final String getClassifier() {
        return classifier;
    }

    @NotNull
    public final String getTmpDir() {
        Lazy lazy = tmpDir$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
        return (String)object;
    }

    public final boolean isWindows() {
        return isWindows;
    }

    public final boolean isLinux() {
        return isLinux;
    }

    public final boolean isOSX() {
        return isOSX;
    }

    public final boolean is32bit() {
        return is32bit;
    }

    public final boolean is64bit() {
        return is64bit;
    }

    private static final String tmpDir_delegate$lambda$0() {
        return System.getProperty("java.io.tmpdir");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lio/github/workoss/jni/OS$OSDetector;", "Lio/github/workoss/jni/Detector;", "<init>", "()V", "detectedProperties", "Ljava/util/Properties;", "getDetectedProperties", "()Ljava/util/Properties;", "os", "", "getOs", "()Ljava/lang/String;", "arch", "getArch", "classifier", "getClassifier", "jni-kt"})
    private static final class OSDetector
    extends Detector {
        @NotNull
        public static final OSDetector INSTANCE = new OSDetector();
        @NotNull
        private static final Properties detectedProperties;
        @NotNull
        private static final String os;
        @NotNull
        private static final String arch;
        @NotNull
        private static final String classifier;

        private OSDetector() {
        }

        @NotNull
        public final Properties getDetectedProperties() {
            return detectedProperties;
        }

        @NotNull
        public final String getOs() {
            return os;
        }

        @NotNull
        public final String getArch() {
            return arch;
        }

        @NotNull
        public final String getClassifier() {
            return classifier;
        }

        static {
            Properties properties = System.getProperties();
            Intrinsics.checkNotNullExpressionValue((Object)properties, (String)"getProperties(...)");
            detectedProperties = properties;
            INSTANCE.detect(detectedProperties, CollectionsKt.emptyList());
            Object object = detectedProperties.get("os.detected.name");
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            os = (String)object;
            Object object2 = detectedProperties.get("os.detected.arch");
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.String");
            arch = (String)object2;
            Object object3 = detectedProperties.get("os.detected.classifier");
            Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.String");
            classifier = (String)object3;
        }
    }
}

