/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouterbauweraerts.instancio.fixture.builder.generator;

import com.palantir.javapoet.MethodSpec;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.BuildMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.IgnoreMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.NameFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.SelfMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.WithMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.parameter.ParamType;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.util.GenerateFixtureBuilderUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

class BuilderMethodFactory {
    private final BuildMethodFactory buildMethodFactory;
    private final SelfMethodFactory selfMethodFactory;
    private final WithMethodFactory withMethodFactory;
    private final IgnoreMethodFactory ignoreMethodFactory;
    private final NameFactory nameFactory;
    private final GenerateFixtureBuilderUtils utils;

    BuilderMethodFactory(BuildMethodFactory buildMethodFactory, SelfMethodFactory selfMethodFactory, WithMethodFactory withMethodFactory, IgnoreMethodFactory ignoreMethodFactory, NameFactory nameFactory, GenerateFixtureBuilderUtils utils) {
        this.buildMethodFactory = buildMethodFactory;
        this.selfMethodFactory = selfMethodFactory;
        this.withMethodFactory = withMethodFactory;
        this.ignoreMethodFactory = ignoreMethodFactory;
        this.nameFactory = nameFactory;
        this.utils = utils;
    }

    List<MethodSpec> generateFieldMethods(Element typeToBuild, String builderClassName) {
        Map<String, ParamType> fields = typeToBuild.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).collect(Collectors.toMap(element -> element.getSimpleName().toString(), this.utils::extractParamType));
        return fields.entrySet().stream().flatMap(e -> this.generateBuilderMethodsForField((String)e.getKey(), (ParamType)e.getValue(), builderClassName)).toList();
    }

    private Stream<MethodSpec> generateBuilderMethodsForField(String fieldName, ParamType paramType, String builderClassName) {
        String withMethodName = this.nameFactory.fieldMethodWithPrefix("with", fieldName);
        String ignoreMethodName = this.nameFactory.fieldMethodWithPrefix("ignore", fieldName);
        return Stream.of(this.withMethodFactory.generateWithMethod(withMethodName, fieldName, paramType, builderClassName), this.ignoreMethodFactory.generateIgnoreMethod(ignoreMethodName, withMethodName, builderClassName, paramType.isPrimitive())).filter(Objects::nonNull);
    }

    public MethodSpec generateSelf(String builderClassName) {
        return this.selfMethodFactory.generateSelf(builderClassName);
    }

    public MethodSpec generateBuild(Element model, String typeToBuild) {
        return this.buildMethodFactory.generateBuild(model, typeToBuild);
    }
}

