/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouterbauweraerts.instancio.fixture.builder.generator;

import com.palantir.javapoet.AnnotationSpec;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.TypeSpec;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.BuilderMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.FactoryProvider;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.FixtureBuilderFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.GeneratedAnnotationFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.JavaFileFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.NameFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.exception.FixtureBuilderGenerationException;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.util.GenerateFixtureBuilderUtils;
import java.io.IOException;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;

public class FixtureBuilderGenerator {
    private static final String BUILDER_FOR_TYPE = "builderForType";
    private static final String FIXTURE_CLASS_TYPE = "fixtureClass";
    private final ProcessingEnvironment processingEnv;
    private final BuilderMethodFactory methodFactory;
    private final NameFactory nameFactory;
    private final FixtureBuilderFactory fixtureBuilderFactory;
    private final JavaFileFactory javaFileFactory;
    private final GeneratedAnnotationFactory generatedAnnotationFactory;
    private final GenerateFixtureBuilderUtils utils;

    public FixtureBuilderGenerator(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.methodFactory = FactoryProvider.builderMethodFactory(processingEnv);
        this.nameFactory = FactoryProvider.nameFactory();
        this.fixtureBuilderFactory = FactoryProvider.fixtureBuilderFactory();
        this.javaFileFactory = FactoryProvider.fileFactory();
        this.generatedAnnotationFactory = FactoryProvider.generatedAnnotationFactory();
        this.utils = new GenerateFixtureBuilderUtils(processingEnv);
    }

    public void generateFixtureBuilders(Element fixtureBuilderElement) {
        AnnotationMirror annotationMirror = this.utils.extractAnnotationMirror(fixtureBuilderElement);
        Element builderForClass = this.utils.getType(annotationMirror, BUILDER_FOR_TYPE);
        Element fixtureClassType = this.utils.getType(annotationMirror, FIXTURE_CLASS_TYPE);
        Element model = this.utils.extractInstancioModel(fixtureClassType);
        String builderClassName = this.nameFactory.fixtureBuilderName(builderForClass.getSimpleName().toString());
        AnnotationSpec generatedAnnotation = this.generatedAnnotationFactory.createAnnotation();
        MethodSpec selfMethod = this.methodFactory.generateSelf(builderClassName);
        MethodSpec buildMethod = this.methodFactory.generateBuild(model, builderForClass.getSimpleName().toString());
        List<MethodSpec> fieldMethods = this.methodFactory.generateFieldMethods(builderForClass, builderClassName);
        TypeSpec fixtureBuilderClassDefinition = this.fixtureBuilderFactory.createBuilderSpec(builderClassName, builderForClass, generatedAnnotation, selfMethod, buildMethod, fieldMethods);
        try {
            this.javaFileFactory.createJavaFile(this.utils.extractPackageName(builderForClass), this.utils.extractPackageName(fixtureClassType), fixtureClassType.getSimpleName().toString(), fixtureBuilderClassDefinition, model.getSimpleName().toString()).writeTo(this.processingEnv.getFiler());
        }
        catch (IOException e) {
            throw FixtureBuilderGenerationException.writeException(e.getMessage());
        }
    }
}

