/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouterbauweraerts.instancio.fixture.builder.generator.util;

import com.palantir.javapoet.TypeName;
import io.github.wouterbauweraerts.instancio.fixture.builder.InstancioModel;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.exception.FixtureBuilderGenerationException;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.parameter.ParamType;
import java.util.Objects;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;

public class GenerateFixtureBuilderUtils {
    static final String GENERATE_FIXTURE_BUILDER_QUALIFIED_NAME = "io.github.wouterbauweraerts.instancio.fixture.builder.GenerateFixtureBuilder";
    private final ProcessingEnvironment processingEnv;

    public GenerateFixtureBuilderUtils(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
    }

    public AnnotationMirror extractAnnotationMirror(Element element) {
        return this.processingEnv.getElementUtils().getAllAnnotationMirrors(element).stream().filter(am -> am.getAnnotationType().toString().equals(GENERATE_FIXTURE_BUILDER_QUALIFIED_NAME)).findFirst().orElseThrow(FixtureBuilderGenerationException::unableToReadAnnotation);
    }

    public Element getType(AnnotationMirror mirror, String keyValue) {
        return this.processingEnv.getElementUtils().getElementValuesWithDefaults(mirror).entrySet().stream().filter(e -> ((ExecutableElement)e.getKey()).getSimpleName().contentEquals(keyValue)).map(e -> ((AnnotationValue)e.getValue()).getValue()).map(it -> this.processingEnv.getTypeUtils().asElement((TypeMirror)it)).findFirst().orElseThrow(() -> FixtureBuilderGenerationException.missingValue(keyValue));
    }

    public Element extractInstancioModel(Element fixtureClassElement) {
        return fixtureClassElement.getEnclosedElements().stream().filter(e -> Objects.nonNull(e.getAnnotation(InstancioModel.class))).findFirst().orElseThrow(FixtureBuilderGenerationException::modelNotFound);
    }

    public String extractPackageName(Element classElement) {
        return this.processingEnv.getElementUtils().getPackageOf(classElement).getQualifiedName().toString();
    }

    public ParamType extractParamType(Element element) {
        boolean isPrimitiveType = element.asType().getKind().isPrimitive();
        if (isPrimitiveType) {
            return ParamType.of(TypeName.get((TypeMirror)element.asType()));
        }
        return ParamType.of(this.processingEnv.getTypeUtils().asElement(element.asType()).toString());
    }
}

