/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouterbauweraerts.instancio.fixture.builder.processor;

import com.google.auto.service.AutoService;
import io.github.wouterbauweraerts.instancio.fixture.builder.GenerateFixtureBuilder;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.FixtureBuilderGenerator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;

@SupportedAnnotationTypes(value={"io.github.wouterbauweraerts.instancio.fixture.builder.GenerateFixtureBuilder"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
@AutoService(value={Processor.class})
public class FixtureBuilderProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        FixtureBuilderGenerator fixtureBuilderGenerator = new FixtureBuilderGenerator(this.processingEnv);
        for (TypeElement typeElement : annotations) {
            if (!typeElement.getQualifiedName().contentEquals(GenerateFixtureBuilder.class.getCanonicalName())) continue;
            Set<? extends Element> annotatedElements = roundEnv.getElementsAnnotatedWith(typeElement);
            Map<Boolean, List<Element>> isProcessableMap = annotatedElements.stream().collect(Collectors.partitioningBy(e -> {
                ElementKind kind = e.getKind();
                return kind.equals((Object)ElementKind.CLASS) || kind.equals((Object)ElementKind.RECORD);
            }));
            isProcessableMap.get(false).forEach(e -> this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "@GenerateFixtureBuilder can only be applied to classes or records", (Element)e));
            List<Element> processableElements = isProcessableMap.get(true);
            if (processableElements.isEmpty()) {
                return false;
            }
            processableElements.forEach(fixtureBuilderGenerator::generateFixtureBuilders);
            return true;
        }
        return false;
    }
}

