/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouterbauweraerts.instancio.fixture.builder.generator;

import com.palantir.javapoet.ClassName;
import com.palantir.javapoet.CodeBlock;
import com.palantir.javapoet.MethodSpec;
import com.palantir.javapoet.TypeName;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.NameFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.util.GenerateFixtureBuilderUtils;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

class ToFixtureBuilderFactory {
    private final NameFactory nameFactory;
    private final GenerateFixtureBuilderUtils utils;

    public ToFixtureBuilderFactory(NameFactory nameFactory, GenerateFixtureBuilderUtils utils) {
        this.nameFactory = nameFactory;
        this.utils = utils;
    }

    public MethodSpec generateToFixtureBuilder(String builderClassName, Element expectedParameterType) {
        return MethodSpec.methodBuilder((String)"toFixtureBuilder").addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.STATIC}).addParameter(TypeName.get((TypeMirror)expectedParameterType.asType()), "obj", new Modifier[]{Modifier.FINAL}).returns((TypeName)ClassName.bestGuess((String)builderClassName)).addCode(this.methodBody(builderClassName, expectedParameterType)).build();
    }

    private CodeBlock methodBody(String builderClassName, Element elementToClone) {
        CodeBlock.Builder builder = CodeBlock.builder().addStatement("$L builder = new $L()", new Object[]{builderClassName, builderClassName});
        builder.add(this.shallowCopyClassFields(elementToClone));
        return builder.addStatement("return builder", new Object[0]).build();
    }

    private CodeBlock shallowCopyClassFields(Element elementToClone) {
        CodeBlock.Builder builder = CodeBlock.builder();
        Stream.concat(elementToClone.getEnclosedElements().stream(), this.inheritedFields(elementToClone)).filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).filter(e -> !e.getModifiers().contains((Object)Modifier.STATIC)).map(e -> new ElementTypeTriple(e.getSimpleName().toString(), e.asType().getKind().equals((Object)TypeKind.BOOLEAN), e.asType().getKind().isPrimitive())).collect(Collectors.toMap(triple -> this.nameFactory.fieldMethodWithPrefix("with", triple.name), triple -> this.getObjFieldValue((ElementTypeTriple)triple, elementToClone))).entrySet().stream().map(e -> "builder.%s(%s)".formatted(e.getKey(), e.getValue())).forEach(x$0 -> builder.addStatement(x$0, new Object[0]));
        return builder.build();
    }

    private Stream<? extends Element> inheritedFields(Element element) {
        Element superclass = this.utils.getSuperclass(element);
        String superClassname = superclass.getSimpleName().toString();
        if (superClassname.equals("Object")) {
            return Stream.empty();
        }
        return Stream.concat(superclass.getEnclosedElements().stream(), this.inheritedFields(superclass));
    }

    private String getObjFieldValue(ElementTypeTriple triple, Element elementToClone) {
        String getMethod = this.nameFactory.fieldMethodWithPrefix(triple.isBoolean() && triple.isPrimitive() ? "is" : "get", triple.name());
        return (elementToClone.getKind().equals((Object)ElementKind.CLASS) ? CodeBlock.builder().addStatement("obj.$L()", new Object[]{getMethod}).build().toString() : CodeBlock.builder().addStatement("obj.$L()", new Object[]{triple.name()}).build().toString()).trim().replace(";", "");
    }

    private record ElementTypeTriple(String name, boolean isBoolean, boolean isPrimitive) {
    }
}

