/*
 * Decompiled with CFR 0.152.
 */
package io.github.wouterbauweraerts.instancio.fixture.builder.generator;

import com.palantir.javapoet.MethodSpec;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.BuildMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.FixtureBuilderMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.IgnoreMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.NameFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.SelfMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.ToFixtureBuilderFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.WithMethodFactory;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.parameter.ParamType;
import io.github.wouterbauweraerts.instancio.fixture.builder.generator.util.GenerateFixtureBuilderUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;

class BuilderMethodFactory {
    private final BuildMethodFactory buildMethodFactory;
    private final SelfMethodFactory selfMethodFactory;
    private final WithMethodFactory withMethodFactory;
    private final IgnoreMethodFactory ignoreMethodFactory;
    private final NameFactory nameFactory;
    private final FixtureBuilderMethodFactory fixtureBuilderMethodFactory;
    private final GenerateFixtureBuilderUtils utils;
    private final ToFixtureBuilderFactory toFixtureBuilderFactory;

    BuilderMethodFactory(BuildMethodFactory buildMethodFactory, SelfMethodFactory selfMethodFactory, WithMethodFactory withMethodFactory, IgnoreMethodFactory ignoreMethodFactory, NameFactory nameFactory, FixtureBuilderMethodFactory fixtureBuilderMethodFactory, ToFixtureBuilderFactory toFixtureBuilderFactory, GenerateFixtureBuilderUtils utils) {
        this.buildMethodFactory = buildMethodFactory;
        this.selfMethodFactory = selfMethodFactory;
        this.withMethodFactory = withMethodFactory;
        this.ignoreMethodFactory = ignoreMethodFactory;
        this.nameFactory = nameFactory;
        this.fixtureBuilderMethodFactory = fixtureBuilderMethodFactory;
        this.toFixtureBuilderFactory = toFixtureBuilderFactory;
        this.utils = utils;
    }

    List<MethodSpec> generateFieldMethods(Element typeToBuild, String builderClassName) {
        Map<String, ParamType> fields = typeToBuild.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).collect(Collectors.toMap(element -> element.getSimpleName().toString(), this.utils::extractParamType));
        Stream currentClassBuilderMethods = fields.entrySet().stream().flatMap(e -> this.generateBuilderMethodsForField((String)e.getKey(), (ParamType)e.getValue(), builderClassName, typeToBuild));
        return Stream.concat(currentClassBuilderMethods, this.generateBuilderMethodsForInheritedFields(typeToBuild, builderClassName)).toList();
    }

    private Stream<MethodSpec> generateBuilderMethodsForInheritedFields(Element type, String builderClassName) {
        Element superclass = this.utils.getSuperclass(type);
        String superClassname = superclass.getSimpleName().toString();
        if (superClassname.equals("Object")) {
            return Stream.empty();
        }
        Map<String, ParamType> fields = superclass.getEnclosedElements().stream().filter(e -> e.getKind().equals((Object)ElementKind.FIELD)).collect(Collectors.toMap(element -> element.getSimpleName().toString(), this.utils::extractParamType));
        return Stream.concat(fields.entrySet().stream().flatMap(e -> this.generateBuilderMethodsForInheritedField((String)e.getKey(), (ParamType)e.getValue(), builderClassName, superClassname)), this.generateBuilderMethodsForInheritedFields(superclass, builderClassName));
    }

    private Stream<MethodSpec> generateBuilderMethodsForField(String fieldName, ParamType paramType, String builderClassName, Element declaringClass) {
        String withMethodName = this.nameFactory.fieldMethodWithPrefix("with", fieldName);
        String ignoreMethodName = this.nameFactory.fieldMethodWithPrefix("ignore", fieldName);
        return Stream.of(this.withMethodFactory.generateWithMethod(withMethodName, fieldName, declaringClass.getSimpleName().toString(), paramType, builderClassName), this.ignoreMethodFactory.generateIgnoreMethod(ignoreMethodName, withMethodName, builderClassName, paramType.isPrimitive())).filter(Objects::nonNull);
    }

    private Stream<MethodSpec> generateBuilderMethodsForInheritedField(String fieldName, ParamType paramType, String builderClassName, String superClassname) {
        String withMethodName = this.nameFactory.fieldMethodWithPrefix("with", fieldName);
        String ignoreMethodName = this.nameFactory.fieldMethodWithPrefix("ignore", fieldName);
        return Stream.of(this.withMethodFactory.generateWithMethod(withMethodName, fieldName, superClassname, paramType, builderClassName), this.ignoreMethodFactory.generateIgnoreMethod(ignoreMethodName, withMethodName, builderClassName, paramType.isPrimitive())).filter(Objects::nonNull);
    }

    public MethodSpec generateSelf(String builderClassName) {
        return this.selfMethodFactory.generateSelf(builderClassName);
    }

    public MethodSpec generateBuild(Element model, String typeToBuild) {
        return this.buildMethodFactory.generateBuild(model, typeToBuild);
    }

    public MethodSpec generateToFixtureBuilder(String builderClassName, Element expectedParameterType) {
        return this.toFixtureBuilderFactory.generateToFixtureBuilder(builderClassName, expectedParameterType);
    }

    public MethodSpec generateFixtureBuilderMethod(String builderClassName) {
        return this.fixtureBuilderMethodFactory.generateFixtureBuilder(builderClassName);
    }
}

