/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.trade.request.AmendBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.AmendOrderRequest;
import com.bybit.api.client.domain.trade.request.BatchOrderRequest;
import com.bybit.api.client.domain.trade.request.CancelAllOrdersRequest;
import com.bybit.api.client.domain.trade.request.CancelBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.CancelOrderRequest;
import com.bybit.api.client.domain.trade.request.PlaceBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.PlaceOrderRequest;
import com.bybit.api.client.domain.trade.request.SetDcpRequest;
import com.bybit.api.client.domain.trade.request.TradeOrderRequest;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.restApi.BybitApiTradeRestClient;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;
import java.io.IOException;
import java.util.Map;

public class BybitApiTradeRestClientImpl
implements BybitApiTradeRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiTradeRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption);
    }

    @Override
    public Object setDisconnectCancelAllTime(TradeOrderRequest tradeOrderRequest) {
        SetDcpRequest setDcpRequest = this.converter.convertMapToDcpRequest(tradeOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.setDisconnectCancelAllTime(setDcpRequest));
    }

    @Override
    public Object getBorrowQuota(TradeOrderRequest borrowQuotaRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getBorrowQuota(borrowQuotaRequest.getCategory().getCategoryTypeId(), borrowQuotaRequest.getSymbol(), borrowQuotaRequest.getSide() == null ? null : borrowQuotaRequest.getSide().getTransactionSide()));
    }

    @Override
    public Object getOrderHistory(TradeOrderRequest orderHistoryRequest) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getOrderHistory(orderHistoryRequest.getCategory().getCategoryTypeId(), orderHistoryRequest.getSymbol(), orderHistoryRequest.getBaseCoin(), orderHistoryRequest.getSettleCoin(), orderHistoryRequest.getOrderId(), orderHistoryRequest.getOrderLinkId(), orderHistoryRequest.getOrderFilter() == null ? null : orderHistoryRequest.getOrderFilter().getOrderFilterType(), orderHistoryRequest.getOrderStatus(), orderHistoryRequest.getStartTime(), orderHistoryRequest.getEndTime(), orderHistoryRequest.getLimit(), orderHistoryRequest.getCursor()));
    }

    @Override
    public Object createOrder(TradeOrderRequest tradeOrderRequest) {
        PlaceOrderRequest singleOrderRequest = this.converter.convertTradeToPlaceOrderRequest(tradeOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createOrder(singleOrderRequest));
    }

    @Override
    public Object createOrder(Map<String, Object> payload) {
        TradeOrderRequest singleOrderRequest = this.converter.convertMapToSingleOrderRequest(payload);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createOrder(placeOrderRequest));
    }

    @Override
    public Object createOrder(String json) throws IOException {
        TradeOrderRequest singleOrderRequest = this.converter.convertJsonToSingleOrderRequest(json);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createOrder(placeOrderRequest));
    }

    @Override
    public Object createBatchOrder(BatchOrderRequest batchOrderRequest) {
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createBatchOrder(placeBatchOrderRequest));
    }

    @Override
    public Object createBathOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createBatchOrder(placeBatchOrderRequest));
    }

    @Override
    public Object createBathOrder(String jsonRequest) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(jsonRequest);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createBatchOrder(placeBatchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(BatchOrderRequest batchOrderRequest) {
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendBatchOrder(amendBatchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendBatchOrder(amendBatchOrderRequest));
    }

    @Override
    public Object amendBatchOrder(String jsonRequest) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(jsonRequest);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendBatchOrder(amendBatchOrderRequest));
    }

    @Override
    public Object amendOrder(TradeOrderRequest order) {
        AmendOrderRequest amendOrderRequest = this.converter.convertTradeToAmendOrderRequest(order);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.amendOrder(amendOrderRequest));
    }

    @Override
    public Object cancelOrder(TradeOrderRequest order) {
        CancelOrderRequest cancelOrderRequest = this.converter.convertTradeToCancelOrderRequest(order);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelOrder(cancelOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(BatchOrderRequest batchOrderRequest) {
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelBatchOrder(cancelBatchOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(Map<String, Object> payload) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelBatchOrder(cancelBatchOrderRequest));
    }

    @Override
    public Object cancelBatchOrder(String json) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelBatchOrder(cancelBatchOrderRequest));
    }

    @Override
    public Object cancelAllOrder(TradeOrderRequest order) {
        CancelAllOrdersRequest cancelAllOrderRequest = this.converter.convertTradeToCancelAllOrdersRequest(order);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.cancelAllOrder(cancelAllOrderRequest));
    }

    @Override
    public Object getOpenOrders(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getOpenOrders(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderId(), order.getOrderLinkId(), order.getOpenOnly(), order.getOrderFilter() == null ? null : order.getOrderFilter().getOrderFilterType(), order.getLimit(), order.getCursor()));
    }

    @Override
    public Object getTradeHistory(TradeOrderRequest order) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getTradeHistory(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getBaseCoin(), order.getStartTime(), order.getEndTime(), order.getExecType() == null ? null : order.getExecType().getExecTypeId(), order.getLimit(), order.getCursor()));
    }
}

