/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.market.request.MarketDataRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncMarketDataRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;

public class BybitApiMarketAsyncRestClientImpl
implements BybitApiAsyncMarketDataRestClient {
    private final BybitApiService bybitApiService;

    public BybitApiMarketAsyncRestClientImpl(String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, baseUrl, debugMode, recvWindow, logOption);
    }

    @Override
    public void getServerTime(BybitApiCallback<Object> callback) {
        this.bybitApiService.getServerTime().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketLinesData(marketKlineRequest.getCategory().getCategoryTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketPriceLinesData(marketKlineRequest.getCategory().getCategoryTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getIndexPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getIndexPriceLinesData(marketKlineRequest.getCategory().getCategoryTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getPremiumIndexPriceLinesData(MarketDataRequest marketKlineRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getPremiumIndexPriceLinesData(marketKlineRequest.getCategory().getCategoryTypeId(), marketKlineRequest.getSymbol(), marketKlineRequest.getMarketInterval() == null ? null : marketKlineRequest.getMarketInterval().getIntervalId(), marketKlineRequest.getStart(), marketKlineRequest.getEnd(), marketKlineRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInstrumentsInfo(MarketDataRequest instrumentInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInstrumentsInfo(instrumentInfoRequest.getCategory().getCategoryTypeId(), instrumentInfoRequest.getSymbol(), instrumentInfoRequest.getInstrumentStatus() == null ? null : instrumentInfoRequest.getInstrumentStatus().getStatus(), instrumentInfoRequest.getBaseCoin(), instrumentInfoRequest.getLimit(), instrumentInfoRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketOrderBook(MarketDataRequest marketOrderBookRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketOrderBook(marketOrderBookRequest.getCategory().getCategoryTypeId(), marketOrderBookRequest.getSymbol(), marketOrderBookRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketTickers(MarketDataRequest marketDataTickerRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketTickers(marketDataTickerRequest.getCategory().getCategoryTypeId(), marketDataTickerRequest.getSymbol(), marketDataTickerRequest.getBaseCoin(), marketDataTickerRequest.getExpDate()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getFundingHistory(MarketDataRequest fundingHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getFundingHistory(fundingHistoryRequest.getCategory().getCategoryTypeId(), fundingHistoryRequest.getSymbol(), fundingHistoryRequest.getStartTime(), fundingHistoryRequest.getEndTime(), fundingHistoryRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getRecentTradeData(MarketDataRequest recentTradeRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getRecentTradeData(recentTradeRequest.getCategory().getCategoryTypeId(), recentTradeRequest.getBaseCoin(), recentTradeRequest.getOptionType() == null ? null : recentTradeRequest.getOptionType().getOpType(), recentTradeRequest.getSymbol(), recentTradeRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getOpenInterest(MarketDataRequest openInterestRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getOpenInterest(openInterestRequest.getCategory().getCategoryTypeId(), openInterestRequest.getSymbol(), openInterestRequest.getMarketInterval() == null ? null : openInterestRequest.getMarketInterval().getIntervalId(), openInterestRequest.getStartTime(), openInterestRequest.getEndTime(), openInterestRequest.getLimit(), openInterestRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getHistoricalVolatility(MarketDataRequest historicalVolatilityRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getHistoricalVolatility(historicalVolatilityRequest.getCategory().getCategoryTypeId(), historicalVolatilityRequest.getBaseCoin(), historicalVolatilityRequest.getOptionPeriod(), historicalVolatilityRequest.getStartTime(), historicalVolatilityRequest.getEndTime()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsurance(MarketDataRequest marketDataRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsurance(marketDataRequest.getCoin()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getInsurance(BybitApiCallback<Object> callback) {
        this.bybitApiService.getInsurance().enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getRiskLimit(MarketDataRequest marketRiskLimitRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getRiskLimit(marketRiskLimitRequest.getCategory().getCategoryTypeId(), marketRiskLimitRequest.getSymbol()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getDeliveryPrice(MarketDataRequest deliveryPriceRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getDeliveryPrice(deliveryPriceRequest.getCategory().getCategoryTypeId(), deliveryPriceRequest.getSymbol(), deliveryPriceRequest.getBaseCoin(), deliveryPriceRequest.getLimit(), deliveryPriceRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getMarketAccountRatio(MarketDataRequest marketAccountRatioRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getMarketAccountRatio(marketAccountRatioRequest.getCategory().getCategoryTypeId(), marketAccountRatioRequest.getSymbol(), marketAccountRatioRequest.getDataRecordingPeriod() == null ? null : marketAccountRatioRequest.getDataRecordingPeriod().getPeriod(), marketAccountRatioRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getAnnouncementInfo(MarketDataRequest announcementInfoRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getAnouncementInfo(announcementInfoRequest.getLocale() == null ? null : announcementInfoRequest.getLocale().getLanguageSymbol(), announcementInfoRequest.getType() == null ? null : announcementInfoRequest.getType().getAnnouncementType(), announcementInfoRequest.getTag() == null ? null : announcementInfoRequest.getTag().getEnglishTranslation(), announcementInfoRequest.getPage(), announcementInfoRequest.getLimit()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

