/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.domain.trade.request.AmendBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.AmendOrderRequest;
import com.bybit.api.client.domain.trade.request.BatchOrderRequest;
import com.bybit.api.client.domain.trade.request.CancelAllOrdersRequest;
import com.bybit.api.client.domain.trade.request.CancelBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.CancelOrderRequest;
import com.bybit.api.client.domain.trade.request.PlaceBatchOrderRequest;
import com.bybit.api.client.domain.trade.request.PlaceOrderRequest;
import com.bybit.api.client.domain.trade.request.SetDcpRequest;
import com.bybit.api.client.domain.trade.request.TradeOrderRequest;
import com.bybit.api.client.impl.BybitApiCallbackAdapter;
import com.bybit.api.client.restApi.BybitApiAsyncTradeRestClient;
import com.bybit.api.client.restApi.BybitApiCallback;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;
import java.io.IOException;
import java.util.Map;

public class BybitApiTradeAsyncRestClientImpl
implements BybitApiAsyncTradeRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiTradeAsyncRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption, String referer) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, referer);
    }

    @Override
    public void getOrderHistory(TradeOrderRequest orderHistoryRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getOrderHistory(orderHistoryRequest.getCategory().getCategoryTypeId(), orderHistoryRequest.getSymbol(), orderHistoryRequest.getBaseCoin(), orderHistoryRequest.getSettleCoin(), orderHistoryRequest.getOrderId(), orderHistoryRequest.getOrderLinkId(), orderHistoryRequest.getOrderFilter() == null ? null : orderHistoryRequest.getOrderFilter().getOrderFilterType(), orderHistoryRequest.getOrderStatus(), orderHistoryRequest.getStartTime(), orderHistoryRequest.getEndTime(), orderHistoryRequest.getLimit(), orderHistoryRequest.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void setDisconnectCancelAllTime(TradeOrderRequest orderRequest, BybitApiCallback<Object> callback) {
        SetDcpRequest setDcpRequest = this.converter.convertMapToDcpRequest(orderRequest);
        this.bybitApiService.setDisconnectCancelAllTime(setDcpRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getBorrowQuota(TradeOrderRequest borrowQuotaRequest, BybitApiCallback<Object> callback) {
        this.bybitApiService.getBorrowQuota(borrowQuotaRequest.getCategory().getCategoryTypeId(), borrowQuotaRequest.getSymbol(), borrowQuotaRequest.getSide() == null ? null : borrowQuotaRequest.getSide().getTransactionSide()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getOpenOrders(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.getOpenOrders(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getBaseCoin(), order.getSettleCoin(), order.getOrderId(), order.getOrderLinkId(), order.getOpenOnly(), order.getOrderFilter() == null ? null : order.getOrderFilter().getOrderFilterType(), order.getLimit(), order.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void getTradeHistory(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        this.bybitApiService.getTradeHistory(order.getCategory().getCategoryTypeId(), order.getSymbol(), order.getOrderId(), order.getOrderLinkId(), order.getBaseCoin(), order.getStartTime(), order.getEndTime(), order.getExecType() == null ? null : order.getExecType().getExecTypeId(), order.getLimit(), order.getCursor()).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(order);
        this.bybitApiService.createOrder(placeOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(Map<String, Object> order, BybitApiCallback<Object> callback) {
        TradeOrderRequest singleOrderRequest = this.converter.convertMapToSingleOrderRequest(order);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        this.bybitApiService.createOrder(placeOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createOrder(String order, BybitApiCallback<Object> callback) throws IOException {
        TradeOrderRequest singleOrderRequest = this.converter.convertJsonToSingleOrderRequest(order);
        PlaceOrderRequest placeOrderRequest = this.converter.convertTradeToPlaceOrderRequest(singleOrderRequest);
        this.bybitApiService.createOrder(placeOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBatchOrder(BatchOrderRequest batchOrderRequest, BybitApiCallback<Object> callback) {
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.createBatchOrder(placeBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBathOrder(Map<String, Object> payload, BybitApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.createBatchOrder(placeBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void createBathOrder(String json, BybitApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        PlaceBatchOrderRequest placeBatchOrderRequest = this.converter.convertToPlaceBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.createBatchOrder(placeBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(BatchOrderRequest batchOrderRequest, BybitApiCallback<Object> callback) {
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.amendBatchOrder(amendBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(Map<String, Object> payload, BybitApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.amendBatchOrder(amendBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendBatchOrder(String json, BybitApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        AmendBatchOrderRequest amendBatchOrderRequest = this.converter.convertToAmendBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.amendBatchOrder(amendBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(BatchOrderRequest batchOrderRequest, BybitApiCallback<Object> callback) {
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.cancelBatchOrder(cancelBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(Map<String, Object> payload, BybitApiCallback<Object> callback) {
        BatchOrderRequest batchOrderRequest = this.converter.convertMapToBatchOrderRequest(payload);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.cancelBatchOrder(cancelBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelBatchOrder(String json, BybitApiCallback<Object> callback) throws IOException {
        BatchOrderRequest batchOrderRequest = this.converter.jsonToBatchOrderRequest(json);
        CancelBatchOrderRequest cancelBatchOrderRequest = this.converter.convertToCancelBatchOrderRequest(batchOrderRequest);
        this.bybitApiService.cancelBatchOrder(cancelBatchOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        CancelOrderRequest cancelOrderRequest = this.converter.convertTradeToCancelOrderRequest(order);
        this.bybitApiService.cancelOrder(cancelOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void cancelAllOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        CancelAllOrdersRequest cancelAllOrderRequest = this.converter.convertTradeToCancelAllOrdersRequest(order);
        this.bybitApiService.cancelAllOrder(cancelAllOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }

    @Override
    public void amendOrder(TradeOrderRequest order, BybitApiCallback<Object> callback) {
        AmendOrderRequest amendOrderRequest = this.converter.convertTradeToAmendOrderRequest(order);
        this.bybitApiService.amendOrder(amendOrderRequest).enqueue(new BybitApiCallbackAdapter<Object>(callback));
    }
}

