/*
 * Decompiled with CFR 0.152.
 */
package com.bybit.api.client.impl;

import com.bybit.api.client.constant.Helper;
import com.bybit.api.client.domain.preupgrade.PreUpgradeDataRequest;
import com.bybit.api.client.domain.user.UserDataRequest;
import com.bybit.api.client.domain.user.request.CreateApiKeyRequest;
import com.bybit.api.client.domain.user.request.FreezeSubUIDRquest;
import com.bybit.api.client.domain.user.request.ModifyApiKeyRequest;
import com.bybit.api.client.domain.user.request.UserSubMemberRequest;
import com.bybit.api.client.restApi.BybitApiService;
import com.bybit.api.client.restApi.BybitApiUserRestClient;
import com.bybit.api.client.service.BybitApiServiceGenerator;
import com.bybit.api.client.service.BybitJsonConverter;

public class BybitApiUserRestClientImpl
implements BybitApiUserRestClient {
    private final BybitApiService bybitApiService;
    private final BybitJsonConverter converter = new BybitJsonConverter();

    public BybitApiUserRestClientImpl(String apiKey, String secret, String baseUrl, boolean debugMode, long recvWindow, String logOption) {
        this.bybitApiService = BybitApiServiceGenerator.createService(BybitApiService.class, apiKey, secret, baseUrl, debugMode, recvWindow, logOption, "");
    }

    @Override
    public Object getCurrentAPIKeyInfo() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getCurrentAPIKeyInfo());
    }

    @Override
    public Object getSubUIDList() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getSubUIDList());
    }

    @Override
    public Object createSubMember(UserDataRequest request) {
        UserSubMemberRequest subUserRequest = this.converter.mapToCreateSubMemberRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createSubMember(subUserRequest));
    }

    @Override
    public Object createSubAPI(UserDataRequest request) {
        CreateApiKeyRequest createApiKeyRequest = this.converter.mapToCreateSubApiRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.createSubAPI(createApiKeyRequest));
    }

    @Override
    public Object freezeSubMember(UserDataRequest request) {
        FreezeSubUIDRquest freezeSubUIDRquest = this.converter.mapToFreezeSubApiRequest(request);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.freezeSubMember(freezeSubUIDRquest));
    }

    @Override
    public Object getUIDWalletType(UserDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getUIDWalletType(request.getMemberIds() == null ? null : Helper.listToString(request.getMemberIds())));
    }

    @Override
    public Object modifyMasterApiKey(UserDataRequest userDataRequest) {
        ModifyApiKeyRequest modifyMasterApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifyMasterApiKey(modifyMasterApiKeyRequest));
    }

    @Override
    public Object modifySubApiKey(UserDataRequest userDataRequest) {
        ModifyApiKeyRequest modifySubApiKeyRequest = this.converter.mapToModifyApiKeyRequest(userDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.modifySubApiKey(modifySubApiKeyRequest));
    }

    @Override
    public Object deleteMasterApiKey() {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.deleteMasterApiKey());
    }

    @Override
    public Object deleteSubApiKey(UserDataRequest userDataRequest) {
        ModifyApiKeyRequest deleteSubApiKeyRequest = this.converter.mapToDeleteSubApiKeyRequest(userDataRequest);
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.deleteSubApiKey(deleteSubApiKeyRequest));
    }

    @Override
    public Object getAffiliateUserInfo(UserDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getAffiliateUserInfo(request.getUid()));
    }

    @Override
    public Object getPreUpgradeClosePnl(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeClosePnl(request.getCategory().getCategoryTypeId(), request.getSymbol(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeOrderHistory(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeOrderHistory(request.getCategory().getCategoryTypeId(), request.getSymbol(), request.getBaseCoin(), request.getOrderId(), request.getOrderLinkId(), request.getOrderFilter(), request.getOrderStatus() == null ? null : request.getOrderStatus().getDescription(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeTradeHistory(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeTradeHistory(request.getCategory().getCategoryTypeId(), request.getSymbol(), request.getOrderId(), request.getOrderLinkId(), request.getBaseCoin(), request.getStartTime(), request.getEndTime(), request.getExecType() == null ? null : request.getExecType().getExecTypeId(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeTransaction(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeTransaction(request.getCategory().getCategoryTypeId(), request.getBaseCoin(), request.getTransactionType() == null ? null : request.getTransactionType().getTransactionTypeId(), request.getStartTime(), request.getEndTime(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeOptionDelivery(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeOptionDelivery(request.getCategory().getCategoryTypeId(), request.getSymbol(), request.getExpDate(), request.getLimit(), request.getCursor()));
    }

    @Override
    public Object getPreUpgradeUsdcSettlement(PreUpgradeDataRequest request) {
        return BybitApiServiceGenerator.executeSync(this.bybitApiService.getPreUpgradeUsdcSettlement(request.getCategory().getCategoryTypeId(), request.getSymbol(), request.getLimit(), request.getCursor()));
    }
}

