/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx.internal.procedure;

import com.android.build.api.transform.TransformInvocation;
import com.hujiang.gradle.plugin.android.aspectjx.AJXExtension;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.AJXUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0005!\"#$%B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0010R\u0011\u0010\u0016\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\fR\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\f\u00a8\u0006&"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext;", "", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "compileOptions", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$CompileOptions;", "extension", "Lcom/hujiang/gradle/plugin/android/aspectjx/AJXExtension;", "(Lcom/android/build/api/transform/TransformInvocation;Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$CompileOptions;Lcom/hujiang/gradle/plugin/android/aspectjx/AJXExtension;)V", "aspectFilesDir", "Ljava/io/File;", "getAspectFilesDir", "()Ljava/io/File;", "buildConfig", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$BuildConfig;", "getBuildConfig", "()Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$BuildConfig;", "buildConfigCacheFile", "getCompileOptions", "()Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$CompileOptions;", "lastBuildConfig", "getLastBuildConfig", "logsDir", "getLogsDir", "temporaryDir", "getTransformInvocation", "()Lcom/android/build/api/transform/TransformInvocation;", "weaveTmpDir", "getWeaveTmpDir", "isAspectFilesChanged", "", "saveBuildConfig", "", "AspectFile", "BuildConfig", "CompileOptions", "MatchedInput", "WeaveOutput", "aspectjx"})
public final class ProcedureContext {
    @NotNull
    private final TransformInvocation transformInvocation;
    @NotNull
    private final CompileOptions compileOptions;
    @NotNull
    private final File temporaryDir;
    @NotNull
    private final File logsDir;
    @NotNull
    private final File aspectFilesDir;
    @NotNull
    private final File weaveTmpDir;
    @NotNull
    private final File buildConfigCacheFile;
    @NotNull
    private final BuildConfig lastBuildConfig;
    @NotNull
    private final BuildConfig buildConfig;

    public ProcedureContext(@NotNull TransformInvocation transformInvocation, @NotNull CompileOptions compileOptions, @NotNull AJXExtension extension) {
        BuildConfig buildConfig;
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        Intrinsics.checkNotNullParameter((Object)compileOptions, (String)"compileOptions");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        this.transformInvocation = transformInvocation;
        this.compileOptions = compileOptions;
        File file = this.transformInvocation.getContext().getTemporaryDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"transformInvocation.context.temporaryDir");
        this.temporaryDir = file;
        this.logsDir = new File(this.temporaryDir, "logs");
        this.aspectFilesDir = new File(this.temporaryDir, "aspectFiles");
        this.weaveTmpDir = new File(this.temporaryDir, "weaveTmp");
        this.buildConfigCacheFile = new File(this.temporaryDir, "buildConfigCache.json");
        this.buildConfig = new BuildConfig();
        if (!this.transformInvocation.isIncremental()) {
            this.transformInvocation.getOutputProvider().deleteAll();
            FileUtils.deleteDirectory((File)this.temporaryDir);
        }
        this.lastBuildConfig = BuildConfig.Companion.loadBuildConfig(this.buildConfigCacheFile);
        BuildConfig $this$_init__u24lambda_u2d0 = buildConfig = this.buildConfig;
        boolean bl = false;
        $this$_init__u24lambda_u2d0.setExtension(extension);
        $this$_init__u24lambda_u2d0.getAspectFiles().addAll((Collection<AspectFile>)this.lastBuildConfig.getAspectFiles());
        $this$_init__u24lambda_u2d0.getMatchedInputs().addAll((Collection<MatchedInput>)this.lastBuildConfig.getMatchedInputs());
        $this$_init__u24lambda_u2d0.getWeaveOutputs().addAll((Collection<WeaveOutput>)this.lastBuildConfig.getWeaveOutputs());
    }

    @NotNull
    public final TransformInvocation getTransformInvocation() {
        return this.transformInvocation;
    }

    @NotNull
    public final CompileOptions getCompileOptions() {
        return this.compileOptions;
    }

    @NotNull
    public final File getLogsDir() {
        return this.logsDir;
    }

    @NotNull
    public final File getAspectFilesDir() {
        return this.aspectFilesDir;
    }

    @NotNull
    public final File getWeaveTmpDir() {
        return this.weaveTmpDir;
    }

    @NotNull
    public final BuildConfig getLastBuildConfig() {
        return this.lastBuildConfig;
    }

    @NotNull
    public final BuildConfig getBuildConfig() {
        return this.buildConfig;
    }

    public final boolean isAspectFilesChanged() {
        return !Intrinsics.areEqual(this.buildConfig.getAspectFiles(), this.lastBuildConfig.getAspectFiles());
    }

    public final void saveBuildConfig() {
        FileUtils.write((File)this.buildConfigCacheFile, (CharSequence)AJXUtils.INSTANCE.optToJsonString(this.buildConfig), (String)"UTF-8");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B#\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$AspectFile;", "", "source", "", "target", "lastModified", "", "(Ljava/lang/String;Ljava/lang/String;J)V", "getLastModified", "()J", "setLastModified", "(J)V", "getSource", "()Ljava/lang/String;", "setSource", "(Ljava/lang/String;)V", "getTarget", "setTarget", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aspectjx"})
    public static final class AspectFile {
        @NotNull
        private String source;
        @NotNull
        private String target;
        private long lastModified;

        public AspectFile(@NotNull String source, @NotNull String target, long lastModified) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.source = source;
            this.target = target;
            this.lastModified = lastModified;
        }

        public /* synthetic */ AspectFile(String string, String string2, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                string2 = "";
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(string, string2, l);
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final void setSource(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.source = string;
        }

        @NotNull
        public final String getTarget() {
            return this.target;
        }

        public final void setTarget(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.target = string;
        }

        public final long getLastModified() {
            return this.lastModified;
        }

        public final void setLastModified(long l) {
            this.lastModified = l;
        }

        @NotNull
        public final String component1() {
            return this.source;
        }

        @NotNull
        public final String component2() {
            return this.target;
        }

        public final long component3() {
            return this.lastModified;
        }

        @NotNull
        public final AspectFile copy(@NotNull String source, @NotNull String target, long lastModified) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            return new AspectFile(source, target, lastModified);
        }

        public static /* synthetic */ AspectFile copy$default(AspectFile aspectFile, String string, String string2, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = aspectFile.source;
            }
            if ((n & 2) != 0) {
                string2 = aspectFile.target;
            }
            if ((n & 4) != 0) {
                l = aspectFile.lastModified;
            }
            return aspectFile.copy(string, string2, l);
        }

        @NotNull
        public String toString() {
            return "AspectFile(source=" + this.source + ", target=" + this.target + ", lastModified=" + this.lastModified + ')';
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = result * 31 + this.target.hashCode();
            result = result * 31 + Long.hashCode(this.lastModified);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AspectFile)) {
                return false;
            }
            AspectFile aspectFile = (AspectFile)other;
            if (!Intrinsics.areEqual((Object)this.source, (Object)aspectFile.source)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.target, (Object)aspectFile.target)) {
                return false;
            }
            return this.lastModified == aspectFile.lastModified;
        }

        public AspectFile() {
            this(null, null, 0L, 7, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0010"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$MatchedInput;", "", "source", "", "(Ljava/lang/String;)V", "getSource", "()Ljava/lang/String;", "setSource", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "aspectjx"})
    public static final class MatchedInput {
        @NotNull
        private String source;

        public MatchedInput(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
        }

        public /* synthetic */ MatchedInput(String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            this(string);
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final void setSource(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.source = string;
        }

        @NotNull
        public final String component1() {
            return this.source;
        }

        @NotNull
        public final MatchedInput copy(@NotNull String source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return new MatchedInput(source);
        }

        public static /* synthetic */ MatchedInput copy$default(MatchedInput matchedInput, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = matchedInput.source;
            }
            return matchedInput.copy(string);
        }

        @NotNull
        public String toString() {
            return "MatchedInput(source=" + this.source + ')';
        }

        public int hashCode() {
            return this.source.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MatchedInput)) {
                return false;
            }
            MatchedInput matchedInput = (MatchedInput)other;
            return Intrinsics.areEqual((Object)this.source, (Object)matchedInput.source);
        }

        public MatchedInput() {
            this(null, 1, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\t\n\u0002\b\u0012\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0007H\u00c6\u0003J-\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001f"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$WeaveOutput;", "", "source", "", "outputFiles", "", "costMillis", "", "(Ljava/lang/String;Ljava/util/List;J)V", "getCostMillis", "()J", "setCostMillis", "(J)V", "getOutputFiles", "()Ljava/util/List;", "setOutputFiles", "(Ljava/util/List;)V", "getSource", "()Ljava/lang/String;", "setSource", "(Ljava/lang/String;)V", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "aspectjx"})
    public static final class WeaveOutput {
        @NotNull
        private String source;
        @NotNull
        private List<String> outputFiles;
        private long costMillis;

        public WeaveOutput(@NotNull String source, @NotNull List<String> outputFiles, long costMillis) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
            this.source = source;
            this.outputFiles = outputFiles;
            this.costMillis = costMillis;
        }

        public /* synthetic */ WeaveOutput(String string, List list, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                string = "";
            }
            if ((n & 2) != 0) {
                list = new ArrayList();
            }
            if ((n & 4) != 0) {
                l = 0L;
            }
            this(string, list, l);
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        public final void setSource(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.source = string;
        }

        @NotNull
        public final List<String> getOutputFiles() {
            return this.outputFiles;
        }

        public final void setOutputFiles(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.outputFiles = list;
        }

        public final long getCostMillis() {
            return this.costMillis;
        }

        public final void setCostMillis(long l) {
            this.costMillis = l;
        }

        @NotNull
        public final String component1() {
            return this.source;
        }

        @NotNull
        public final List<String> component2() {
            return this.outputFiles;
        }

        public final long component3() {
            return this.costMillis;
        }

        @NotNull
        public final WeaveOutput copy(@NotNull String source, @NotNull List<String> outputFiles, long costMillis) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
            return new WeaveOutput(source, outputFiles, costMillis);
        }

        public static /* synthetic */ WeaveOutput copy$default(WeaveOutput weaveOutput, String string, List list, long l, int n, Object object) {
            if ((n & 1) != 0) {
                string = weaveOutput.source;
            }
            if ((n & 2) != 0) {
                list = weaveOutput.outputFiles;
            }
            if ((n & 4) != 0) {
                l = weaveOutput.costMillis;
            }
            return weaveOutput.copy(string, list, l);
        }

        @NotNull
        public String toString() {
            return "WeaveOutput(source=" + this.source + ", outputFiles=" + this.outputFiles + ", costMillis=" + this.costMillis + ')';
        }

        public int hashCode() {
            int result = this.source.hashCode();
            result = result * 31 + ((Object)this.outputFiles).hashCode();
            result = result * 31 + Long.hashCode(this.costMillis);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof WeaveOutput)) {
                return false;
            }
            WeaveOutput weaveOutput = (WeaveOutput)other;
            if (!Intrinsics.areEqual((Object)this.source, (Object)weaveOutput.source)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.outputFiles, weaveOutput.outputFiles)) {
                return false;
            }
            return this.costMillis == weaveOutput.costMillis;
        }

        public WeaveOutput() {
            this(null, null, 0L, 7, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0006\"\u0004\b\u0015\u0010\bR\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0006\"\u0004\b\u0018\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$CompileOptions;", "", "()V", "bootClassPath", "", "getBootClassPath", "()Ljava/lang/String;", "setBootClassPath", "(Ljava/lang/String;)V", "encoding", "getEncoding", "setEncoding", "javaCompileClasspath", "", "Ljava/io/File;", "getJavaCompileClasspath", "()Ljava/util/Set;", "setJavaCompileClasspath", "(Ljava/util/Set;)V", "sourceCompatibility", "getSourceCompatibility", "setSourceCompatibility", "targetCompatibility", "getTargetCompatibility", "setTargetCompatibility", "aspectjx"})
    public static final class CompileOptions {
        @NotNull
        private String encoding = "";
        @NotNull
        private String bootClassPath = "";
        @NotNull
        private String sourceCompatibility = "";
        @NotNull
        private String targetCompatibility = "";
        @NotNull
        private Set<File> javaCompileClasspath = new LinkedHashSet();

        @NotNull
        public final String getEncoding() {
            return this.encoding;
        }

        public final void setEncoding(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.encoding = string;
        }

        @NotNull
        public final String getBootClassPath() {
            return this.bootClassPath;
        }

        public final void setBootClassPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.bootClassPath = string;
        }

        @NotNull
        public final String getSourceCompatibility() {
            return this.sourceCompatibility;
        }

        public final void setSourceCompatibility(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.sourceCompatibility = string;
        }

        @NotNull
        public final String getTargetCompatibility() {
            return this.targetCompatibility;
        }

        public final void setTargetCompatibility(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.targetCompatibility = string;
        }

        @NotNull
        public final Set<File> getJavaCompileClasspath() {
            return this.javaCompileClasspath;
        }

        public final void setJavaCompileClasspath(@NotNull Set<File> set) {
            Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
            this.javaCompileClasspath = set;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 02\u00020\u0001:\u00010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0018\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J\u000e\u0010 \u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010!\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00042\u0006\u0010$\u001a\u00020%J\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\u000e\u0010)\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010*\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010-\u001a\u00020\u0019J\u000e\u0010.\u001a\u00020'2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010/\u001a\u00020\u0019R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0007\"\u0004\b\u0013\u0010\tR \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0007\"\u0004\b\u0017\u0010\t\u00a8\u00061"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$BuildConfig;", "", "()V", "aspectFiles", "", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$AspectFile;", "getAspectFiles", "()Ljava/util/List;", "setAspectFiles", "(Ljava/util/List;)V", "extension", "Lcom/hujiang/gradle/plugin/android/aspectjx/AJXExtension;", "getExtension", "()Lcom/hujiang/gradle/plugin/android/aspectjx/AJXExtension;", "setExtension", "(Lcom/hujiang/gradle/plugin/android/aspectjx/AJXExtension;)V", "matchedInputs", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$MatchedInput;", "getMatchedInputs", "setMatchedInputs", "weaveOutputs", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$WeaveOutput;", "getWeaveOutputs", "setWeaveOutputs", "addAspectFile", "", "source", "Ljava/io/File;", "target", "classBytes", "", "addAspectFileToList", "addMatchedInput", "addWeaveOutput", "outputFiles", "", "costTimeMillis", "", "existAspectFiles", "", "isEnable", "isMatchedInput", "removeAspectFile", "removeAspectFiles", "removeMatchedInput", "removeMatchedInputs", "removeWeaveOutput", "removeWeaveOutputs", "Companion", "aspectjx"})
    public static final class BuildConfig {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private AJXExtension extension = new AJXExtension();
        @NotNull
        private List<AspectFile> aspectFiles = new ArrayList();
        @NotNull
        private List<MatchedInput> matchedInputs = new ArrayList();
        @NotNull
        private List<WeaveOutput> weaveOutputs = new ArrayList();

        @NotNull
        public final AJXExtension getExtension() {
            return this.extension;
        }

        public final void setExtension(@NotNull AJXExtension aJXExtension) {
            Intrinsics.checkNotNullParameter((Object)aJXExtension, (String)"<set-?>");
            this.extension = aJXExtension;
        }

        @NotNull
        public final List<AspectFile> getAspectFiles() {
            return this.aspectFiles;
        }

        public final void setAspectFiles(@NotNull List<AspectFile> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.aspectFiles = list;
        }

        @NotNull
        public final List<MatchedInput> getMatchedInputs() {
            return this.matchedInputs;
        }

        public final void setMatchedInputs(@NotNull List<MatchedInput> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.matchedInputs = list;
        }

        @NotNull
        public final List<WeaveOutput> getWeaveOutputs() {
            return this.weaveOutputs;
        }

        public final void setWeaveOutputs(@NotNull List<WeaveOutput> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.weaveOutputs = list;
        }

        public final boolean existAspectFiles() {
            return !((Collection)this.aspectFiles).isEmpty();
        }

        public final boolean isEnable() {
            return this.extension.getEnabled();
        }

        public final void addAspectFile(@NotNull File source, @NotNull File target, @NotNull byte[] classBytes) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            Intrinsics.checkNotNullParameter((Object)classBytes, (String)"classBytes");
            FileUtils.writeByteArrayToFile((File)target, (byte[])classBytes);
            this.addAspectFileToList(source, target);
        }

        public final void addAspectFile(@NotNull File source, @NotNull File target) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            FileUtils.copyFile((File)source, (File)target);
            this.addAspectFileToList(source, target);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void addAspectFileToList(File source, File target) {
            AspectFile aspectFile;
            AspectFile $this$addAspectFileToList_u24lambda_u2d0 = aspectFile = new AspectFile(null, null, 0L, 7, null);
            boolean bl = false;
            String string = source.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.absolutePath");
            $this$addAspectFileToList_u24lambda_u2d0.setSource(string);
            String string2 = target.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"target.absolutePath");
            $this$addAspectFileToList_u24lambda_u2d0.setTarget(string2);
            $this$addAspectFileToList_u24lambda_u2d0.setLastModified(target.lastModified());
            AspectFile aspectFile2 = aspectFile;
            List<AspectFile> list = this.aspectFiles;
            synchronized (list) {
                boolean bl2 = false;
                boolean bl3 = this.aspectFiles.add(aspectFile2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean removeAspectFile(@NotNull File source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            List<AspectFile> list = this.aspectFiles;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.aspectFiles.removeIf(arg_0 -> BuildConfig.removeAspectFile$lambda-3$lambda-2(source, arg_0));
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeAspectFiles() {
            List<AspectFile> list = this.aspectFiles;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.aspectFiles.removeIf(BuildConfig::removeAspectFiles$lambda-5$lambda-4);
            }
        }

        public final boolean isMatchedInput(@NotNull File source) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Iterable $this$firstOrNull$iv = this.matchedInputs;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MatchedInput it = (MatchedInput)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getSource(), (Object)source.getAbsolutePath())) continue;
                    v0 = element$iv;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addMatchedInput(@NotNull File source) {
            MatchedInput matchedInput;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            MatchedInput $this$addMatchedInput_u24lambda_u2d7 = matchedInput = new MatchedInput(null, 1, null);
            boolean bl = false;
            String string = source.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.absolutePath");
            $this$addMatchedInput_u24lambda_u2d7.setSource(string);
            MatchedInput matchedInput2 = matchedInput;
            List<MatchedInput> list = this.matchedInputs;
            synchronized (list) {
                boolean bl2 = false;
                boolean bl3 = this.matchedInputs.add(matchedInput2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean removeMatchedInput(@NotNull File source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            List<MatchedInput> list = this.matchedInputs;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.matchedInputs.removeIf(arg_0 -> BuildConfig.removeMatchedInput$lambda-10$lambda-9(source, arg_0));
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeMatchedInputs() {
            List<MatchedInput> list = this.matchedInputs;
            synchronized (list) {
                boolean bl = false;
                this.matchedInputs.clear();
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void addWeaveOutput(@NotNull File source, @NotNull List<String> outputFiles, long costTimeMillis) {
            WeaveOutput weaveOutput;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter(outputFiles, (String)"outputFiles");
            WeaveOutput $this$addWeaveOutput_u24lambda_u2d12 = weaveOutput = new WeaveOutput(null, null, 0L, 7, null);
            boolean bl = false;
            String string = source.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"source.absolutePath");
            $this$addWeaveOutput_u24lambda_u2d12.setSource(string);
            $this$addWeaveOutput_u24lambda_u2d12.setOutputFiles(outputFiles);
            $this$addWeaveOutput_u24lambda_u2d12.setCostMillis(costTimeMillis);
            WeaveOutput weaveOutput2 = weaveOutput;
            List<WeaveOutput> list = this.weaveOutputs;
            synchronized (list) {
                boolean bl2 = false;
                boolean bl3 = this.weaveOutputs.add(weaveOutput2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean removeWeaveOutput(@NotNull File source) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            List<WeaveOutput> list = this.weaveOutputs;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.weaveOutputs.removeIf(arg_0 -> BuildConfig.removeWeaveOutput$lambda-15$lambda-14(source, arg_0));
                return bl2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void removeWeaveOutputs() {
            List<WeaveOutput> list = this.weaveOutputs;
            synchronized (list) {
                boolean bl = false;
                boolean bl2 = this.weaveOutputs.removeIf(BuildConfig::removeWeaveOutputs$lambda-17$lambda-16);
            }
        }

        private static final boolean removeAspectFile$lambda-3$lambda-2(File $source, AspectFile it) {
            Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean matched = Intrinsics.areEqual((Object)it.getSource(), (Object)$source.getAbsolutePath());
            if (matched) {
                FileUtils.deleteQuietly((File)new File(it.getTarget()));
            }
            return matched;
        }

        private static final boolean removeAspectFiles$lambda-5$lambda-4(AspectFile it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            FileUtils.deleteQuietly((File)new File(it.getTarget()));
            return true;
        }

        private static final boolean removeMatchedInput$lambda-10$lambda-9(File $source, MatchedInput it) {
            Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getSource(), (Object)$source.getAbsolutePath());
        }

        private static final boolean removeWeaveOutput$lambda-15$lambda-14(File $source, WeaveOutput it) {
            Intrinsics.checkNotNullParameter((Object)$source, (String)"$source");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            boolean matched = Intrinsics.areEqual((Object)it.getSource(), (Object)$source.getAbsolutePath());
            if (matched) {
                for (String outputFile : it.getOutputFiles()) {
                    FileUtils.deleteQuietly((File)new File(outputFile));
                }
            }
            return matched;
        }

        private static final boolean removeWeaveOutputs$lambda-17$lambda-16(WeaveOutput it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            for (String outputFile : it.getOutputFiles()) {
                FileUtils.deleteQuietly((File)new File(outputFile));
            }
            return true;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$BuildConfig$Companion;", "", "()V", "loadBuildConfig", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext$BuildConfig;", "buildConfigCacheFile", "Ljava/io/File;", "aspectjx"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BuildConfig loadBuildConfig(@NotNull File buildConfigCacheFile) {
                BuildConfig buildConfig;
                Intrinsics.checkNotNullParameter((Object)buildConfigCacheFile, (String)"buildConfigCacheFile");
                if (buildConfigCacheFile.exists()) {
                    String jsonString = FileUtils.readFileToString((File)buildConfigCacheFile);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonString, (String)"jsonString");
                    buildConfig = AJXUtils.INSTANCE.optFromJsonString(jsonString, BuildConfig.class);
                    if (buildConfig == null) {
                        buildConfig = new BuildConfig();
                    }
                } else {
                    buildConfig = new BuildConfig();
                }
                return buildConfig;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

