/*
 * Decompiled with CFR 0.152.
 */
package com.hujiang.gradle.plugin.android.aspectjx.internal.procedure;

import com.android.build.api.transform.DirectoryInput;
import com.android.build.api.transform.JarInput;
import com.android.build.api.transform.QualifiedContent;
import com.android.build.api.transform.Status;
import com.android.build.api.transform.TransformInput;
import com.android.build.api.transform.TransformInvocation;
import com.hujiang.gradle.plugin.android.aspectjx.AJXExtension;
import com.hujiang.gradle.plugin.android.aspectjx.internal.concurrent.BatchTaskScheduler;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.AbsProcedure;
import com.hujiang.gradle.plugin.android.aspectjx.internal.procedure.ProcedureContext;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.AJXUtils;
import com.hujiang.gradle.plugin.android.aspectjx.internal.utils.AJXUtilsKt;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0019\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/PrepareProcedure;", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/AbsProcedure;", "procedureContext", "Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext;", "(Lcom/hujiang/gradle/plugin/android/aspectjx/internal/procedure/ProcedureContext;)V", "collect", "", "inputFile", "Ljava/io/File;", "qualifiedContent", "Lcom/android/build/api/transform/QualifiedContent;", "collectClasspath", "transformInvocation", "Lcom/android/build/api/transform/TransformInvocation;", "collectFromDirectoryInput", "file", "dirInput", "Lcom/android/build/api/transform/DirectoryInput;", "collectFromJarInput", "collectMatchedInput", "doCollectForIncrement", "status", "Lcom/android/build/api/transform/Status;", "doWorkContinuously", "", "prepare", "aspectjx"})
public final class PrepareProcedure
extends AbsProcedure {
    public PrepareProcedure(@NotNull ProcedureContext procedureContext) {
        Intrinsics.checkNotNullParameter((Object)procedureContext, (String)"procedureContext");
        super(procedureContext);
    }

    @Override
    public boolean doWorkContinuously(@NotNull TransformInvocation transformInvocation) {
        Intrinsics.checkNotNullParameter((Object)transformInvocation, (String)"transformInvocation");
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        boolean enable = buildConfig.isEnable();
        if (!enable) {
            this.logQuiet("aspect disable!!! Remove buildConfig cache.");
            buildConfig.removeAspectFiles();
            buildConfig.removeMatchedInputs();
            buildConfig.removeWeaveOutputs();
            return true;
        }
        this.prepare(transformInvocation);
        return true;
    }

    private final void prepare(TransformInvocation transformInvocation) {
        BatchTaskScheduler batchTaskScheduler = new BatchTaskScheduler(0, 1, null);
        boolean isIncremental = transformInvocation.isIncremental();
        this.collectClasspath(transformInvocation);
        Collection collection = transformInvocation.getInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"transformInvocation.inputs");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransformInput input = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput dirInput = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                if (isIncremental) {
                    Map $this$forEach$iv3;
                    Intrinsics.checkNotNullExpressionValue((Object)dirInput.getChangedFiles(), (String)"dirInput.changedFiles");
                    boolean $i$f$forEach3 = false;
                    Iterator iterator = $this$forEach$iv3.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv3;
                        Map.Entry entry = element$iv3 = iterator.next();
                        boolean bl3 = false;
                        File inputFile = (File)entry.getKey();
                        Status status = (Status)entry.getValue();
                        batchTaskScheduler.schedule((Function0<Unit>)((Function0)new Function0<Unit>(this, inputFile, dirInput, status){
                            final /* synthetic */ PrepareProcedure this$0;
                            final /* synthetic */ File $inputFile;
                            final /* synthetic */ DirectoryInput $dirInput;
                            final /* synthetic */ Status $status;
                            {
                                this.this$0 = $receiver;
                                this.$inputFile = $inputFile;
                                this.$dirInput = $dirInput;
                                this.$status = $status;
                                super(0);
                            }

                            public final void invoke() {
                                File file = this.$inputFile;
                                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"inputFile");
                                DirectoryInput directoryInput = this.$dirInput;
                                Intrinsics.checkNotNullExpressionValue((Object)directoryInput, (String)"dirInput");
                                QualifiedContent qualifiedContent = (QualifiedContent)directoryInput;
                                Status status = this.$status;
                                Intrinsics.checkNotNullExpressionValue((Object)status, (String)"status");
                                PrepareProcedure.access$doCollectForIncrement(this.this$0, file, qualifiedContent, status);
                            }
                        }));
                    }
                    continue;
                }
                File file = dirInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dirInput.file");
                AJXUtilsKt.eachFileRecurse(file, (Function1<? super File, Unit>)((Function1)new Function1<File, Unit>(batchTaskScheduler, this, dirInput){
                    final /* synthetic */ BatchTaskScheduler $batchTaskScheduler;
                    final /* synthetic */ PrepareProcedure this$0;
                    final /* synthetic */ DirectoryInput $dirInput;
                    {
                        this.$batchTaskScheduler = $batchTaskScheduler;
                        this.this$0 = $receiver;
                        this.$dirInput = $dirInput;
                        super(1);
                    }

                    public final void invoke(@NotNull File inputFile) {
                        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
                        this.$batchTaskScheduler.schedule((Function0<Unit>)((Function0)new Function0<Unit>(this.this$0, inputFile, this.$dirInput){
                            final /* synthetic */ PrepareProcedure this$0;
                            final /* synthetic */ File $inputFile;
                            final /* synthetic */ DirectoryInput $dirInput;
                            {
                                this.this$0 = $receiver;
                                this.$inputFile = $inputFile;
                                this.$dirInput = $dirInput;
                                super(0);
                            }

                            public final void invoke() {
                                DirectoryInput directoryInput = this.$dirInput;
                                Intrinsics.checkNotNullExpressionValue((Object)directoryInput, (String)"dirInput");
                                PrepareProcedure.access$doCollectForIncrement(this.this$0, this.$inputFile, (QualifiedContent)directoryInput, Status.ADDED);
                            }
                        }));
                    }
                }));
            }
            Collection collection3 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"input.jarInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl4 = false;
                batchTaskScheduler.schedule((Function0<Unit>)((Function0)new Function0<Unit>(jarInput, isIncremental, this){
                    final /* synthetic */ JarInput $jarInput;
                    final /* synthetic */ boolean $isIncremental;
                    final /* synthetic */ PrepareProcedure this$0;
                    {
                        this.$jarInput = $jarInput;
                        this.$isIncremental = $isIncremental;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        File inputFile = this.$jarInput.getFile();
                        if (this.$isIncremental) {
                            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                            JarInput jarInput = this.$jarInput;
                            Intrinsics.checkNotNullExpressionValue((Object)jarInput, (String)"jarInput");
                            QualifiedContent qualifiedContent = (QualifiedContent)jarInput;
                            Status status = this.$jarInput.getStatus();
                            Intrinsics.checkNotNullExpressionValue((Object)status, (String)"jarInput.status");
                            PrepareProcedure.access$doCollectForIncrement(this.this$0, inputFile, qualifiedContent, status);
                        } else {
                            Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                            JarInput jarInput = this.$jarInput;
                            Intrinsics.checkNotNullExpressionValue((Object)jarInput, (String)"jarInput");
                            PrepareProcedure.access$doCollectForIncrement(this.this$0, inputFile, (QualifiedContent)jarInput, Status.ADDED);
                        }
                    }
                }));
            }
        }
        batchTaskScheduler.execute();
        batchTaskScheduler.shutDown();
    }

    private final void collectClasspath(TransformInvocation transformInvocation) {
        Set<File> javaCompileClasspath = this.getProcedureContext().getCompileOptions().getJavaCompileClasspath();
        Collection collection = transformInvocation.getReferencedInputs();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"transformInvocation.referencedInputs");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TransformInput input = (TransformInput)element$iv;
            boolean bl = false;
            Collection collection2 = input.getDirectoryInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"input.directoryInputs");
            Iterable $this$forEach$iv2 = collection2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DirectoryInput dirInput = (DirectoryInput)element$iv2;
                boolean bl2 = false;
                File file = dirInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"dirInput.file");
                javaCompileClasspath.add(file);
                this.logInfo("collectClasspath scope:" + dirInput.getScopes() + ",dirInput=" + dirInput.getFile());
            }
            Collection collection3 = input.getJarInputs();
            Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"input.jarInputs");
            $this$forEach$iv2 = collection3;
            $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                JarInput jarInput = (JarInput)element$iv2;
                boolean bl3 = false;
                File inputFile = jarInput.getFile();
                Intrinsics.checkNotNullExpressionValue((Object)inputFile, (String)"inputFile");
                javaCompileClasspath.add(inputFile);
                this.logInfo("collectClasspath scope:" + jarInput.getScopes() + ",jarInput=" + inputFile);
            }
        }
    }

    private final void doCollectForIncrement(File inputFile, QualifiedContent qualifiedContent, Status status) {
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        switch (WhenMappings.$EnumSwitchMapping$0[status.ordinal()]) {
            case 1: {
                this.collect(inputFile, qualifiedContent);
                break;
            }
            case 2: {
                if (buildConfig.removeAspectFile(inputFile)) {
                    this.logQuiet("remove aspect file from:" + inputFile.getAbsolutePath());
                }
                buildConfig.removeMatchedInput(inputFile);
                this.collect(inputFile, qualifiedContent);
                break;
            }
            case 3: {
                if (buildConfig.removeAspectFile(inputFile)) {
                    this.logQuiet("remove aspect file from:" + inputFile.getAbsolutePath());
                }
                buildConfig.removeMatchedInput(inputFile);
            }
        }
    }

    private final void collect(File inputFile, QualifiedContent qualifiedContent) {
        QualifiedContent qualifiedContent2 = qualifiedContent;
        if (qualifiedContent2 instanceof DirectoryInput) {
            this.collectFromDirectoryInput(inputFile, (DirectoryInput)qualifiedContent);
        } else if (qualifiedContent2 instanceof JarInput) {
            this.collectFromJarInput(inputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void collectFromJarInput(File inputFile) {
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        AJXExtension extension = this.getProcedureContext().getBuildConfig().getExtension();
        List<String> includes = extension.getIncludes();
        List<String> excludes = extension.getExcludes();
        Closeable closeable = new JarFile(inputFile);
        Throwable throwable = null;
        try {
            JarFile jarFile = (JarFile)closeable;
            boolean bl = false;
            Enumeration<JarEntry> entries = jarFile.entries();
            boolean isIncludeMatched = false;
            boolean isExcludeMatched = false;
            while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                String entryName = jarEntry.getName();
                if (jarEntry.isDirectory() || !AJXUtils.INSTANCE.isClassFile(entryName)) continue;
                InputStream inputStream = jarFile.getInputStream(jarEntry);
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"jarFile.getInputStream(jarEntry)");
                byte[] bytes = ByteStreamsKt.readBytes((InputStream)inputStream);
                if (AJXUtils.INSTANCE.isAspectClass(bytes)) {
                    this.logQuiet("collect aspect file[" + entryName + "] from JarInput:" + inputFile);
                    File target = new File(this.getProcedureContext().getAspectFilesDir(), entryName);
                    buildConfig.addAspectFile(inputFile, target, bytes);
                }
                Intrinsics.checkNotNullExpressionValue((Object)entryName, (String)"entryName");
                String tranEntryName = StringsKt.replace$default((String)StringsKt.replace$default((String)entryName, (String)"/", (String)".", (boolean)false, (int)4, null), (String)"\\", (String)".", (boolean)false, (int)4, null);
                if (!isExcludeMatched && !isIncludeMatched) {
                    isIncludeMatched = AJXUtils.INSTANCE.isIncludeFilterMatched(tranEntryName, includes);
                }
                if (isExcludeMatched) continue;
                isExcludeMatched = AJXUtils.INSTANCE.isExcludeFilterMatched(tranEntryName, excludes);
            }
            if (isIncludeMatched && !isExcludeMatched) {
                buildConfig.addMatchedInput(inputFile);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void collectFromDirectoryInput(File file, DirectoryInput dirInput) {
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        String path = file.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
        String string = path.substring(dirInput.getFile().getAbsolutePath().length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        String subPath = string;
        if (AJXUtils.INSTANCE.isAspectClass(file)) {
            this.logQuiet("collect aspect file from DirectoryInput:" + file);
            File targetFile = new File(this.getProcedureContext().getAspectFilesDir(), subPath);
            buildConfig.addAspectFile(file, targetFile);
        }
        this.collectMatchedInput(file, (QualifiedContent)dirInput);
    }

    private final void collectMatchedInput(File inputFile, QualifiedContent qualifiedContent) {
        ProcedureContext.BuildConfig buildConfig = this.getProcedureContext().getBuildConfig();
        AJXExtension extension = this.getProcedureContext().getBuildConfig().getExtension();
        List<String> includes = extension.getIncludes();
        List<String> excludes = extension.getExcludes();
        QualifiedContent qualifiedContent2 = qualifiedContent;
        if (qualifiedContent2 instanceof DirectoryInput) {
            boolean matched;
            if (!AJXUtils.INSTANCE.isClassFile(inputFile)) {
                return;
            }
            String string = inputFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"inputFile.absolutePath");
            String string2 = string;
            int n = ((DirectoryInput)qualifiedContent).getFile().getAbsolutePath().length();
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String string4 = File.separator;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"separator");
            String packagePath = StringsKt.replace$default((String)string3, (String)string4, (String)".", (boolean)false, (int)4, null);
            boolean bl = matched = AJXUtils.INSTANCE.isIncludeFilterMatched(packagePath, includes) && !AJXUtils.INSTANCE.isExcludeFilterMatched(packagePath, excludes);
            if (matched) {
                buildConfig.addMatchedInput(inputFile);
            }
        } else if (qualifiedContent2 instanceof JarInput && AJXUtils.INSTANCE.isJarInputMatched((JarInput)qualifiedContent, includes, excludes)) {
            buildConfig.addMatchedInput(inputFile);
        }
    }

    public static final /* synthetic */ void access$doCollectForIncrement(PrepareProcedure $this, File inputFile, QualifiedContent qualifiedContent, Status status) {
        $this.doCollectForIncrement(inputFile, qualifiedContent, status);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Status.values().length];
            nArray[Status.ADDED.ordinal()] = 1;
            nArray[Status.CHANGED.ordinal()] = 2;
            nArray[Status.REMOVED.ordinal()] = 3;
            nArray[Status.NOTCHANGED.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

