/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http;

import io.github.wycst.wast.clients.http.AbstractHttpClient;
import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.definition.HttpClientMethod;
import io.github.wycst.wast.clients.http.definition.HttpClientParameter;
import io.github.wycst.wast.clients.http.definition.HttpClientRequest;
import io.github.wycst.wast.clients.http.definition.HttpClientResponse;
import io.github.wycst.wast.clients.http.impl.HttpClientDelete;
import io.github.wycst.wast.clients.http.impl.HttpClientGet;
import io.github.wycst.wast.clients.http.impl.HttpClientPost;
import io.github.wycst.wast.clients.http.impl.HttpClientPut;
import io.github.wycst.wast.clients.http.impl.HttpClientRequestBuilder;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpClient
extends AbstractHttpClient {
    public static HttpClient create() {
        return new HttpClient();
    }

    public <E> E request(String url, HttpClientMethod method, Class<E> rtnType) {
        HttpClientRequest httpRequest = HttpClientRequestBuilder.buildRequest(url, method);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public <E> E request(String url, HttpClientMethod method, Class<E> rtnType, HttpClientConfig requestConfig) {
        HttpClientRequest httpRequest = HttpClientRequestBuilder.buildRequest(url, method, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse get(String url) {
        return this.get(url, HttpClientResponse.class);
    }

    public <E> E get(String url, Class<E> rtnType) {
        HttpClientGet httpRequest = new HttpClientGet(url);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public String stringify(Map<String, Object> params) {
        StringBuilder builder = new StringBuilder();
        int length = params.size();
        int i = 0;
        for (String key : params.keySet()) {
            String value = params.get(key).toString();
            try {
                builder.append(URLEncoder.encode(key, "UTF-8")).append('=').append(URLEncoder.encode(value, "UTF-8"));
            }
            catch (Throwable throwable) {
                builder.append(key).append('=').append(value);
            }
            if (i++ >= length - 1) continue;
            builder.append('&');
        }
        return builder.toString();
    }

    public <E> E get(String url, Map<String, Object> params, Class<E> rtnType) {
        if (params != null && params.size() > 0) {
            String paramString = this.stringify(params);
            url = url.indexOf("?") > -1 ? url + "&" + paramString : url + "?" + paramString;
        }
        HttpClientGet httpRequest = new HttpClientGet(url);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public <E> E get(String url, Class<E> rtnType, HttpClientConfig requestConfig) {
        HttpClientGet httpRequest = new HttpClientGet(url, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse post(String url) {
        return this.post(url, HttpClientResponse.class);
    }

    public <E> E post(String url, Class<E> rtnType) {
        HttpClientPost httpRequest = new HttpClientPost(url);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse post(String url, HttpClientConfig requestConfig) {
        return this.post(url, HttpClientResponse.class, requestConfig);
    }

    public <E> E post(String url, Class<E> rtnType, HttpClientConfig requestConfig) {
        HttpClientPost httpRequest = new HttpClientPost(url, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse upload(String url, HttpClientConfig requestConfig) {
        return this.upload(url, HttpClientResponse.class, requestConfig);
    }

    public <E> E upload(String url, Class<E> rtnType, HttpClientConfig requestConfig) {
        HttpClientPost httpRequest = new HttpClientPost(url, requestConfig);
        httpRequest.setMultipart(true);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public <E> E upload(String url, Class<E> rtnType, HttpClientParameter ... clientParameters) {
        HttpClientConfig requestConfig = new HttpClientConfig();
        requestConfig.addTextParameters(clientParameters);
        HttpClientPost httpRequest = new HttpClientPost(url, requestConfig);
        httpRequest.setMultipart(true);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public <E> E put(String url, Class<E> rtnType) {
        HttpClientPut httpRequest = new HttpClientPut(url);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse put(String url, HttpClientConfig requestConfig) {
        return this.put(url, HttpClientResponse.class, requestConfig);
    }

    public <E> E put(String url, Class<E> rtnType, HttpClientConfig requestConfig) {
        HttpClientPut httpRequest = new HttpClientPut(url, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse postJson(String url, Object entity) {
        return this.postJson(url, HttpClientResponse.class, entity);
    }

    public <E> E postJson(String url, Class<E> rtnType, Object entity) {
        HttpClientConfig requestConfig = new HttpClientConfig();
        requestConfig.setRequestBody(entity, "application/json", true);
        HttpClientPost httpRequest = new HttpClientPost(url, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse putJson(String url, Object entity) {
        return this.putJson(url, HttpClientResponse.class, entity);
    }

    public <E> E putJson(String url, Class<E> rtnType, Object entity) {
        HttpClientConfig requestConfig = new HttpClientConfig();
        requestConfig.setRequestBody(entity, "application/json", true);
        HttpClientPut httpRequest = new HttpClientPut(url, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public HttpClientResponse delete(String url) {
        return this.delete(url, HttpClientResponse.class);
    }

    public <E> E delete(String url, Class<E> rtnType) {
        HttpClientDelete httpRequest = new HttpClientDelete(url);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public <E> E delete(String url, Map<String, Object> params, Class<E> rtnType) {
        if (params != null && params.size() > 0) {
            String paramString = this.stringify(params);
            url = url.indexOf("?") > -1 ? url + "&" + paramString : url + "?" + paramString;
        }
        HttpClientDelete httpRequest = new HttpClientDelete(url);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }

    public <E> E delete(String url, Class<E> rtnType, HttpClientConfig requestConfig) {
        HttpClientDelete httpRequest = new HttpClientDelete(url, requestConfig);
        HttpClientResponse httpResponse = this.executeRequest(httpRequest);
        return httpResponse.getEntity(rtnType);
    }
}

