/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.impl;

import io.github.wycst.wast.clients.http.definition.HttpClientException;
import io.github.wycst.wast.clients.http.definition.HttpClientRequest;
import io.github.wycst.wast.clients.http.loadbalance.LoadBalanceStrategy;
import io.github.wycst.wast.clients.http.loadbalance.PollingLoadBalanceStrategy;
import io.github.wycst.wast.clients.http.provider.ServerZone;
import io.github.wycst.wast.clients.http.provider.ServiceInstance;
import io.github.wycst.wast.clients.http.provider.ServiceProvider;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultServiceProvider
implements ServiceProvider {
    private final Map<String, ServerZone> servers;
    private LoadBalanceStrategy loadBalanceStrategy;

    public DefaultServiceProvider() {
        this(new LinkedHashMap<String, ServerZone>());
    }

    public DefaultServiceProvider(Map<String, ServerZone> servers) {
        if (servers == null) {
            throw new HttpClientException(" servers is null ");
        }
        this.servers = servers;
        this.loadBalanceStrategy = new PollingLoadBalanceStrategy();
    }

    @Override
    public final void setLoadBalanceStrategy(LoadBalanceStrategy loadBalanceStrategy) {
        this.loadBalanceStrategy = loadBalanceStrategy;
    }

    @Override
    public final void registerServer(ServerZone serverZone) {
        this.servers.put(serverZone.getServerName(), serverZone);
    }

    @Override
    public final ServiceInstance getServiceInstance(HttpClientRequest httpRequest) throws MalformedURLException {
        URL url = httpRequest.getURL();
        if (!httpRequest.isUseDefaultPort()) {
            return null;
        }
        String hostname = url.getHost();
        if (this.ifExist(hostname)) {
            ServiceInstance serviceInstance = this.loadBalanceStrategy.select(this.getServer(hostname));
            return serviceInstance;
        }
        return null;
    }

    @Override
    public final ServerZone getServer(String serviceName) {
        return this.servers.get(serviceName);
    }

    @Override
    public final void clear() {
        this.servers.clear();
    }

    @Override
    public final void clearIfNotExist(List<String> doms) {
        ArrayList<String> serviceList = new ArrayList<String>(this.servers.keySet());
        for (String serviceName : serviceList) {
            ServerZone serverZone;
            if (doms.contains(serviceName) || (serverZone = this.servers.get(serviceName)).isStaticServer()) continue;
            this.servers.remove(serviceName);
        }
    }

    private boolean ifExist(String serverName) {
        return this.servers.containsKey(serverName);
    }

    @Override
    public void destroy() {
        this.clear();
    }
}

