/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.loadbalance;

import io.github.wycst.wast.clients.http.loadbalance.LoadBalanceStrategy;
import io.github.wycst.wast.clients.http.provider.ServerZone;
import io.github.wycst.wast.clients.http.provider.ServiceInstance;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLoadBalanceStrategy
implements LoadBalanceStrategy {
    public abstract ServiceInstance doSelect(List<ServiceInstance> var1, ServerZone var2);

    @Override
    public ServiceInstance select(ServerZone serverZone) {
        String serverName = serverZone.getServerName();
        List<ServiceInstance> instances = serverZone.getServiceInstances();
        this.checkIf(instances, "No instances available for " + serverName);
        ArrayList<ServiceInstance> aliveInstances = new ArrayList<ServiceInstance>();
        for (ServiceInstance serviceInstance : instances) {
            if (serviceInstance == null || !serviceInstance.isAlive()) continue;
            aliveInstances.add(serviceInstance);
        }
        this.checkIf(aliveInstances, "No instances alive for " + serverName);
        return this.doSelect(aliveInstances, serverZone);
    }

    private void checkIf(List<ServiceInstance> instances, String msg) {
        if (instances == null || instances.size() == 0) {
            throw new IllegalStateException(msg);
        }
    }
}

