/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.http.provider.nacos;

import io.github.wycst.wast.clients.http.HttpClient;
import io.github.wycst.wast.clients.http.definition.HttpClientConfig;
import io.github.wycst.wast.clients.http.impl.DefaultServiceProvider;
import io.github.wycst.wast.clients.http.provider.ServerZone;
import io.github.wycst.wast.clients.http.provider.nacos.ServiceInstanceResponse;
import io.github.wycst.wast.clients.http.provider.nacos.ServiceListResponse;
import io.github.wycst.wast.common.utils.ExecutorServiceUtils;
import io.github.wycst.wast.json.JSON;
import io.github.wycst.wast.log.Log;
import io.github.wycst.wast.log.LogFactory;
import io.github.wycst.wast.yaml.YamlDocument;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class NacosServiceProvider
extends DefaultServiceProvider {
    private static Log log = LogFactory.getLog(NacosServiceProvider.class);
    private final HttpClient httpClient = new HttpClient();
    private final ScheduledExecutorService scheduledExecutorService;
    private final Properties nacosProperties;
    private FetchPropertiesCallback fetchPropertiesCallback;
    private final String CLOUD_NACOS_SERVER_ADDR_KEY = "cloud.nacos.server_addr";
    private final String CLOUD_NACOS_USERNAME_KEY = "cloud.nacos.username";
    private final String CLOUD_NACOS_PASSWORD_KEY = "cloud.nacos.password";
    private final String CLOUD_NACOS_AUTH_KEY = "cloud.nacos.auth.enabled";
    private final String CLOUD_NACOS_CONFIG_DATAID_KEY = "cloud.nacos.config.dataIds";
    private final String CLOUD_NACOS_CONFIG_GROUP_KEY = "cloud.nacos.config.groups";
    private final String CLOUD_NACOS_CONFIG_TENANT_KEY = "cloud.nacos.config.tenants";
    private final String CLOUD_NACOS_INSTANCE_IP_KEY = "cloud.nacos.instance.ip";
    private final String CLOUD_NACOS_INSTANCE_SERVICE_NAME_KEY = "cloud.nacos.instance.serviceName";
    private final String CLOUD_NACOS_INSTANCE_SERVICE_PORT_KEY = "cloud.nacos.instance.servicePort";
    private final String CLOUD_NACOS_INSTANCE_NAMESPACE_ID_KEY = "cloud.nacos.instance.namespaceId";
    private final String CLOUD_NACOS_INSTANCE_BEAT_METHOD_KEY = "cloud.nacos.instance.beat.method";
    private final String CLOUD_NACOS_INSTANCE_CHECK_HEALTHY_INTERVAL_KEY = "cloud.nacos.instance.checkHealthyInterval";
    private final String CLOUD_NACOS_INSTANCE_ENABLE_KEY = "cloud.nacos.instance.enable";
    private String serverAddr;
    private String username;
    private String password;
    private boolean auth;
    private String accessTokenKeyAndValue = "";
    private String nacosServerName;
    private boolean enableNacosClient;
    private String[] dataIds;
    private String[] groups;
    private String[] tenants;
    private int configCount;
    private boolean instanceBeatByRegister;
    private String instanceIp;
    private String instanceServiceName;
    private String instancePort;
    private String instanceNamespaceId;
    private long instanceCheckHealthyInterval;
    private boolean instanceEnable;
    private boolean status;
    private final long serviceUpdateInterval = 60L;
    private String nacosAuthUrl;
    private String nacosInstanceUrl;
    private String nacosConfigsUrl;
    private String nacosCheckHealthyUrl;
    private ServiceListResponse serviceListResponse;

    public NacosServiceProvider(Properties nacosProperties) {
        nacosProperties.getClass();
        this.nacosProperties = nacosProperties;
        this.scheduledExecutorService = Executors.newScheduledThreadPool(1);
        this.resolverProperties();
    }

    public void setFetchPropertiesCallback(FetchPropertiesCallback fetchPropertiesCallback) {
        this.fetchPropertiesCallback = fetchPropertiesCallback;
    }

    private void resolverProperties() {
        this.init();
        if (!this.enableNacosClient) {
            return;
        }
        this.fetchConfig();
        this.setHttpClientServiceProvider();
        this.beginFetchService();
        this.initInstanceInfo();
        if (this.instanceEnable) {
            this.registerServiceInstance();
            this.beginHealthyCheck();
        }
    }

    private void beginFetchService() {
        this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                if (NacosServiceProvider.this.status) {
                    NacosServiceProvider.this.fetchServiceInstanceList();
                }
            }
        }, 0L, this.serviceUpdateInterval, TimeUnit.SECONDS);
        this.scheduledExecutorService.execute(new Runnable(){

            public void run() {
                NacosServiceProvider.this.fetchServiceInstanceList();
            }
        });
    }

    private void setHttpClientServiceProvider() {
        this.httpClient.setServiceProvider(this);
        this.httpClient.setEnableLoadBalance(true);
    }

    private void fetchServiceInstanceList() {
        try {
            String serviceListUrl = String.format("http://%s/nacos/v1/ns/service/list?pageNo=1&pageSize=100000&%s", this.nacosServerName, this.accessTokenKeyAndValue);
            if (this.instanceNamespaceId != null) {
                serviceListUrl = serviceListUrl + "&namespaceId=" + this.instanceNamespaceId;
            }
            this.serviceListResponse = this.httpClient.get(serviceListUrl, ServiceListResponse.class);
            List<String> doms = this.serviceListResponse.getDoms();
            this.clearIfNotExist(doms);
            for (String serviceName : doms) {
                String instanceListUrl = String.format("http://%s/nacos/v1/ns/instance/list?serviceName=%s&healthyOnly=true&%s", this.nacosServerName, serviceName, this.accessTokenKeyAndValue);
                if (this.instanceNamespaceId != null) {
                    instanceListUrl = instanceListUrl + "&namespaceId=" + this.instanceNamespaceId;
                }
                ServiceInstanceResponse serviceInstanceResponse = this.httpClient.get(instanceListUrl, ServiceInstanceResponse.class);
                List<Map> hosts = serviceInstanceResponse.getHosts();
                ArrayList<String> serviceUrls = new ArrayList<String>();
                if (hosts == null || hosts.size() <= 0) continue;
                for (Map host : hosts) {
                    String ip = (String)host.get("ip");
                    Integer port = (Integer)host.get("port");
                    serviceUrls.add(ip + ":" + port);
                }
                ServerZone serverZone = new ServerZone(serviceName, serviceUrls);
                this.registerServer(serverZone);
            }
        }
        catch (Throwable throwable) {
            log.debug("fetchServiceInstanceList error: {}", throwable.getMessage());
        }
    }

    public void shutdownExecutorService() {
        ExecutorServiceUtils.shutdownExecutorService(this.scheduledExecutorService);
    }

    private void beginHealthyCheck() {
        if (this.instanceCheckHealthyInterval > 0L) {
            this.scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

                public void run() {
                    NacosServiceProvider.this.doHealthyCheck();
                }
            }, 0L, this.instanceCheckHealthyInterval, TimeUnit.SECONDS);
        }
    }

    private void doHealthyCheck() {
        try {
            if (!this.status) {
                this.registerServiceInstance();
            } else if (this.instanceBeatByRegister) {
                this.registerServiceInstance();
            } else {
                HashMap<String, String> beatInfo = new HashMap<String, String>();
                beatInfo.put("port", this.instancePort);
                beatInfo.put("ip", this.instanceIp);
                beatInfo.put("port", this.instancePort);
                beatInfo.put("serviceName", this.instanceServiceName);
                beatInfo.put("namespaceId", this.instanceNamespaceId);
                beatInfo.put("healthy", "true");
                beatInfo.put("weight", "1.0");
                HttpClientConfig requestConfig = new HttpClientConfig();
                requestConfig.addTextParameter("serviceName", this.instanceServiceName);
                requestConfig.addTextParameter("ephemeral", "false");
                requestConfig.addTextParameter("beat", JSON.toJsonString(beatInfo));
                Map result = this.httpClient.put(this.nacosCheckHealthyUrl, Map.class, requestConfig);
                this.status = result != null && result.containsKey("clientBeatInterval");
                log.debug("healthy check result: {}", result);
            }
        }
        catch (Throwable throwable) {
            this.status = false;
            log.debug("healthy check error: {}", throwable.getMessage());
        }
    }

    private void fetchConfig() {
        log.info("configCount {}", this.configCount);
        if (this.configCount > 0) {
            for (int i = 0; i < this.configCount; ++i) {
                try {
                    String dataId = this.dataIds[i].trim();
                    boolean isYaml = dataId.toLowerCase().endsWith(".yml") || dataId.toLowerCase().endsWith(".yaml");
                    String configUrl = String.format("%sdataId=%s&group=%s&tenant=%s", this.nacosConfigsUrl, dataId, this.groups[i], this.tenants[i]);
                    log.info("fetch configUrl {}", configUrl);
                    InputStream is = this.httpClient.get(configUrl, InputStream.class);
                    if (this.fetchPropertiesCallback == null) continue;
                    if (isYaml) {
                        Properties properties = YamlDocument.loadProperties(is);
                        this.fetchPropertiesCallback.loadProperties(properties);
                        continue;
                    }
                    this.fetchPropertiesCallback.loadProperties(is);
                    continue;
                }
                catch (Throwable throwable) {
                    log.debug(throwable.getMessage(), new Object[0]);
                }
            }
        }
    }

    public Properties fetchConfig(String dataId, String group, String tenant) throws IOException {
        boolean isYaml = dataId.toLowerCase().endsWith(".yml") || dataId.toLowerCase().endsWith(".yaml");
        String configUrl = String.format("%sdataId=%s&group=%s&tenant=%s", this.nacosConfigsUrl, dataId, group, tenant);
        log.info("fetch configUrl {}", configUrl);
        InputStream is = this.httpClient.get(configUrl, InputStream.class);
        if (isYaml) {
            return YamlDocument.loadProperties(is);
        }
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    private void registerServiceInstance() {
        try {
            HttpClientConfig requestConfig = new HttpClientConfig();
            requestConfig.addTextParameter("port", this.instancePort);
            requestConfig.addTextParameter("ip", this.instanceIp);
            requestConfig.addTextParameter("serviceName", this.instanceServiceName);
            requestConfig.addTextParameter("namespaceId", this.instanceNamespaceId);
            requestConfig.addTextParameter("healthy", "true");
            requestConfig.addTextParameter("weight", "1.0");
            requestConfig.addTextParameter("metadata", "{}");
            String result = this.httpClient.post(this.nacosInstanceUrl, String.class, requestConfig);
            log.debug("result {}", result);
            this.status = "OK".equalsIgnoreCase(result);
        }
        catch (Throwable throwable) {
            log.debug("nacos register fail - {}", this.nacosInstanceUrl);
            log.debug(throwable.getMessage(), new Object[0]);
        }
    }

    private void init() {
        this.serverAddr = this.getProperty("cloud.nacos.server_addr");
        if (this.serverAddr == null) {
            log.info("nacos config {} is required ", "cloud.nacos.server_addr");
            return;
        }
        this.enableNacosClient = true;
        log.info("nacos serverAddr {}", this.serverAddr);
        this.username = this.getProperty("cloud.nacos.username");
        this.password = this.getProperty("cloud.nacos.password");
        this.auth = "true".equals(this.getProperty("cloud.nacos.auth.enabled"));
        if (this.serverAddr.indexOf(",") == -1) {
            this.nacosAuthUrl = String.format("http://%s/nacos/v1/auth/login", this.serverAddr);
            this.nacosInstanceUrl = String.format("http://%s/nacos/v1/ns/instance", this.serverAddr);
            this.nacosCheckHealthyUrl = String.format("http://%s/nacos/v1/ns/instance/beat", this.serverAddr);
            this.nacosConfigsUrl = String.format("http://%s/nacos/v1/cs/configs?", this.serverAddr);
            this.nacosServerName = this.serverAddr;
        } else {
            String[] servers = this.serverAddr.split(",");
            this.nacosServerName = "nacos-cluster";
            ServerZone serverZone = new ServerZone(this.nacosServerName, servers, true);
            this.setHttpClientServiceProvider();
            this.registerServer(serverZone);
            this.nacosAuthUrl = String.format("http://%s/nacos/v1/auth/login", this.nacosServerName);
            this.nacosInstanceUrl = String.format("http://%s/nacos/v1/ns/instance", this.nacosServerName);
            this.nacosCheckHealthyUrl = String.format("http://%s/nacos/v1/ns/instance/beat", this.nacosServerName);
            this.nacosConfigsUrl = String.format("http://%s/nacos/v1/cs/configs?", this.nacosServerName);
        }
        log.info("cloud.nacos.auth.enabled {}", this.auth);
        if (this.auth) {
            HttpClientConfig clientConfig = new HttpClientConfig();
            clientConfig.addTextParameter("username", this.username);
            clientConfig.addTextParameter("password", this.password);
            String accessTokenKeyAndValue = "";
            try {
                Map map = this.httpClient.post(this.nacosAuthUrl, Map.class, clientConfig);
                if (map != null && map.containsKey("accessToken")) {
                    String accessToken = map.get("accessToken").toString();
                    accessTokenKeyAndValue = "accessToken=" + accessToken;
                    this.nacosInstanceUrl = this.nacosInstanceUrl + "?" + accessTokenKeyAndValue;
                    this.nacosCheckHealthyUrl = this.nacosCheckHealthyUrl + "?" + accessTokenKeyAndValue;
                    this.nacosConfigsUrl = this.nacosConfigsUrl + accessTokenKeyAndValue + "&";
                } else {
                    log.warn("Failed to get Nacos accessToken ", new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.accessTokenKeyAndValue = accessTokenKeyAndValue;
        }
        this.initConfigParams();
    }

    private void initInstanceInfo() {
        this.instanceIp = this.getProperty("cloud.nacos.instance.ip");
        this.instanceServiceName = this.getProperty("cloud.nacos.instance.serviceName");
        this.instancePort = this.getProperty("cloud.nacos.instance.servicePort");
        if (this.instancePort == null) {
            this.instancePort = this.getProperty("server.port");
        }
        this.instanceNamespaceId = this.getProperty("cloud.nacos.instance.namespaceId");
        this.instanceBeatByRegister = this.getProperty("cloud.nacos.instance.beat.method") != null;
        String instanceCheckHealthyInterval = this.getProperty("cloud.nacos.instance.checkHealthyInterval");
        try {
            this.instanceCheckHealthyInterval = Long.parseLong(instanceCheckHealthyInterval.trim());
        }
        catch (Throwable throwable) {
            this.instanceCheckHealthyInterval = 30L;
        }
        String enable = this.getProperty("cloud.nacos.instance.enable");
        this.instanceEnable = !"false".equals(enable);
    }

    private void initConfigParams() {
        try {
            String dataIds = this.getProperty("cloud.nacos.config.dataIds");
            String groups = this.getProperty("cloud.nacos.config.groups");
            String tenants = this.getProperty("cloud.nacos.config.tenants");
            this.dataIds = dataIds.trim().split(",");
            this.groups = groups.trim().split(",");
            this.tenants = tenants.trim().split(",");
            this.configCount = Math.min(this.dataIds.length, Math.min(this.groups.length, this.tenants.length));
        }
        catch (Throwable throwable) {
            log.debug("init config error\uff1a {}", throwable.getMessage());
        }
    }

    public String getProperty(String key) {
        return this.nacosProperties.getProperty(key);
    }

    public void destroy() {
        this.shutdownExecutorService();
    }

    public static interface FetchPropertiesCallback {
        public void loadProperties(InputStream var1);

        public void loadProperties(Properties var1);
    }
}

