/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.client;

import io.github.wycst.wast.clients.redis.client.RedisClient;
import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.github.wycst.wast.clients.redis.connection.RedisConnectionHandler;
import io.github.wycst.wast.clients.redis.connection.RedisConnectionPool;
import io.github.wycst.wast.clients.redis.exception.RedisConnectionException;

public class PooledRedisClient
extends RedisClient {
    private RedisConnectionPool redisConnectionPool;
    private static ThreadLocal<RedisConnection> fixedConnectionHolder = new ThreadLocal();

    public PooledRedisClient(RedisConnectionPool redisConnectionPool) {
        this.redisConnectionPool = redisConnectionPool;
    }

    protected RedisConnection getConnection() {
        RedisConnection connection = this.getHoderConnection();
        if (connection == null) {
            connection = this.createConnection();
            fixedConnectionHolder.set(connection);
        }
        return connection;
    }

    protected RedisConnection createConnection() {
        try {
            return this.redisConnectionPool.connection(this.isSynchronized());
        }
        catch (Throwable e) {
            throw new RedisConnectionException(e);
        }
    }

    private RedisConnection getHoderConnection() {
        RedisConnection connection = fixedConnectionHolder.get();
        if (connection != null) {
            RedisConnectionHandler.signProgress(connection);
            if (connection.isClosed()) {
                return null;
            }
        }
        return connection;
    }
}

