/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.connection;

import io.github.wycst.wast.clients.redis.data.future.KeepAliveRedisFuture;
import io.github.wycst.wast.clients.redis.data.future.RedisFuture;
import io.github.wycst.wast.clients.redis.data.future.ResultRedisFuture;
import io.github.wycst.wast.clients.redis.data.future.SubscriberRedisFuture;
import io.github.wycst.wast.clients.redis.exception.RedisConnectionException;
import io.github.wycst.wast.clients.redis.exception.RedisException;
import io.github.wycst.wast.clients.redis.listener.Subscriber;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RedisConnection {
    private Channel channel;
    private boolean closed;
    private boolean isSynchronized;
    private boolean pipelined;
    private boolean isMulti;
    private RedisFuture subscribeFuture;
    private int pipelineCount;
    private StringBuffer commandBuffer = new StringBuffer();
    private Queue<RedisFuture> futureQueue = new LinkedList<RedisFuture>();
    private final AtomicBoolean inSubscribe = new AtomicBoolean(false);
    private final AtomicBoolean inProgress = new AtomicBoolean(false);
    public final String id;
    public final String channelId;
    public static final AttributeKey<RedisConnection> REDIS_CONNECTION_ATTRIBUTE_KEY = AttributeKey.valueOf(RedisConnection.class, (String)"REDIS_CONNECTION_ATTRIBUTE_KEY");
    public static final char M = '*';
    public static final char C = '$';
    public static final String SEPARATOR = "\r\n";
    public static final String SELECT = "SELECT";
    public static final String AUTH = "AUTH";
    public static final String MULTI = "MULTI";
    public static final String EXEC = "EXEC";
    public static final String DISCARD = "DISCARD";

    RedisConnection(Channel channel) {
        this(channel, false);
    }

    protected RedisConnection(Channel channel, boolean isSynchronized) {
        this.channel = channel;
        this.id = UUID.randomUUID().toString();
        this.channelId = channel.id().asShortText();
        this.isSynchronized = isSynchronized;
        channel.attr(REDIS_CONNECTION_ATTRIBUTE_KEY).set((Object)this);
    }

    public abstract boolean recycleable();

    public final boolean isSynchronized() {
        return this.isSynchronized;
    }

    public void setSynchronized(boolean aSynchronized) {
        this.isSynchronized = aSynchronized;
    }

    protected final Channel getChannel() {
        return this.channel;
    }

    public String getId() {
        return this.id;
    }

    public void pipeline() {
        this.clear();
        this.pipelined = true;
    }

    public void executePipeline() {
        if (this.isPipelined()) {
            this.flush();
        }
        this.sync();
        this.pipelined = false;
    }

    public boolean completePipelined() {
        return --this.pipelineCount == 0;
    }

    public RedisFuture auth(String password) {
        this.clear();
        RedisFuture redisFuture = this.flush("AUTH " + password, new KeepAliveRedisFuture());
        return redisFuture;
    }

    public RedisFuture<String> select(int database) {
        this.clear();
        RedisFuture redisFuture = this.flush("SELECT " + database, new KeepAliveRedisFuture());
        String result = (String)redisFuture.getResult();
        if (!"OK".equals(result)) {
            throw new RedisException(result);
        }
        return redisFuture;
    }

    public RedisFuture multi() {
        this.clear();
        RedisFuture redisFuture = this.flush(MULTI, new KeepAliveRedisFuture());
        this.isMulti = true;
        return redisFuture;
    }

    public RedisFuture exec() {
        this.clear();
        RedisFuture redisFuture = this.flush(EXEC);
        this.isMulti = false;
        return redisFuture;
    }

    public void discard() {
        this.clear();
        this.flush(DISCARD);
        this.isMulti = false;
    }

    public void cancelPipeline() {
        this.clear();
        this.pipelined = false;
    }

    public RedisFuture writeAndFlush(String ... commanders) {
        this.write(commanders);
        return this.flush();
    }

    public RedisFuture flush() {
        this.checkIfBusy();
        RedisFuture redisFuture = this.flush(this.commandBuffer.toString());
        this.commandBuffer.setLength(0);
        return redisFuture;
    }

    public void clear() {
    }

    private RedisFuture flush(String s) {
        return this.flush(s, new ResultRedisFuture());
    }

    private RedisFuture flush(String s, RedisFuture redisFuture) {
        this.checkIfClosed();
        if (this.isSynchronized()) {
            // empty if block
        }
        this.channelFlush(s);
        this.futureQueue.add(redisFuture);
        return redisFuture;
    }

    private void channelFlush(Object s) {
        ChannelFuture future = this.channel.writeAndFlush(s).addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

            public void operationComplete(ChannelFuture future) {
                if (!future.isSuccess()) {
                    future.cause().printStackTrace();
                }
            }
        });
        future.awaitUninterruptibly();
    }

    private void sync(RedisFuture redisFuture) {
        try {
            redisFuture.sync();
        }
        catch (Throwable e) {
            throw new RedisConnectionException(e);
        }
    }

    private void checkIfClosed() {
        if (this.isClosed()) {
            throw new RedisConnectionException("connection is closed ");
        }
    }

    private void checkIfBusy() {
        if (this.isBusy()) {
            throw new RedisConnectionException("Connection is busy, response is not supported temporarily ");
        }
    }

    public boolean isClosed() {
        return this.closed ? true : !this.channel.isActive();
    }

    public boolean isPipelined() {
        return this.pipelined;
    }

    public boolean isProgress() {
        return this.inProgress.get();
    }

    public boolean isMulti() {
        return this.isMulti;
    }

    public void close() {
        this.checkIfClosed();
        this.clear();
        this.channel.attr(REDIS_CONNECTION_ATTRIBUTE_KEY).set(null);
        this.channel = null;
        this.closed = true;
    }

    public void write(String ... commands) {
        this.checkIfBusy();
        this.writeCommands(commands);
    }

    private void writeCommands(String[] commands) {
        if (!this.pipelined) {
            this.commandBuffer.setLength(0);
        }
        this.appendCommands(commands);
        if (this.pipelined && commands.length > 0) {
            ++this.pipelineCount;
        }
    }

    private void appendCommands(String ... commands) {
        this.commandBuffer.append('*').append(commands.length).append(SEPARATOR);
        for (String commander : commands) {
            commander = commander == null ? "" : commander.trim();
            int byteLength = commander.getBytes().length;
            this.commandBuffer.append('$').append(byteLength).append(SEPARATOR);
            this.commandBuffer.append(commander).append(SEPARATOR);
        }
    }

    protected boolean beforeClose() {
        if (this.isMulti() || this.isPipelined() || this.isProgress()) {
            return false;
        }
        if (this.isBusy()) {
            return false;
        }
        return this.recycleable() && this.emptyQueue();
    }

    private boolean emptyQueue() {
        return this.futureQueue.size() == 0;
    }

    private boolean isBusy() {
        return this.inSubscribe.get();
    }

    protected void afterQueueResponse() {
    }

    public void sync() {
        this.setSynchronized(true);
        ArrayList<RedisFuture> futureList = new ArrayList<RedisFuture>(this.futureQueue);
        if (!futureList.isEmpty()) {
            for (RedisFuture redisFuture : futureList) {
                this.sync(redisFuture);
            }
            futureList.clear();
        }
    }

    public void closeSync() {
        this.setSynchronized(false);
    }

    void setProgress(boolean progress) {
        this.inProgress.set(progress);
    }

    void handleQueueResponse(Object result) {
        RedisFuture redisFuture = this.next();
        boolean keepAlive = false;
        if (redisFuture != null) {
            redisFuture.set(result);
            keepAlive = redisFuture.isKeepAlive();
        }
        boolean waitPipelined = false;
        if (this.isPipelined()) {
            waitPipelined = true;
            if (this.completePipelined()) {
                waitPipelined = false;
            }
        }
        this.afterQueueResponse();
        if (keepAlive) {
            return;
        }
        if (waitPipelined || this.beforeClose()) {
            // empty if block
        }
    }

    private RedisFuture next() {
        if (this.inSubscribe.get()) {
            return this.subscribeFuture;
        }
        return this.futureQueue.poll();
    }

    public void subscribe(String[] subCommands, Subscriber subscriber) {
        this.sync();
        RedisFuture redisFuture = this.writeAndFlush(subCommands);
        Object result = redisFuture.getResult();
        if (result instanceof String) {
            throw new RedisException((String)result);
        }
        this.inSubscribe.set(true);
        this.subscribeFuture = new SubscriberRedisFuture(subscriber);
    }

    public void unsubscribe(String command, String[] channels) {
        boolean isEmptyChannels;
        boolean bl = isEmptyChannels = channels == null || channels.length == 0;
        if (isEmptyChannels) {
            this.channelFlush(command);
            this.inSubscribe.set(false);
        } else {
            StringBuffer buffer = new StringBuffer(command);
            buffer.append(" ");
            for (String channel : channels) {
                buffer.append(channel).append(" ");
            }
            this.channelFlush(buffer.toString());
        }
    }

    public String toString() {
        return "RedisConnection{closed=" + this.closed + ", id='" + this.id + '\'' + ", channel='" + this.channelId + '\'' + '}';
    }
}

