/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.connection;

import io.github.wycst.wast.clients.redis.conf.RedisConfig;
import io.github.wycst.wast.clients.redis.connection.AbstractConnectonPool;
import io.github.wycst.wast.clients.redis.connection.PooledRedisConnection;
import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.github.wycst.wast.clients.redis.data.future.RedisFuture;
import io.github.wycst.wast.clients.redis.exception.RedisConnectionException;
import io.github.wycst.wast.clients.redis.netty.RedisChannelPool;
import io.netty.channel.Channel;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;

public class RedisConnectionPool
extends AbstractConnectonPool {
    private ThreadLocal<CountDownLatch> currentCountDownLatchHolder = new ThreadLocal();
    private AttributeKey<Boolean> loginFlag = AttributeKey.valueOf(Boolean.class, (String)"loginFlag");

    public RedisConnectionPool(RedisConfig redisConfig) {
        super(new RedisChannelPool(redisConfig));
    }

    public RedisConnection connection() throws InterruptedException, ExecutionException {
        return this.connection(false);
    }

    public RedisConnection connection(boolean await) throws InterruptedException, ExecutionException {
        CountDownLatch countDownLatch = this.currentCountDownLatchHolder.get();
        if (await) {
            if (countDownLatch != null && countDownLatch.getCount() > 0L) {
                countDownLatch.await();
            }
            countDownLatch = new CountDownLatch(1);
            this.currentCountDownLatchHolder.set(countDownLatch);
        } else {
            if (countDownLatch != null) {
                countDownLatch.countDown();
            }
            this.currentCountDownLatchHolder.remove();
        }
        Channel channel = null;
        try {
            Future<Channel> f = this.acquire();
            channel = (Channel)f.get();
        }
        catch (Throwable throwable) {
            if (await) {
                countDownLatch.countDown();
            }
            throw new ExecutionException(throwable);
        }
        PooledRedisConnection redisConnection = new PooledRedisConnection(channel, await);
        redisConnection.setNextCountDownLatch(countDownLatch);
        redisConnection.setChannelPool(this.getRedisChannelPool());
        Attribute loginValue = channel.attr(this.loginFlag);
        if (loginValue.get() == null) {
            RedisFuture<String> redisFuture = redisConnection.auth(this.getAuth());
            String result = (String)redisFuture.get();
            if (!"OK".equals(result)) {
                throw new RedisConnectionException(result);
            }
            redisFuture = redisConnection.select(this.getDatabase());
            redisFuture.get();
            loginValue.set((Object)true);
        }
        return redisConnection;
    }

    public String getAuth() {
        return this.getRedisChannelPool().getRedisConfig().getPassword();
    }

    public String getHost() {
        return this.getRedisChannelPool().getRedisConfig().getHost();
    }

    public int getPort() {
        return this.getRedisChannelPool().getRedisConfig().getPort();
    }

    public int getDatabase() {
        return this.getRedisChannelPool().getRedisConfig().getDatabase();
    }
}

