/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.netty;

import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.github.wycst.wast.clients.redis.connection.RedisConnectionHandler;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.redis.ArrayRedisMessage;
import io.netty.handler.codec.redis.ErrorRedisMessage;
import io.netty.handler.codec.redis.FullBulkStringRedisMessage;
import io.netty.handler.codec.redis.InlineCommandRedisMessage;
import io.netty.handler.codec.redis.IntegerRedisMessage;
import io.netty.handler.codec.redis.RedisMessage;
import io.netty.handler.codec.redis.SimpleStringRedisMessage;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayList;

public class RedisChannelHandler
extends ChannelDuplexHandler {
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof String) {
            InlineCommandRedisMessage redisMessage = new InlineCommandRedisMessage((String)msg);
            ctx.write((Object)redisMessage, promise);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof IdleStateEvent) {
            Channel channel = ctx.channel();
            RedisConnection connection = RedisChannelHandler.getBindRedisConnection(channel);
            if (connection != null && !connection.isClosed()) {
                RedisConnectionHandler.safeclose(connection);
            }
        } else {
            super.userEventTriggered(ctx, evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        RedisMessage redisMessage = (RedisMessage)msg;
        try {
            Object result = this.parseRedisResponse(redisMessage);
            Channel channel = ctx.channel();
            RedisConnection redisConnection = RedisChannelHandler.getBindRedisConnection(channel);
            RedisConnectionHandler.handleQueueResponse(redisConnection, result);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            ReferenceCountUtil.release((Object)msg);
            throw throwable;
        }
        ReferenceCountUtil.release((Object)msg);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.forceclose(ctx);
        cause.printStackTrace();
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.forceclose(ctx);
        super.channelInactive(ctx);
    }

    private void forceclose(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        RedisConnection redisConnection = RedisChannelHandler.getBindRedisConnection(channel);
        if (redisConnection != null) {
            redisConnection.close();
        } else {
            channel.close();
        }
    }

    private Object parseRedisResponse(RedisMessage msg) {
        ArrayList<Object> result = null;
        if (msg instanceof SimpleStringRedisMessage) {
            result = ((SimpleStringRedisMessage)msg).content();
        } else if (msg instanceof ErrorRedisMessage) {
            result = ((ErrorRedisMessage)msg).content();
        } else if (msg instanceof IntegerRedisMessage) {
            result = ((IntegerRedisMessage)msg).value();
        } else if (msg instanceof FullBulkStringRedisMessage) {
            result = RedisChannelHandler.getString((FullBulkStringRedisMessage)msg);
        } else if (msg instanceof ArrayRedisMessage) {
            ArrayList<Object> msgs = new ArrayList<Object>();
            for (RedisMessage child : ((ArrayRedisMessage)msg).children()) {
                msgs.add(this.parseRedisResponse(child));
            }
            result = msgs;
        }
        return result;
    }

    private static RedisConnection getBindRedisConnection(Channel channel) {
        return (RedisConnection)channel.attr(RedisConnection.REDIS_CONNECTION_ATTRIBUTE_KEY).get();
    }

    private static String getString(FullBulkStringRedisMessage msg) {
        if (msg.isNull()) {
            return null;
        }
        return msg.content().toString(CharsetUtil.UTF_8);
    }
}

