/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.netty;

import io.github.wycst.wast.clients.redis.conf.RedisConfig;
import io.github.wycst.wast.clients.redis.netty.ChannelPoolHandlerImpl;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.pool.ChannelPool;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RedisChannelPool
implements ChannelPool {
    private ChannelPool channelPool;
    private EventLoopGroup group = new NioEventLoopGroup();
    private RedisConfig redisConfig;

    public RedisChannelPool(RedisConfig redisConfig) {
        Bootstrap bootstrap = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.group)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress((SocketAddress)new InetSocketAddress(redisConfig.getHost(), redisConfig.getPort()));
        this.redisConfig = redisConfig;
        this.channelPool = new FixedChannelPool(bootstrap, (ChannelPoolHandler)new ChannelPoolHandlerImpl(), redisConfig.getPoolMaxActive());
    }

    public RedisConfig getRedisConfig() {
        return this.redisConfig;
    }

    public Future<Channel> acquire() {
        return this.channelPool.acquire();
    }

    public Future<Channel> acquire(Promise<Channel> promise) {
        return this.channelPool.acquire(promise);
    }

    public Future<Void> release(Channel channel) {
        return this.channelPool.release(channel);
    }

    public Future<Void> release(Channel channel, Promise<Void> promise) {
        return this.channelPool.release(channel, promise);
    }

    public void close() {
        this.channelPool.close();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.group.shutdownGracefully();
    }
}

