/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.redis.test;

import io.github.wycst.wast.clients.redis.client.SimpleRedisClient;
import io.github.wycst.wast.clients.redis.conf.RedisConfig;
import io.github.wycst.wast.clients.redis.connection.RedisConnection;
import io.github.wycst.wast.clients.redis.connection.RedisConnectionPool;
import io.github.wycst.wast.clients.redis.data.future.RedisFuture;
import java.util.concurrent.ExecutionException;

public class RedisClientTest {
    private static RedisConnectionPool redisConnectionPool;
    RedisConnection redisConnection;

    public RedisClientTest() {
        try {
            this.redisConnection = redisConnectionPool.connection(false);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    private RedisFuture sendCmd(String s) throws ExecutionException, InterruptedException {
        String[] commands = s.split("\\s+");
        RedisFuture redisFuture = this.redisConnection.writeAndFlush(commands);
        return redisFuture;
    }

    public static void main(String[] args) throws ExecutionException, InterruptedException {
        SimpleRedisClient redisClient = new SimpleRedisClient(redisConnectionPool.getHost(), redisConnectionPool.getPort());
        redisClient.auth(redisConnectionPool.getAuth());
        redisClient.sync();
        long begin = System.currentTimeMillis();
        redisClient.pipeline();
        for (int i = 0; i < 11; ++i) {
            redisClient.hashSet("persion-a", "name" + i, "zhangsan" + i);
        }
        redisClient.executePipeline();
        long end = System.currentTimeMillis();
        System.out.println("============= " + (end - begin));
        redisClient.close();
        RedisClientTest client = new RedisClientTest();
        long beginTime = System.currentTimeMillis();
        String str = "*2\r\n$4\r\nAUTH\r\n$12\r\n49#123456#49";
        str = "\r\n*3\r\n$3\r\nset\r\n$1\r\nu\r\n$1\r\n1";
        str = str + "\r\n*3\r\n$3\r\nset\r\n$1\r\nu\r\n$1\r\n1";
        str = str + "\r\n*3\r\n$3\r\nset\r\n$1\r\nu\r\n$1\r\n1";
        System.out.println("======= sendCmd ");
        client.sendCmd(str);
        System.out.println(client.sendCmd("set a 2").get());
        client.sendCmd("set a 2");
        System.out.println("========= " + client.sendCmd("get a"));
        System.out.println("========= " + client.sendCmd("get a"));
        System.out.println("========= " + client.sendCmd("get a"));
        client.sendCmd("get a");
        client.sendCmd("set a 3");
        client.sendCmd("get a");
        client.sendCmd("set a 4");
        client.sendCmd("get a");
        client.sendCmd("set a 5");
        client.sendCmd("get a");
        client.sendCmd("set a 6");
        RedisFuture redisFuture6 = client.sendCmd("get a");
        client.sendCmd("set a 7");
        client.sendCmd("get a");
        client.sendCmd("set a 8");
        RedisFuture redisFuture8 = client.sendCmd("get a");
        long endTime = System.currentTimeMillis();
        System.out.println(endTime - beginTime);
        System.out.println("hhh ");
        System.out.println("====================redisFuture6 " + redisFuture6.get());
        System.out.println("====================redisFuture8 " + redisFuture8.get());
        client.sendCmd("set a 1");
        client.sendCmd("set a 1");
        client.sendCmd("set a 5");
        client.sendCmd("set b 1");
        client.sendCmd("get a");
        client.sendCmd("get b");
        client.sendCmd("get  c");
        client.sendCmd("get  d");
        client.sendCmd("set a 7");
        System.out.println("====================redisFuture ffff " + client.sendCmd("get a").get());
        System.out.println("... over ....... ");
    }

    static {
        RedisConfig redisConfig = new RedisConfig();
        redisConfig.setDatabase(1);
        redisConfig.setHost("49.233.166.49");
        redisConfig.setPort(6379);
        redisConfig.setPoolMaxActive(20);
        redisConfig.setPoolMaxWait(3000L);
        redisConfig.setPassword("49#123456#49");
        redisConfig.setTimeout(30000L);
        redisConnectionPool = new RedisConnectionPool(redisConfig);
    }
}

