/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.clients.websocket;

import io.github.wycst.wast.clients.websocket.WebSocketClient;
import io.github.wycst.wast.clients.websocket.WebSocketClientHandler;
import io.github.wycst.wast.clients.websocket.WebSocketEventHandler;
import io.github.wycst.wast.clients.websocket.WebSocketException;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketClientCompressionHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import java.net.URI;

public class WebSocketClientFactory {
    private static Bootstrap bootstrap;
    private static EventLoopGroup group;
    private static boolean shutdown;

    private static void init() {
        bootstrap = new Bootstrap();
        group = new NioEventLoopGroup();
        ((Bootstrap)bootstrap.group(group)).channel(NioSocketChannel.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WebSocketClient createWebSocketClient(String websocketURL, String subprotocol, WebSocketEventHandler eventHandler) {
        try {
            String host;
            URI uri = new URI(websocketURL);
            String scheme = uri.getScheme() == null ? "ws" : uri.getScheme();
            String string = host = uri.getHost() == null ? "127.0.0.1" : uri.getHost();
            final int port = uri.getPort() == -1 ? ("ws".equalsIgnoreCase(scheme) ? 80 : ("wss".equalsIgnoreCase(scheme) ? 443 : -1)) : uri.getPort();
            if (!"ws".equalsIgnoreCase(scheme) && !"wss".equalsIgnoreCase(scheme)) {
                throw new WebSocketException("Only WS(S) is supported ");
            }
            boolean ssl = "wss".equalsIgnoreCase(scheme);
            final SslContext sslCtx = ssl ? SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build() : null;
            final WebSocketClientHandler handler = new WebSocketClientHandler(WebSocketClientHandshakerFactory.newHandshaker((URI)uri, (WebSocketVersion)WebSocketVersion.V13, (String)subprotocol, (boolean)true, (HttpHeaders)new DefaultHttpHeaders()), eventHandler);
            if (shutdown) {
                Bootstrap bootstrap = WebSocketClientFactory.bootstrap;
                synchronized (bootstrap) {
                    if (shutdown) {
                        WebSocketClientFactory.init();
                        shutdown = false;
                    }
                }
            }
            bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) {
                    ChannelPipeline p = ch.pipeline();
                    if (sslCtx != null) {
                        p.addLast(new ChannelHandler[]{sslCtx.newHandler(ch.alloc(), host, port)});
                    }
                    p.addLast(new ChannelHandler[]{new HttpClientCodec(), new HttpObjectAggregator(8192), WebSocketClientCompressionHandler.INSTANCE, handler});
                }
            });
            Channel channel = bootstrap.connect(uri.getHost(), port).sync().channel();
            handler.handshakeFuture().sync();
            WebSocketClient webSocketClient = new WebSocketClient(channel);
            Object var13_14 = null;
            return webSocketClient;
        }
        catch (Throwable e) {
            try {
                throw new WebSocketException(e);
            }
            catch (Throwable throwable) {
                Object var13_15 = null;
                throw throwable;
            }
        }
    }

    public static WebSocketClient createWebSocketClient(String websocketURL, WebSocketEventHandler eventHandler) {
        return WebSocketClientFactory.createWebSocketClient(websocketURL, null, eventHandler);
    }

    public static void shutdown() {
        group.shutdownGracefully();
        shutdown = true;
    }

    static {
        WebSocketClientFactory.init();
    }
}

