/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.beans;

import io.github.wycst.wast.common.beans.DateTemplate;

public class DateParser {
    private static DateTemplate[] pattern_21bit = new DateTemplate[]{new DateTemplate("yyyy-MM-dd HH:mm:ss.S"), new DateTemplate("yyyy.MM.dd HH:mm:ss.S"), new DateTemplate("yyyy/MM/dd HH:mm:ss.S")};
    private static DateTemplate[] pattern_19bit = new DateTemplate[]{new DateTemplate("yyyy-MM-dd HH:mm:ss"), new DateTemplate("yyyy.MM.dd HH:mm:ss"), new DateTemplate("yyyy/MM/dd HH:mm:ss")};
    private static DateTemplate[] pattern_10bit = new DateTemplate[]{new DateTemplate("yyyy-MM-dd"), new DateTemplate("yyyy.MM.dd"), new DateTemplate("yyyy/MM/dd")};
    private static DateTemplate[] pattern_8bit = new DateTemplate[]{new DateTemplate("yyyyMMdd")};
    private static DateTemplate[] pattern_others = new DateTemplate[]{new DateTemplate("yyyy-MM-dd HH:mm"), new DateTemplate("yyyy.MM.dd HH:mm"), new DateTemplate("yyyy/MM/dd HH:mm")};

    public static long parseTime(String originDate) {
        originDate = originDate.trim();
        int len = originDate.length();
        switch (len) {
            case 8: {
                return DateParser.parseTime(originDate, pattern_8bit);
            }
            case 10: {
                return DateParser.parseTime(originDate, pattern_10bit);
            }
            case 19: {
                return DateParser.parseTime(originDate, pattern_19bit);
            }
            case 21: 
            case 22: 
            case 23: {
                return DateParser.parseTime(originDate, pattern_21bit);
            }
        }
        return DateParser.parseTime(originDate, pattern_others);
    }

    private static long parseTime(String originDate, DateTemplate[] dateTemplates) {
        for (DateTemplate dateTemplate : dateTemplates) {
            try {
                long time = dateTemplate.parse(originDate).getTime();
                return time;
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalArgumentException(String.format("date value '%s' parse error!", originDate));
    }
}

