/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.compiler;

import io.github.wycst.wast.common.compiler.MemoryJavaFileObject;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class MemoryJavaFileManager
extends ForwardingJavaFileManager {
    private Map<String, MemoryJavaFileObject> fileObjectMap = new HashMap<String, MemoryJavaFileObject>();
    private MemoryJavaFileObject memoryJavaFileObject;

    public MemoryJavaFileManager(JavaFileManager fileManager) {
        super(fileManager);
    }

    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        this.memoryJavaFileObject = new MemoryJavaFileObject(className, JavaFileObject.Kind.SOURCE);
        return this.memoryJavaFileObject;
    }

    public JavaFileObject createJavaFileObject(String name, String code) {
        return new MemoryInputJavaFileObject(name, code);
    }

    public MemoryJavaFileObject getMemoryJavaFileObject() {
        return this.memoryJavaFileObject;
    }

    class MemoryInputJavaFileObject
    extends SimpleJavaFileObject {
        final String code;

        MemoryInputJavaFileObject(String name, String code) {
            super(URI.create("string:///" + name), JavaFileObject.Kind.SOURCE);
            this.code = code;
        }

        public String getCharContent(boolean ignoreEncodingErrors) {
            return this.code;
        }
    }
}

