/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.expression;

import io.github.wycst.wast.common.expression.invoker.Invoker;
import io.github.wycst.wast.common.expression.invoker.VariableInvoker;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EvaluatorContext {
    public static final EvaluatorContext Empty = new EvaluatorContext();
    Object context;
    Object value;

    EvaluatorContext() {
    }

    public Object getContext() {
        return this.context;
    }

    public Object getContextValue(VariableInvoker variableInvoke) {
        return variableInvoke.getValue();
    }

    public void setContextVariables(Invoker invoke, Object context) {
        this.context = context;
        if (invoke == null) {
            return;
        }
        invoke.invoke(context);
    }

    public void setContextVariables(Invoker invoke, Map<String, Object> mapContext) {
        this.context = mapContext;
        if (invoke == null) {
            return;
        }
        invoke.invoke(mapContext);
    }

    public void clearContextVariables(Invoker invoke) {
        if (invoke == null) {
            return;
        }
        invoke.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StatefulEvaluatorContext
    extends EvaluatorContext {
        Object[] variableValues;

        @Override
        public Object getContextValue(VariableInvoker variableInvoke) {
            return this.variableValues[variableInvoke.getIndex()];
        }

        public void setContextVariables(Invoker invoke, Object context, int variableCount) {
            this.context = context;
            if (variableCount == 0) {
                return;
            }
            this.variableValues = this.initArgumentValues(variableCount);
            invoke.invoke(context, this.variableValues);
        }

        public void setContextVariables(Invoker invoke, Map<String, Object> mapContext, int variableCount) {
            this.context = mapContext;
            if (variableCount == 0) {
                return;
            }
            this.variableValues = this.initArgumentValues(variableCount);
            invoke.invoke(mapContext, this.variableValues);
        }

        private Object[] initArgumentValues(int variableCount) {
            return new Object[variableCount];
        }

        @Override
        public void clearContextVariables(Invoker invoke) {
            this.variableValues = null;
            this.context = null;
        }
    }
}

