/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectConsts {
    public static final int CLASS_TYPE_DATE = 1;
    public static final int CLASS_TYPE_NUMBER = 100;
    public static final int CLASS_TYPE_NUMBER_BYTE = 101;
    public static final int CLASS_TYPE_NUMBER_SHORT = 102;
    public static final int CLASS_TYPE_NUMBER_INTEGER = 103;
    public static final int CLASS_TYPE_NUMBER_LONG = 104;
    public static final int CLASS_TYPE_NUMBER_FLOAT = 105;
    public static final int CLASS_TYPE_NUMBER_DOUBLE = 106;
    public static final int CLASS_TYPE_NUMBER_ATOMIC_INTEGER = 107;
    public static final int CLASS_TYPE_NUMBER_ATOMIC_LONG = 108;
    public static final int CLASS_TYPE_NUMBER_BIGDECIMAL = 109;
    public static final int CLASS_TYPE_NUMBER_BIG_INTEGER = 110;
    public static final int CLASS_TYPE_NUMBER_CHARACTER = 111;
    public static final int CLASS_TYPE_NUMBER_BOOLEAN = 112;
    public static final int CLASS_TYPE_NUMBER_ATOMIC_BOOLEAN = 113;
    public static final int CLASS_TYPE_STRING = 200;
    public static final int CLASS_TYPE_STRING_BUFFER = 201;
    public static final int CLASS_TYPE_STRING_BUILDER = 202;
    public static final int CLASS_TYPE_CHAR_ARRAY = 203;
    public static final int CLASS_TYPE_BYTE_ARRAY = 204;
    public static final int CLASS_TYPE_JSON = 1000;
    public static final int CLASS_TYPE_ARRAY = 2000;
    private static final Map<Class, ClassCategory> classClassCategoryMap = new ConcurrentHashMap<Class, ClassCategory>();

    public static int getParamClassType(Class<?> clazz) {
        if (clazz != null) {
            if (java.util.Date.class.isAssignableFrom(clazz)) {
                return 1;
            }
            if (clazz == String.class) {
                return 200;
            }
            if (ReflectConsts.isNumberType(clazz)) {
                return 100;
            }
            if (clazz == StringBuffer.class) {
                return 201;
            }
            if (clazz == StringBuilder.class) {
                return 202;
            }
            if (clazz == char[].class) {
                return 203;
            }
            if (clazz == byte[].class) {
                return 204;
            }
            if (Collection.class.isAssignableFrom(clazz) || clazz.isArray()) {
                return 2000;
            }
        }
        return 1000;
    }

    public static boolean isNumberType(Class<?> clazz) {
        return clazz.isPrimitive() || Number.class.isAssignableFrom(clazz) || clazz == Boolean.class;
    }

    public static int getParamClassNumberType(Class<?> clazz) {
        if (ReflectConsts.isNumberType(clazz)) {
            if (clazz == Integer.TYPE || clazz == Integer.class) {
                return 103;
            }
            if (clazz == Float.TYPE || clazz == Float.class) {
                return 105;
            }
            if (clazz == Long.TYPE || clazz == Long.class) {
                return 104;
            }
            if (clazz == Double.TYPE || clazz == Double.class) {
                return 106;
            }
            if (clazz == Boolean.TYPE || clazz == Boolean.class) {
                return 112;
            }
            if (clazz == BigDecimal.class) {
                return 109;
            }
            if (clazz == Byte.TYPE || clazz == Byte.class) {
                return 101;
            }
            if (clazz == Short.TYPE || clazz == Short.class) {
                return 102;
            }
            if (clazz == Character.TYPE || clazz == Character.class) {
                return 111;
            }
            if (clazz == AtomicInteger.class) {
                return 107;
            }
            if (clazz == AtomicLong.class) {
                return 108;
            }
            if (clazz == AtomicBoolean.class) {
                return 113;
            }
            if (clazz == BigInteger.class) {
                return 110;
            }
        }
        return 0;
    }

    private static void putAllType(ClassCategory classCategory, Class<?> ... classList) {
        for (Class<?> cls : classList) {
            classClassCategoryMap.put(cls, classCategory);
        }
    }

    private static synchronized void putType(Class<?> cls, ClassCategory classCategory) {
        if (classClassCategoryMap.size() >= 4096) {
            return;
        }
        classClassCategoryMap.put(cls, classCategory);
    }

    public static ClassCategory getClassCategory(Class cls) {
        if (cls == null) {
            return ClassCategory.ANY;
        }
        ClassCategory classCategory = classClassCategoryMap.get(cls);
        if (classCategory != null) {
            return classCategory;
        }
        if (CharSequence.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.CharSequence;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Number.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.NumberCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (java.util.Date.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.DateCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (cls.isEnum()) {
            classCategory = ClassCategory.EnumCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Collection.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.CollectionCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Map.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.MapCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (cls.isArray()) {
            classCategory = ClassCategory.ArrayCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Class.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.ClassCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (Annotation.class.isAssignableFrom(cls)) {
            classCategory = ClassCategory.AnnotationCategory;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        if (cls.isInterface() || Modifier.isAbstract(cls.getModifiers())) {
            classCategory = ClassCategory.NonInstance;
            ReflectConsts.putType(cls, classCategory);
            return classCategory;
        }
        classCategory = ClassCategory.ObjectCategory;
        ReflectConsts.putType(cls, classCategory);
        return classCategory;
    }

    static int arrayBaseOffset(Class arrayCls) {
        return UnsafeHelper.arrayBaseOffset(arrayCls);
    }

    static int arrayIndexScale(Class arrayCls) {
        return UnsafeHelper.arrayIndexScale(arrayCls);
    }

    static {
        ReflectConsts.putAllType(ClassCategory.Binary, byte[].class);
        ReflectConsts.putAllType(ClassCategory.CollectionCategory, ArrayList.class, HashSet.class);
        ReflectConsts.putAllType(ClassCategory.MapCategory, HashMap.class, LinkedHashMap.class);
        ReflectConsts.putAllType(ClassCategory.CharSequence, String.class, char[].class, StringBuilder.class, StringBuffer.class, Character.TYPE, Character.class);
        ReflectConsts.putAllType(ClassCategory.NumberCategory, BigDecimal.class, BigInteger.class, Integer.TYPE, Integer.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Float.TYPE, Float.class, Long.TYPE, Long.class, Double.TYPE, Double.class);
        ReflectConsts.putAllType(ClassCategory.BoolCategory, Boolean.TYPE, Boolean.class);
        ReflectConsts.putAllType(ClassCategory.DateCategory, java.util.Date.class, Timestamp.class, Date.class);
        ReflectConsts.putAllType(ClassCategory.ANY, Object.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum PrimitiveType {
        PrimitiveByte(byte[].class, ReflectConsts.arrayBaseOffset(byte[].class), ReflectConsts.arrayIndexScale(byte[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putByte(target, fieldOffset, (Byte)value);
            }

            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getByte(target, fieldOffset);
            }
        }
        ,
        PrimitiveShort(short[].class, ReflectConsts.arrayBaseOffset(short[].class), ReflectConsts.arrayIndexScale(short[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putShort(target, fieldOffset, (Short)value);
            }

            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getShort(target, fieldOffset);
            }
        }
        ,
        PrimitiveInt(int[].class, ReflectConsts.arrayBaseOffset(int[].class), ReflectConsts.arrayIndexScale(int[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putInt(target, fieldOffset, (Integer)value);
            }

            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getInt(target, fieldOffset);
            }
        }
        ,
        PrimitiveFloat(float[].class, ReflectConsts.arrayBaseOffset(float[].class), ReflectConsts.arrayIndexScale(float[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putFloat(target, fieldOffset, ((Float)value).floatValue());
            }

            Object getValue(Object target, long fieldOffset) {
                return Float.valueOf(UnsafeHelper.getUnsafe().getFloat(target, fieldOffset));
            }
        }
        ,
        PrimitiveLong(long[].class, ReflectConsts.arrayBaseOffset(long[].class), ReflectConsts.arrayIndexScale(long[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putLong(target, fieldOffset, (Long)value);
            }

            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getLong(target, fieldOffset);
            }
        }
        ,
        PrimitiveDouble(double[].class, ReflectConsts.arrayBaseOffset(double[].class), ReflectConsts.arrayIndexScale(double[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putDouble(target, fieldOffset, (Double)value);
            }

            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getDouble(target, fieldOffset);
            }
        }
        ,
        PrimitiveBoolean(boolean[].class, ReflectConsts.arrayBaseOffset(boolean[].class), ReflectConsts.arrayIndexScale(boolean[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putBoolean(target, fieldOffset, (Boolean)value);
            }

            Object getValue(Object target, long fieldOffset) {
                return UnsafeHelper.getUnsafe().getBoolean(target, fieldOffset);
            }
        }
        ,
        PrimitiveCharacter(char[].class, ReflectConsts.arrayBaseOffset(char[].class), ReflectConsts.arrayIndexScale(char[].class)){

            void putValue(Object target, long fieldOffset, Object value) {
                UnsafeHelper.getUnsafe().putChar(target, fieldOffset, ((Character)value).charValue());
            }

            Object getValue(Object target, long fieldOffset) {
                return Character.valueOf(UnsafeHelper.getUnsafe().getChar(target, fieldOffset));
            }
        };

        final Class genericArrayType;
        final int arrayBaseOffset;
        final int arrayIndexScale;
        static final int DoubleNameHash = -1325958191;
        static final int IntNameHash = 104431;
        static final int ByteNameHash = 3039496;
        static final int CharNameHash = 3052374;
        static final int LongNameHash = 3327612;
        static final int BooleanNameHash = 64711720;
        static final int FloatNameHash = 97526364;
        static final int ShortNameHash = 109413500;

        private PrimitiveType(Class genericArrayType, int arrayBaseOffset, int arrayIndexScale) {
            this.genericArrayType = genericArrayType;
            this.arrayBaseOffset = arrayBaseOffset;
            this.arrayIndexScale = arrayIndexScale;
        }

        void put(Object target, long fieldOffset, Object value) {
            target.getClass();
            if (value == null) {
                return;
            }
            this.putValue(target, fieldOffset, value);
        }

        Object get(Object target, long fieldOffset) {
            target.getClass();
            return this.getValue(target, fieldOffset);
        }

        abstract Object getValue(Object var1, long var2);

        abstract void putValue(Object var1, long var2, Object var4);

        public static PrimitiveType typeOf(Class<?> fieldType) {
            if (!fieldType.isPrimitive()) {
                return null;
            }
            int hash = fieldType.getName().hashCode();
            switch (hash) {
                case -1325958191: {
                    return PrimitiveDouble;
                }
                case 104431: {
                    return PrimitiveInt;
                }
                case 3039496: {
                    return PrimitiveByte;
                }
                case 3052374: {
                    return PrimitiveCharacter;
                }
                case 3327612: {
                    return PrimitiveLong;
                }
                case 64711720: {
                    return PrimitiveBoolean;
                }
                case 97526364: {
                    return PrimitiveFloat;
                }
                case 109413500: {
                    return PrimitiveShort;
                }
            }
            return null;
        }

        public Class getGenericArrayType() {
            return this.genericArrayType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClassCategory {
        CharSequence,
        NumberCategory,
        BoolCategory,
        DateCategory,
        ClassCategory,
        EnumCategory,
        AnnotationCategory,
        Binary,
        ArrayCategory,
        CollectionCategory,
        MapCategory,
        ObjectCategory,
        ANY,
        NonInstance;

    }
}

