/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.reflect;

import io.github.wycst.wast.common.exceptions.InvokeReflectException;
import io.github.wycst.wast.common.reflect.GenericParameterizedType;
import io.github.wycst.wast.common.reflect.ReflectConsts;
import io.github.wycst.wast.common.reflect.UnsafeHelper;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetterInfo {
    private Field field;
    private long fieldOffset = -1L;
    private boolean fieldPrimitive;
    private ReflectConsts.PrimitiveType primitiveType;
    private String name;
    private Class<?> parameterType;
    private Class<?> actualTypeArgument;
    private int index;
    private GenericParameterizedType genericParameterizedType;
    private boolean nonInstanceType;
    private Map<Class<? extends Annotation>, Annotation> annotations;
    private Boolean existDefault;
    private boolean fieldDisabled;

    public final void invoke(Object target, Object value) {
        if (this.fieldOffset > -1L) {
            if (this.fieldPrimitive) {
                UnsafeHelper.putPrimitiveValue(target, this.fieldOffset, value, this.primitiveType);
            } else {
                UnsafeHelper.putObjectValue(target, this.fieldOffset, value);
            }
            return;
        }
        this.invokeObjectValue(target, value);
    }

    protected void invokeObjectValue(Object target, Object value) {
        try {
            this.field.set(target, value);
        }
        catch (Exception e) {
            throw new InvokeReflectException(e);
        }
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public Class<?> getParameterType() {
        return this.parameterType;
    }

    void setParameterType(Class<?> parameterType) {
        this.parameterType = parameterType;
    }

    public Class<?> getActualTypeArgument() {
        return this.actualTypeArgument;
    }

    void setActualTypeArgument(Class<?> actualTypeArgument) {
        this.actualTypeArgument = actualTypeArgument;
    }

    public boolean isNonInstanceType() {
        return this.nonInstanceType;
    }

    void setNonInstanceType(boolean nonInstanceType) {
        this.nonInstanceType = nonInstanceType;
    }

    public Map<Class<? extends Annotation>, Annotation> getAnnotations() {
        return this.annotations;
    }

    void setAnnotations(Map<Class<? extends Annotation>, Annotation> annotations) {
        this.annotations = annotations;
    }

    void setField(Field field) {
        this.field = field;
        try {
            this.fieldOffset = UnsafeHelper.objectFieldOffset(field);
            this.fieldPrimitive = this.getFieldType().isPrimitive();
            if (this.fieldPrimitive) {
                this.primitiveType = ReflectConsts.PrimitiveType.typeOf(this.getFieldType());
            }
        }
        catch (Throwable throwable) {
            this.fieldOffset = -1L;
        }
    }

    public Class<?> getFieldType() {
        return this.field == null ? null : this.field.getType();
    }

    public GenericParameterizedType getGenericParameterizedType() {
        return this.genericParameterizedType;
    }

    void setGenericParameterizedType(GenericParameterizedType genericParameterizedType) {
        this.genericParameterizedType = genericParameterizedType;
    }

    public Object getDefaultFieldValue(Object instance) {
        if (this.field == null) {
            return null;
        }
        try {
            if (this.existDefault == Boolean.FALSE) {
                return null;
            }
            Object fieldValue = this.field.get(instance);
            this.existDefault = fieldValue != null;
            if (fieldValue != null) {
                return fieldValue;
            }
        }
        catch (Exception e) {
            this.existDefault = Boolean.FALSE;
        }
        return null;
    }

    public Annotation getAnnotation(Class<? extends Annotation> annotationType) {
        return this.annotations.get(annotationType);
    }

    public int getParamClassType() {
        return this.genericParameterizedType.getParamClassType();
    }

    public int getParamClassNumberType() {
        return this.genericParameterizedType.getParamClassNumberType();
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isPrimate() {
        return Modifier.isPrivate(this.field.getModifiers());
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    void setFieldDisabled(boolean disabled) {
        this.fieldDisabled = disabled;
    }

    public boolean isFieldDisabled() {
        return this.fieldDisabled;
    }
}

