/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.template;

import io.github.wycst.wast.common.compiler.MemoryClassLoader;
import io.github.wycst.wast.common.compiler.MemoryJavaFileManager;
import io.github.wycst.wast.common.compiler.MemoryJavaFileObject;
import io.github.wycst.wast.common.exceptions.ParserException;
import io.github.wycst.wast.common.template.TemplateClass;
import io.github.wycst.wast.common.utils.RegexUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringTemplate {
    private static JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
    private static StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
    private static final AtomicLong ATOMIC_LONG = new AtomicLong(0L);
    private static final String PACKAGE_NAME = StringTemplate.class.getPackage().getName();
    private static final String DEFINE_PREFIX = "$define ";
    private static final String FOR_LOOP_REGEX = "^[$]for[ ]*[(][ ]*(\\w+)(,[ ]*(\\w+))?[ ]*[)][ ]*in[ ]*(\\w+)$";
    private static final String IF_REGEX = "^[$]if[ ]*[(](.*?)[)]$";
    private static final String ELSE_IF_REGEX = "^[$]else[ ]+if[ ]*[(](.*?)[)]$";
    private static final String ELSE_REGEX = "^[$]else$";
    private static final String PLACEHOLDER_REGEX = ".*[^\\\\]?[$][{]([ ]*[0-9a-zA-Z_.$]+[ ]*)[}].*";
    private static final Pattern FOR_LOOP_PATTERN = Pattern.compile("^[$]for[ ]*[(][ ]*(\\w+)(,[ ]*(\\w+))?[ ]*[)][ ]*in[ ]*(\\w+)$");
    private static final Pattern IF_PATTERN = Pattern.compile("^[$]if[ ]*[(](.*?)[)]$");
    private static final Pattern ELSE_IF_PATTERN = Pattern.compile("^[$]else[ ]+if[ ]*[(](.*?)[)]$");
    private static final Pattern ELSE_PATTERN = Pattern.compile("^[$]else$");
    private final String templateId = UUID.randomUUID().toString();
    private final byte[] templateJavaSource;
    private TemplateClass templateClass;
    private StringBuffer staticTempBuffer = new StringBuffer();
    private boolean nextNewLine = false;
    private Map<String, Object> context = new HashMap<String, Object>();

    public StringTemplate(String template) {
        StringBuffer importPackages = new StringBuffer();
        importPackages.append("package " + PACKAGE_NAME + ";\r\n");
        importPackages.append("import java.util.*;\r\n");
        StringBuffer source = new StringBuffer();
        String[] lines = template.split("\r\n", -1);
        boolean javaCodeBegin = false;
        boolean userLocalContext = false;
        boolean defineLocalContext = false;
        int scopeLevel = 0;
        int flag = 0;
        int index = 0;
        int lineLength = lines.length;
        for (String line : lines) {
            ++index;
            if (this.nextNewLine) {
                this.nextNewLine = false;
                this.appendIndent(source, scopeLevel);
                source.append("\t\tprintln();\r\n");
            } else if (line.length() == 0) {
                boolean hasAppendNewLine = this.staticTempBuffer.length() > 0;
                this.persistBuffer(source);
                if (index >= lineLength && hasAppendNewLine) continue;
                this.appendIndent(source, scopeLevel);
                source.append("\t\tprintln();\r\n");
                continue;
            }
            line = line.replace("\\", "\\\\");
            line = line.replace("\r", "\\r");
            line = line.replace("\n", "\\n");
            String trimLine = line.trim();
            if (trimLine.startsWith("<%")) {
                if (trimLine.endsWith("%>")) {
                    String lineCode = trimLine.substring(2, trimLine.length() - 2);
                    if (lineCode.startsWith("=")) {
                        source.append("\t\tprintln(\"" + lineCode.substring(1).replace("\"", "\\\"") + "\");\r\n");
                        continue;
                    }
                    if (lineCode.startsWith("import ") && lineCode.endsWith(";")) {
                        importPackages.append(lineCode).append("\r\n");
                        continue;
                    }
                    source.append("\t\t").append(lineCode).append("\r\n");
                    continue;
                }
                javaCodeBegin = true;
                continue;
            }
            if (trimLine.endsWith("%>")) {
                javaCodeBegin = false;
                continue;
            }
            if (javaCodeBegin) {
                if (trimLine.startsWith("import ") && trimLine.endsWith(";")) {
                    importPackages.append(line);
                    continue;
                }
                source.append("\t\t").append(line).append("\r\n");
                continue;
            }
            boolean isTextLine = true;
            if (trimLine.startsWith("$")) {
                isTextLine = false;
                if (trimLine.matches(FOR_LOOP_REGEX)) {
                    this.persistBuffer(source);
                    if (!defineLocalContext) {
                        this.appendDefineSource(source, line, "Map<String,Object> localContext = null;");
                        this.appendDefineSource(source, line, "Iterable<Object> iterable = null;");
                        this.appendDefineSource(source, line, "int index = 0;");
                        defineLocalContext = true;
                    }
                    userLocalContext = this.appendForLoopSource(source, line, trimLine);
                    ++flag;
                    ++scopeLevel;
                } else if (trimLine.startsWith(DEFINE_PREFIX)) {
                    this.persistBuffer(source);
                    this.appendIndent(source, scopeLevel);
                    this.appendDefineSource(source, line, trimLine);
                } else if (trimLine.matches(IF_REGEX)) {
                    this.persistBuffer(source);
                    this.appendIndent(source, scopeLevel);
                    this.appendIfClauseSource(source, line, trimLine);
                    ++flag;
                    ++scopeLevel;
                } else if (trimLine.matches(ELSE_IF_REGEX)) {
                    this.persistBuffer(source);
                    this.appendElseIfClauseSource(source, line, trimLine);
                    ++flag;
                } else if (trimLine.matches(ELSE_REGEX)) {
                    this.persistBuffer(source);
                    this.appendElseClauseSource(source, line, trimLine);
                    ++flag;
                } else if (trimLine.equals("$end")) {
                    this.persistBuffer(source);
                    if (scopeLevel > 0) {
                        --scopeLevel;
                    }
                    this.appendIndent(source, scopeLevel);
                    source.append("\t\t}\r\n");
                    --flag;
                } else {
                    isTextLine = true;
                }
                if (flag == 0) {
                    userLocalContext = false;
                    if (scopeLevel > 0) {
                        --scopeLevel;
                    }
                }
            }
            if (!isTextLine) continue;
            if (line.matches(PLACEHOLDER_REGEX)) {
                this.persistBuffer(source);
                line = line.replace("\"", "\\\"");
                this.appendIndent(source, scopeLevel);
                this.appendPlaceHolderLine(source, line, userLocalContext ? "localContext" : "context", scopeLevel);
                continue;
            }
            if (this.staticTempBuffer.length() == 0) {
                this.appendIndent(source, scopeLevel);
            }
            this.appendBuffer(line.replace("\"", "\\\""));
        }
        this.persistBuffer(source, false);
        String simpleClassName = this.genTemplateClassName();
        String javaCode = this.getJavaCode(simpleClassName, importPackages, source);
        this.templateJavaSource = javaCode.getBytes();
        try {
            MemoryJavaFileManager javaFileManager = new MemoryJavaFileManager(fileManager);
            JavaFileObject javaFileObject = javaFileManager.createJavaFileObject(simpleClassName + ".java", javaCode);
            JavaCompiler.CompilationTask task = compiler.getTask(null, javaFileManager, null, Arrays.asList("-encoding", "UTF-8"), null, Arrays.asList(javaFileObject));
            boolean bl = task.call();
            if (bl) {
                MemoryJavaFileObject memoryJavaFileObject = javaFileManager.getMemoryJavaFileObject();
                MemoryClassLoader memoryClassLoader = new MemoryClassLoader(memoryJavaFileObject);
                this.templateClass = (TemplateClass)memoryClassLoader.loadClass(PACKAGE_NAME + "." + simpleClassName).newInstance();
            }
        }
        catch (Throwable e) {
            throw new ParserException(" parse exception :" + e.getMessage(), e);
        }
    }

    private void appendIndent(StringBuffer source, int scopeLevel) {
        while (scopeLevel-- > 0) {
            source.append("\t");
        }
    }

    private String genTemplateClassName() {
        return String.format("StringTemplate$_%d", ATOMIC_LONG.getAndIncrement());
    }

    private String getJavaCode(String className, StringBuffer importPackages, StringBuffer source) {
        StringBuffer javaCodeBuffer = new StringBuffer();
        javaCodeBuffer.append(importPackages);
        javaCodeBuffer.append("public class ").append(className).append(" extends TemplateClass {\r\n");
        javaCodeBuffer.append("\r\n");
        javaCodeBuffer.append("\tprotected void renderTemplate(final Map<String,Object> context) {\r\n").append(source).append("\r\n").append("\t}\r\n");
        javaCodeBuffer.append("}");
        return javaCodeBuffer.toString();
    }

    private void appendDefineSource(StringBuffer source, String line, String trimLine) {
        this.persistBuffer(source);
        if (trimLine.startsWith(DEFINE_PREFIX)) {
            source.append("\t\t").append(trimLine.substring(DEFINE_PREFIX.length()));
        } else {
            source.append("\t\t").append(trimLine);
        }
        if (!trimLine.endsWith(";")) {
            source.append(";");
        }
        source.append("\r\n");
    }

    private void appendBuffer(String line) {
        if (this.staticTempBuffer.length() > 0) {
            this.staticTempBuffer.append("\\r\\n");
        }
        this.staticTempBuffer.append(line);
    }

    private void appendPlaceHolderLine(StringBuffer source, String line, String contextName, int scopeLevel) {
        String reg = "[$][{]([ ]*[0-9a-zA-Z_.$]+[ ]*)[}]";
        Pattern pattern = RegexUtils.getPattern(reg);
        Matcher matcher = pattern.matcher(line);
        int beginIndex = 0;
        StringBuffer buffer = this.staticTempBuffer;
        boolean hasNewlineFlag = false;
        while (matcher.find()) {
            int newBeginIndex = matcher.start(0);
            if (newBeginIndex > 1 && line.charAt(newBeginIndex - 1) == '\\') {
                if (!hasNewlineFlag && buffer.length() > 0) {
                    buffer.append("\\r\\n");
                    hasNewlineFlag = true;
                }
                buffer.append(line, beginIndex, newBeginIndex - 2);
                buffer.append(matcher.group(0));
            } else {
                String key = matcher.group(1).trim();
                buffer.append(line, beginIndex, newBeginIndex);
                this.persistBuffer(source, false);
                this.appendIndent(source, scopeLevel);
                source.append("\t\tprint(getContextValue(" + contextName + ", \"" + key + "\", \"\"));\r\n");
                this.appendIndent(source, scopeLevel);
            }
            beginIndex = matcher.end(0);
        }
        if (beginIndex < line.length()) {
            buffer.append(line, beginIndex, line.length());
        } else {
            this.nextNewLine = true;
        }
    }

    private void persistBuffer(StringBuffer source) {
        this.persistBuffer(source, true);
    }

    private void persistBuffer(StringBuffer source, int level) {
        this.appendIndent(source, level);
        this.persistBuffer(source, true);
    }

    private void persistBuffer(StringBuffer source, boolean newLine) {
        if (this.staticTempBuffer.length() > 0) {
            if (newLine) {
                source.append("\t\tprintln(\"").append(this.staticTempBuffer).append("\");\r\n");
            } else {
                source.append("\t\tprint(\"").append(this.staticTempBuffer).append("\");\r\n");
            }
            this.staticTempBuffer.setLength(0);
        }
    }

    private boolean appendForLoopSource(StringBuffer source, String line, String trimLine) {
        Matcher matcher = FOR_LOOP_PATTERN.matcher(trimLine);
        boolean matched = false;
        if (matcher.find()) {
            matched = true;
            String itemKey = matcher.group(1);
            String indexKey = matcher.group(3);
            String itemsKey = matcher.group(4);
            source.append("\t\titerable = getContextIterable(context, \"" + itemsKey + "\");\r\n");
            source.append("\t\tlocalContext = new HashMap<String,Object>(context);\r\n");
            if (indexKey != null) {
                source.append("\t\tindex = 0;\r\n");
            }
            source.append("\t\tfor (Object " + itemKey + " : iterable) {\r\n");
            source.append("\t\t\tlocalContext.put(\"" + itemKey + "\", " + itemKey + ");\r\n");
            if (indexKey != null) {
                source.append("\t\t\tlocalContext.put(\"" + indexKey + "\", index++);\r\n");
            }
        }
        return matched;
    }

    private boolean appendIfClauseSource(StringBuffer source, String line, String trimLine) {
        Matcher matcher = IF_PATTERN.matcher(trimLine);
        boolean matched = false;
        if (matcher.find()) {
            matched = true;
            String condition = matcher.group(1);
            source.append("\t\tif(").append(condition).append("){\r\n");
        }
        return matched;
    }

    private boolean appendElseIfClauseSource(StringBuffer source, String line, String trimLine) {
        Matcher matcher = ELSE_IF_PATTERN.matcher(trimLine);
        boolean matched = false;
        if (matcher.find()) {
            matched = true;
            String condition = matcher.group(1);
            source.append("\t\t} else if(").append(condition).append("){\r\n\t");
        }
        return matched;
    }

    private void appendElseClauseSource(StringBuffer source, String line, String trimLine) {
        source.append("\t\t} else {\r\n\t");
    }

    public void binding(String key, Object value) {
        this.context.put(key, value);
    }

    public void binding(Map<String, Object> data) {
        this.context.putAll(data);
    }

    public void clearBinging() {
        this.context.clear();
    }

    public void clearBinging(String key) {
        this.context.remove(key);
    }

    public synchronized String render() {
        return this.render(this.context);
    }

    public synchronized String render(Map<String, Object> context) {
        return this.templateClass.render(context);
    }

    public final String getId() {
        return this.templateId;
    }

    byte[] getTemplateJavaSource() {
        return this.templateJavaSource;
    }
}

