/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.common.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexUtils {
    private static Map<String, Pattern> cachePatterns = new ConcurrentHashMap<String, Pattern>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pattern getPattern(String regSource) {
        Pattern pattern = cachePatterns.get(regSource);
        if (pattern != null) {
            return pattern;
        }
        String string = regSource;
        synchronized (string) {
            pattern = cachePatterns.get(regSource);
            if (pattern == null) {
                pattern = Pattern.compile(regSource);
                cachePatterns.put(regSource, pattern);
            }
            return pattern;
        }
    }

    public static List<String> getMatcherGroups(String source, String groupRegex) {
        return RegexUtils.getMatcherGroups(source, groupRegex, true);
    }

    public static List<String> getMatcherGroups(String source, String groupRegex, boolean iterator) {
        ArrayList<String> matcherGroups = new ArrayList<String>();
        int begin = groupRegex.indexOf(40);
        if (begin == -1 || groupRegex.indexOf(41) <= begin) {
            return matcherGroups;
        }
        Pattern pattern = RegexUtils.getPattern(groupRegex);
        Matcher matcher = pattern.matcher(source);
        while (matcher.find()) {
            int groupCount = matcher.groupCount();
            if (iterator) {
                int i = 0;
                while (i++ < groupCount) {
                    matcherGroups.add(matcher.group(i));
                }
                continue;
            }
            if (groupCount <= 0) continue;
            matcherGroups.add(matcher.group(1));
        }
        return matcherGroups;
    }
}

