/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.connection;

import io.github.wycst.wast.jdbc.transaction.TransactionUtils;
import java.sql.Connection;
import java.sql.SQLException;

public class ConnectionWraper {
    private Connection physicalConn;
    private long currentInfluencingRows;
    private boolean transaction;

    public ConnectionWraper(Connection physicalConn) {
        this.physicalConn = physicalConn;
    }

    public void setConnection(Connection physicalConn) {
        this.physicalConn = physicalConn;
    }

    public Connection getConnection() {
        return this.physicalConn;
    }

    public long getCurrentInfluencingRows() {
        return this.currentInfluencingRows;
    }

    public void setCurrentInfluencingRows(long currentInfluencingRows) {
        this.currentInfluencingRows = currentInfluencingRows;
    }

    public boolean isTransaction() {
        return this.transaction;
    }

    public void setTransaction(boolean transaction) {
        this.transaction = transaction;
    }

    public void close() {
        try {
            if (this.physicalConn != null && !this.physicalConn.isClosed()) {
                this.physicalConn.setAutoCommit(true);
                this.physicalConn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.physicalConn = null;
    }

    public void handlerCloseAction() {
        if (!TransactionUtils.isTransactionActive()) {
            this.close();
        }
    }

    public void addInfluencingRows(int effect) {
        if (TransactionUtils.isTransactionActive()) {
            this.currentInfluencingRows += (long)effect;
        }
    }

    public void clear() {
        this.currentInfluencingRows = 0L;
        this.physicalConn = null;
        this.transaction = false;
    }
}

