/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.connection;

import io.github.wycst.wast.jdbc.connection.AbstractConnectionManager;
import io.github.wycst.wast.jdbc.connection.ConnectionManager;
import io.github.wycst.wast.jdbc.connection.ConnectionWraper;
import io.github.wycst.wast.jdbc.transaction.TransactionUtils;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class DefaultConnectionManager
extends AbstractConnectionManager
implements ConnectionManager {
    public DefaultConnectionManager(DataSource dataSource) {
        super(dataSource);
    }

    public ConnectionWraper getConnectionWraper() {
        Connection physicalConn = null;
        DataSource dataSource = this.getDataSource();
        dataSource.getClass();
        boolean isTransactionActive = TransactionUtils.isTransactionActive();
        if (!isTransactionActive) {
            try {
                physicalConn = dataSource.getConnection();
                return new ConnectionWraper(physicalConn);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(" create connection error for ...", e);
            }
        }
        ConnectionWraper wraper = this.currentConnectionWraper();
        if (wraper != null && (physicalConn = wraper.getConnection()) != null) {
            try {
                if (!physicalConn.isClosed()) {
                    return wraper;
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        try {
            physicalConn = dataSource.getConnection();
            physicalConn.setAutoCommit(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        physicalConn.getClass();
        if (wraper == null) {
            wraper = new ConnectionWraper(physicalConn);
            wraper.setTransaction(true);
        } else {
            wraper.setConnection(physicalConn);
        }
        this.bindConnectionWraper(wraper);
        return wraper;
    }

    public void closeConnection(ConnectionWraper wraper) {
        wraper.handlerCloseAction();
    }

    public void beginTransaction() {
        TransactionUtils.setTransactionActive(true);
        super.beginTransaction();
    }

    public void endTransaction() {
        TransactionUtils.setTransactionActive(false);
        super.endTransaction();
    }

    public void clear() {
        ConnectionWraper wraper = this.currentConnectionWraper();
        if (wraper != null) {
            if (wraper.isTransaction() && wraper.getCurrentInfluencingRows() > 0L) {
                this.rollbackTransaction();
            }
            wraper.clear();
        }
        super.clear();
    }
}

