/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.dialect;

import io.github.wycst.wast.jdbc.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public abstract class DialectImpl
implements Dialect {
    public boolean supportsLimit() {
        return false;
    }

    public abstract String getLimitString(String var1, boolean var2);

    public abstract String getLimitString(String var1, long var2, int var4);

    public void setParameter(PreparedStatement ps, int index, Object param) throws SQLException {
        if (param instanceof String) {
            ps.setString(index, (String)param);
        } else if (param instanceof Timestamp) {
            ps.setTimestamp(index, (Timestamp)param);
        } else if (param instanceof Date) {
            if (param.getClass() == Date.class) {
                ps.setTimestamp(index, new Timestamp(((Date)param).getTime()));
            } else {
                ps.setDate(index, new java.sql.Date(((Date)param).getTime()));
            }
        } else if (param instanceof Enum) {
            ps.setString(index, param.toString());
        } else {
            ps.setObject(index, param);
        }
    }

    public PreparedStatement prepareStatement(Connection conn, String sql, int type, int resultSetConcurrency) throws SQLException {
        if (type > -1 && resultSetConcurrency > -1) {
            return conn.prepareStatement(sql, type, resultSetConcurrency);
        }
        if (type == 1) {
            return conn.prepareStatement(sql, type);
        }
        return conn.prepareStatement(sql);
    }
}

