/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.dialect;

import io.github.wycst.wast.jdbc.dialect.Dialect;
import io.github.wycst.wast.jdbc.dialect.DialectImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class MySqlDialect
extends DialectImpl
implements Dialect {
    protected static final String SQL_END_SYMBOL = ";";

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        String limit;
        sql = sql.trim();
        boolean hasSqlEndSymbol = sql.endsWith(SQL_END_SYMBOL);
        StringBuffer buffer = new StringBuffer(sql.length() + 10);
        buffer.append(sql);
        String string = limit = hasOffset ? " limit ?,? " : " limit ? ";
        if (hasSqlEndSymbol) {
            buffer.insert(buffer.length() - 1, limit);
        } else {
            buffer.append(limit);
        }
        return buffer.toString();
    }

    public String getLimitString(String sql, long offset, int limit) {
        sql = sql.trim();
        boolean hasSqlEndSymbol = sql.endsWith(SQL_END_SYMBOL);
        StringBuffer buffer = new StringBuffer(sql.length() + 10);
        buffer.append(sql);
        if (hasSqlEndSymbol) {
            buffer.delete(buffer.length() - SQL_END_SYMBOL.length(), buffer.length());
        }
        if (offset > 0L) {
            buffer.append(" limit ").append(offset).append(',').append(limit);
        } else {
            buffer.append(" limit ").append(limit);
        }
        if (hasSqlEndSymbol) {
            buffer.append(SQL_END_SYMBOL);
        }
        return buffer.toString();
    }

    public PreparedStatement prepareStatement(Connection conn, String sql, int type, int resultSetConcurrency) throws SQLException {
        if (type > -1 && resultSetConcurrency > -1) {
            PreparedStatement statement = conn.prepareStatement(sql, type, resultSetConcurrency);
            if (type == 1003 && resultSetConcurrency == 1007) {
                statement.setFetchSize(Integer.MIN_VALUE);
            }
            return statement;
        }
        if (type == 1) {
            return conn.prepareStatement(sql, type);
        }
        return conn.prepareStatement(sql);
    }
}

