/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.executer;

import io.github.wycst.wast.common.reflect.ClassStructureWrapper;
import io.github.wycst.wast.common.reflect.SetterInfo;
import io.github.wycst.wast.common.utils.ClassUtils;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.annotations.CascadeFetch;
import io.github.wycst.wast.jdbc.annotations.Column;
import io.github.wycst.wast.jdbc.annotations.Id;
import io.github.wycst.wast.jdbc.annotations.Join;
import io.github.wycst.wast.jdbc.annotations.JoinField;
import io.github.wycst.wast.jdbc.annotations.MapperClass;
import io.github.wycst.wast.jdbc.annotations.Table;
import io.github.wycst.wast.jdbc.annotations.Transient;
import io.github.wycst.wast.jdbc.entity.CascadeFetchMapping;
import io.github.wycst.wast.jdbc.entity.EntitySqlMapping;
import io.github.wycst.wast.jdbc.entity.FieldColumn;
import io.github.wycst.wast.jdbc.entity.JoinColumn;
import io.github.wycst.wast.jdbc.entity.JoinEntityMapping;
import io.github.wycst.wast.jdbc.exception.EntityException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityManagementFactory {
    private String entityScanPackages;
    private final Map<Class<?>, EntitySqlMapping> entitySqlMappings = new HashMap();
    static final EntityManagementFactory Default = new EntityManagementFactory();
    static final List<String> DatabaseKeyWords = Arrays.asList("table", "column", "describe", "order", "asc", "desc", "current_date", "terminated", "by", "cursor", "distinct", "explain", "fulltext", "mod", "xor", "range", "limit", "rename");

    private EntityManagementFactory() {
    }

    public static EntityManagementFactory defaultManagementFactory() {
        return Default;
    }

    public EntityManagementFactory setEntityScanPackages(String entityScanPackages) {
        this.entityScanPackages = entityScanPackages;
        return this;
    }

    public final EntityManagementFactory init() {
        this.checkScanPackages();
        this.scanEntitys();
        return this;
    }

    private void checkScanPackages() {
        if (StringUtils.isEmpty(this.entityScanPackages)) {
            throw new EntityException("Entity scan packages not specified, setEntityScanPackages(arg0) should be call before invoke init() ");
        }
    }

    private Collection<Field> getEntityFields(Class<?> entityCls) {
        Class<?> parentClass;
        Field[] fields;
        LinkedHashMap<String, Field> fieldMap = new LinkedHashMap<String, Field>();
        for (Field field : fields = entityCls.getDeclaredFields()) {
            fieldMap.put(field.getName(), field);
        }
        for (parentClass = entityCls.getSuperclass(); parentClass != null && !parentClass.isAnnotationPresent(MapperClass.class); parentClass = parentClass.getSuperclass()) {
        }
        if (parentClass != null) {
            for (Field field : parentClass.getDeclaredFields()) {
                if (fieldMap.containsKey(field.getName())) continue;
                fieldMap.put(field.getName(), field);
            }
        }
        return fieldMap.values();
    }

    public void scanPackages(String ... scanPackages) {
        Set<Class<?>> entityClsSet = ClassUtils.findClasses(scanPackages, Object.class, Table.class, false);
        HashMap entityJoinFields = new HashMap();
        for (Class<Object> entityCls : entityClsSet) {
            if (entityCls.isAnnotationPresent(MapperClass.class)) {
                throw new EntityException(" Entity Class " + entityCls + " AnnotationPresent[MapperClass] are not allowed ! ");
            }
            Table table = entityCls.getAnnotation(Table.class);
            String tableName = table.name().trim();
            if (StringUtils.isEmpty(tableName)) {
                tableName = entityCls.getSimpleName();
            }
            LinkedHashMap<String, FieldColumn> fieldColumnMapping = new LinkedHashMap<String, FieldColumn>();
            LinkedHashMap joinEntityMappings = new LinkedHashMap();
            FieldColumn primary = null;
            Collection<Field> fields = this.getEntityFields(entityCls);
            ClassStructureWrapper classStructureWrapper = ClassStructureWrapper.get(entityCls);
            HashMap<String, JoinField> joinFields = new HashMap<String, JoinField>();
            ArrayList cascadeFetchMappings = new ArrayList();
            for (Field field : fields) {
                Join join;
                String fieldName;
                if (field.getAnnotation(Transient.class) != null || !classStructureWrapper.containsSetterKey(fieldName = field.getName())) continue;
                if (field.getAnnotation(JoinField.class) != null) {
                    joinFields.put(fieldName, field.getAnnotation(JoinField.class));
                    continue;
                }
                if (field.isAnnotationPresent(CascadeFetch.class)) {
                    SetterInfo setterInfo;
                    Class<?> actualType;
                    int fieldTypeValue = 0;
                    Class<?> targetEntityClass = null;
                    Class<?> fieldType = field.getType();
                    if (entityClsSet.contains(fieldType)) {
                        fieldTypeValue = 1;
                        targetEntityClass = fieldType;
                    } else if (List.class.isAssignableFrom(fieldType) && entityClsSet.contains(actualType = (setterInfo = classStructureWrapper.getSetterInfo(fieldName)).getActualTypeArgument())) {
                        fieldTypeValue = 2;
                        targetEntityClass = actualType;
                    }
                    if (targetEntityClass != null) {
                        CascadeFetch cascadeFetch = field.getAnnotation(CascadeFetch.class);
                        String sourceFieldName = cascadeFetch.field();
                        String targetFieldName = cascadeFetch.targetField();
                        boolean cascade = cascadeFetch.cascade();
                        boolean fetch = cascadeFetch.fetch();
                        CascadeFetchMapping cascadeFetchMapping = new CascadeFetchMapping();
                        cascadeFetchMapping.setFieldType(fieldTypeValue);
                        cascadeFetchMapping.setTargetEntityClass(targetEntityClass);
                        cascadeFetchMapping.setFieldName(sourceFieldName);
                        cascadeFetchMapping.setCascadeFetchField(field);
                        cascadeFetchMapping.setTargetFieldName(targetFieldName);
                        cascadeFetchMapping.setFetch(fetch);
                        cascadeFetchMapping.setCascade(cascade);
                        cascadeFetchMappings.add(cascadeFetchMapping);
                        continue;
                    }
                    throw new EntityException(" Entity " + entityCls + " " + field + " annotationPresent @CascadeFetch but the field type is not be an entity or the list generic is not an entity type");
                }
                String columnName = null;
                Column column = field.getAnnotation(Column.class);
                if (column != null) {
                    columnName = column.name();
                    if (StringUtils.isEmpty(columnName)) {
                        columnName = StringUtils.camelCaseToSymbol(fieldName);
                    }
                } else {
                    columnName = StringUtils.camelCaseToSymbol(fieldName);
                }
                if (DatabaseKeyWords.contains(columnName.toLowerCase())) {
                    char[] chars = new char[columnName.length() + 2];
                    chars[columnName.length() + 1] = 96;
                    chars[0] = 96;
                    columnName.getChars(0, columnName.length(), chars, 1);
                    columnName = new String(chars);
                }
                FieldColumn fieldColumn = new FieldColumn();
                fieldColumn.setField(field);
                fieldColumn.setColumn(column);
                fieldColumn.setColumnName(columnName);
                fieldColumnMapping.put(fieldName, fieldColumn);
                if (field.getAnnotation(Id.class) != null) {
                    primary = fieldColumn;
                    Id id = field.getAnnotation(Id.class);
                    primary.setId(id);
                    primary.setPrimary(true);
                }
                if ((join = field.getAnnotation(Join.class)) == null) continue;
                Class<?> target = join.target();
                if (!entityClsSet.contains(target)) {
                    throw new EntityException(" Entity Class " + entityCls + " , field " + field + " Annotation@Join target class " + target + " is not a Table Entity");
                }
                String fieldKey = join.field();
                JoinEntityMapping joinEntityMapping = (JoinEntityMapping)joinEntityMappings.get(target);
                if (joinEntityMapping == null) {
                    joinEntityMapping = new JoinEntityMapping();
                    joinEntityMappings.put(target, joinEntityMapping);
                }
                joinEntityMapping.getJoinOnFieldKeys().put(fieldName, fieldKey);
            }
            if (joinFields.size() > 0) {
                entityJoinFields.put(entityCls, joinFields);
            }
            EntitySqlMapping entitySqlMapping = new EntitySqlMapping(entityCls, tableName, fieldColumnMapping, primary, joinEntityMappings, cascadeFetchMappings);
            this.entitySqlMappings.put(entityCls, entitySqlMapping);
        }
        for (Class<Object> entityCls : entityJoinFields.keySet()) {
            String joinFieldName;
            EntitySqlMapping targetEntitySqlMapping;
            Map joinFields = (Map)entityJoinFields.get(entityCls);
            EntitySqlMapping entitySqlMapping = this.entitySqlMappings.get(entityCls);
            Map<Class<?>, JoinEntityMapping> joinEntityMappings = entitySqlMapping.getJoinEntityMappings();
            for (Class<?> joinClass : joinEntityMappings.keySet()) {
                JoinEntityMapping joinEntityMapping = joinEntityMappings.get(joinClass);
                Map<String, String> joinOnFieldKeys = joinEntityMapping.getJoinOnFieldKeys();
                targetEntitySqlMapping = this.entitySqlMappings.get(joinClass);
                for (String fieldName : joinOnFieldKeys.keySet()) {
                    joinFieldName = joinOnFieldKeys.get(fieldName);
                    String columnName = entitySqlMapping.getFieldColumnMapping().get(fieldName).getColumnName();
                    String joinColumnName = targetEntitySqlMapping.getFieldColumnMapping().get(joinFieldName).getColumnName();
                    joinEntityMapping.getJoinOnColumnKeys().put(columnName, joinColumnName);
                }
            }
            for (String fieldName : joinFields.keySet()) {
                JoinField joinField = (JoinField)joinFields.get(fieldName);
                Class<?> target = joinField.target();
                if (!entityClsSet.contains(target)) {
                    throw new EntityException(" Entity Class '" + entityCls + "' , field '" + fieldName + "' annotation@JoinField target class '" + target + "' is not a Table Entity");
                }
                targetEntitySqlMapping = this.entitySqlMappings.get(target);
                if (!joinEntityMappings.containsKey(target)) {
                    throw new EntityException(" Entity Class " + entityCls + " , field " + fieldName + " annotation@JoinField target class '" + target + "' has not targetClass by annotation@Join ");
                }
                JoinEntityMapping joinEntityMapping = joinEntityMappings.get(target);
                joinEntityMapping.setTableName(targetEntitySqlMapping.getTableName());
                JoinColumn joinColumn = new JoinColumn();
                joinColumn.setFieldName(fieldName);
                joinFieldName = joinField.field();
                Map<String, FieldColumn> targetFieldColumnMapping = targetEntitySqlMapping.getFieldColumnMapping();
                if (!targetFieldColumnMapping.containsKey(joinFieldName)) {
                    throw new EntityException(" Entity Class " + entityCls + " , field " + fieldName + " annotation@JoinField field '" + joinFieldName + "' has not a field at class " + target);
                }
                FieldColumn fieldColumn = targetFieldColumnMapping.get(joinFieldName);
                joinColumn.setJoinFieldColumn(fieldColumn);
                joinEntityMapping.getJoinColumns().add(joinColumn);
            }
            entitySqlMapping.init();
        }
    }

    private void scanEntitys() {
        this.entitySqlMappings.clear();
        this.scanPackages(this.entityScanPackages.split(","));
    }

    public void clear() {
        this.entitySqlMappings.clear();
    }

    public boolean existEntity(Class<?> entityCls) {
        return this.entitySqlMappings.containsKey(entityCls);
    }

    public EntitySqlMapping getEntitySqlMapping(Class entityCls) {
        return this.entitySqlMappings.get(entityCls);
    }
}

