/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.generator;

import io.github.wycst.wast.common.template.StringTemplate;
import io.github.wycst.wast.common.template.StringTemplateManager;
import io.github.wycst.wast.common.utils.StringUtils;
import io.github.wycst.wast.jdbc.commands.SqlExecuteCall;
import io.github.wycst.wast.jdbc.exception.SqlExecuteException;
import io.github.wycst.wast.jdbc.executer.DefaultSqlExecuter;
import io.github.wycst.wast.jdbc.generator.GeneratorColumnOption;
import io.github.wycst.wast.jdbc.generator.GeneratorContext;
import io.github.wycst.wast.jdbc.generator.GeneratorTable;
import io.github.wycst.wast.jdbc.generator.GeneratorTableColumn;
import io.github.wycst.wast.jdbc.generator.GeneratorTableOption;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.sql.DataSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator {
    private static final String controllerTemplate = StringUtils.fromResource("/generator/tpl/Controller.tpl");
    private static final String serviceTemplate = StringUtils.fromResource("/generator/tpl/Service.tpl");
    private static final String serviceImplTemplate = StringUtils.fromResource("/generator/tpl/ServiceImpl.tpl");
    private static final String apiJsTemplate = StringUtils.fromResource("/generator/tpl/ApiJs.tpl");
    private static final StringTemplate vueTemplate = StringTemplateManager.getStringTemplate("/generator/tpl/Vue.tpl");

    public static void generate(GeneratorContext context, DataSource dataSource) {
        DefaultSqlExecuter sqlExecuter = new DefaultSqlExecuter();
        sqlExecuter.setDataSource(dataSource);
        final ArrayList<GeneratorTable> generatorTables = new ArrayList<GeneratorTable>();
        final String[] tableNames = context.getTableNames();
        if (tableNames != null) {
            sqlExecuter.executePipelined(new SqlExecuteCall<Object>(){

                @Override
                public Object execute(Connection connection) throws SQLException {
                    for (String tableName : tableNames) {
                        GeneratorTableOption tableOption = new GeneratorTableOption();
                        tableOption.setTableName(tableName);
                        GeneratorTable generatorTable = new GeneratorTable();
                        generatorTable.setTableColumns(CodeGenerator.generateTableColumns(connection, tableOption));
                        generatorTables.add(generatorTable);
                    }
                    return null;
                }
            });
        } else {
            Map<String, GeneratorTableOption> tableOptionMap = context.getTableOptions();
            if (tableOptionMap != null) {
                for (GeneratorTableOption tableOption : tableOptionMap.values()) {
                    GeneratorTable generatorTable = CodeGenerator.generateTable(tableOption, context, dataSource);
                    generatorTables.add(generatorTable);
                }
            }
        }
        context.setGeneratorTables(generatorTables);
        try {
            context.writeFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GeneratorTable generateTable(String tableName, GeneratorContext context, DataSource dataSource) {
        GeneratorTableOption tableOption = new GeneratorTableOption();
        tableOption.setTableName(tableName);
        return CodeGenerator.generateTable(tableOption, context, dataSource);
    }

    public static GeneratorTable generateTable(final GeneratorTableOption tableOption, GeneratorContext context, DataSource dataSource) {
        boolean usePackage;
        String tableName = tableOption.getTableName();
        int primaryPolicy = tableOption.getPrimaryPolicy();
        String deletePrefixAsModule = tableOption.getDeletePrefixAsModule();
        String author = context.getAuthor();
        String basePackage = context.getBasePackage();
        String entityPackage = context.getEntityPackage();
        boolean bl = usePackage = basePackage != null || entityPackage != null;
        if (usePackage && entityPackage == null) {
            entityPackage = basePackage + ".entitys";
        }
        final GeneratorTable generatorTable = new GeneratorTable();
        generatorTable.setTableName(tableName);
        boolean useLombok = context.isUseLombok();
        String deletePrefix = context.getDeletePrefixAsEntity();
        String entityName = StringUtils.getCamelCase(tableName.startsWith(deletePrefix) ? tableName.substring(deletePrefix.length()) : deletePrefix, true);
        generatorTable.setEntityName(entityName);
        generatorTable.setUpperCaseModuleName(deletePrefixAsModule == null ? entityName : entityName.substring(deletePrefixAsModule.length()));
        generatorTable.setLowerCaseModuleName(StringUtils.getCamelCase(generatorTable.getUpperCaseModuleName()));
        String modulePath = StringUtils.camelCaseToSymbol(generatorTable.getLowerCaseModuleName(), "-");
        generatorTable.setModulePath(modulePath);
        StringBuffer entityBuffer = new StringBuffer();
        if (usePackage) {
            entityBuffer.append(String.format("package %s;\n\n", entityPackage));
        }
        entityBuffer.append("import io.github.wycst.wast.jdbc.annotations.*;\n");
        entityBuffer.append("import io.github.wycst.wast.jdbc.annotations.Id.GenerationType;\n");
        entityBuffer.append(String.format("/**\n * <p> Table: %s\n *\n * @author       %s\n * @date         %s\n */\n", tableName, author, new Date().toString()));
        if (useLombok) {
            entityBuffer.append("@lombok.Data\n");
        }
        entityBuffer.append("@Table(name = \"" + tableName + "\")\n");
        entityBuffer.append("public class " + entityName + " implements java.io.Serializable {\n\n");
        DefaultSqlExecuter sqlExecuter = new DefaultSqlExecuter();
        sqlExecuter.setDataSource(dataSource);
        sqlExecuter.executePipelined(new SqlExecuteCall<Object>(){

            @Override
            public Object execute(Connection connection) throws SQLException {
                Map tableColumns = CodeGenerator.generateTableColumns(connection, tableOption);
                generatorTable.setTableColumns(tableColumns);
                return null;
            }
        });
        StringBuffer fieldsBuffer = new StringBuffer();
        StringBuffer getterSetterBuffer = new StringBuffer();
        Collection<GeneratorTableColumn> tableColumns = generatorTable.getTableColumns().values();
        int queryIndex = 0;
        for (GeneratorTableColumn tableColumn : tableColumns) {
            String columnName = tableColumn.getColumnName();
            String javaField = tableColumn.getJavaField();
            int javaType = tableColumn.getJavaType();
            String javaTypeName = tableColumn.getJavaTypeName();
            boolean primary = tableColumn.isPrimary();
            if (primary) {
                if (primaryPolicy == 1) {
                    fieldsBuffer.append("    @Id(strategy = GenerationType.Identity)\n");
                } else if (primaryPolicy == 2) {
                    fieldsBuffer.append("    @Id(strategy = GenerationType.UUID)\n");
                } else if (primaryPolicy == 3) {
                    fieldsBuffer.append("    @Id(strategy = GenerationType.AutoAlg)\n");
                } else if (primaryPolicy == 4) {
                    fieldsBuffer.append("    @Id(strategy = GenerationType.Sequence)\n");
                } else {
                    fieldsBuffer.append("    @Id\n");
                }
            }
            fieldsBuffer.append("    @Column(name = \"" + columnName + "\")\n");
            fieldsBuffer.append("    private " + javaTypeName + " " + javaField + ";\n\n");
            if (!useLombok) {
                getterSetterBuffer.append("    public " + javaTypeName + " get" + StringUtils.getCamelCase(javaField, true) + "() {\n");
                getterSetterBuffer.append("        return ").append(javaField).append(";\n");
                getterSetterBuffer.append("    }\n\n");
                getterSetterBuffer.append("    public void set" + StringUtils.getCamelCase(javaField, true) + String.format("(%s %s) {\n", javaTypeName, javaField));
                getterSetterBuffer.append("        this.").append(javaField).append(" = ").append(javaField).append(";\n");
                getterSetterBuffer.append("    }\n\n");
            }
            GeneratorColumnOption columnOption = new GeneratorColumnOption();
            if (!primary) {
                if (queryIndex++ < 2) {
                    columnOption.setQuery(true);
                }
                columnOption.setUpdate(!primary);
                columnOption.setDisplay(javaType == 1);
            }
            tableColumn.setColumnOption(columnOption);
        }
        entityBuffer.append(fieldsBuffer).append(getterSetterBuffer);
        entityBuffer.append("}");
        generatorTable.setEntityCode(entityBuffer.toString());
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("basePackage", basePackage == null ? "" : basePackage);
        vars.put("entityPackage", entityPackage);
        vars.put("tableName", tableName);
        vars.put("entityName", entityName);
        vars.put("upperCaseModuleName", generatorTable.getUpperCaseModuleName());
        vars.put("lowerCaseModuleName", generatorTable.getLowerCaseModuleName());
        vars.put("modulePath", modulePath);
        vars.put("author", context.getAuthor());
        vars.put("date", new Date().toString());
        vars.put("setCreateDateCode", "");
        vars.put("setUpdateDateCode", "");
        vars.put("columns", tableColumns);
        if (context.isGenerateController() && controllerTemplate != null) {
            String controllerCode = StringUtils.regexGroupExprReplace(controllerTemplate, "[$][{](.*?)[}]", "$", vars);
            generatorTable.setControllerCode(controllerCode);
        }
        if (context.isGenerateService()) {
            if (serviceTemplate != null) {
                String serviceInfCode = StringUtils.regexGroupExprReplace(serviceTemplate, "[$][{](.*?)[}]", "$", vars);
                generatorTable.setServiceInfCode(serviceInfCode);
            }
            if (serviceImplTemplate != null) {
                String serviceImplCode = StringUtils.regexGroupExprReplace(serviceImplTemplate, "[$][{](.*?)[}]", "$", vars);
                generatorTable.setServiceImplCode(serviceImplCode);
            }
        }
        if (context.isGenerateViews()) {
            if (apiJsTemplate != null) {
                String apiJsCode = StringUtils.regexGroupExprReplace(apiJsTemplate, "[$][{](.*?)[}]", "$", vars);
                generatorTable.setApiJsCode(apiJsCode);
            }
            if (vueTemplate != null) {
                String vueCode = vueTemplate.render(vars);
                generatorTable.setVueCode(vueCode);
            }
        }
        return generatorTable;
    }

    private static Map<String, GeneratorTableColumn> generateTableColumns(Connection connection, GeneratorTableOption tableOption) {
        String tableName = tableOption.getTableName();
        String querySql = String.format("select * from %s where 1 = 2 ", tableName);
        LinkedHashMap<String, GeneratorTableColumn> tableColumns = new LinkedHashMap<String, GeneratorTableColumn>();
        try {
            PreparedStatement ps = connection.prepareStatement(querySql);
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String primaryColumnName = null;
            try {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                ResultSet pkRSet = databaseMetaData.getPrimaryKeys(null, null, tableName);
                if (pkRSet.next()) {
                    primaryColumnName = pkRSet.getString(4);
                }
                pkRSet.close();
            }
            catch (Throwable databaseMetaData) {
                // empty catch block
            }
            for (int i = 1; i <= columnCount; ++i) {
                String columnName = rsmd.getColumnLabel(i);
                String columnCamelCase = StringUtils.getCamelCase(columnName);
                GeneratorTableColumn tableColumn = new GeneratorTableColumn();
                tableColumn.setColumnName(columnName);
                tableColumn.setJavaField(columnCamelCase);
                tableColumns.put(columnCamelCase, tableColumn);
                int size = rsmd.getColumnDisplaySize(i);
                int columnType = rsmd.getColumnType(i);
                String javaType = "Integer";
                tableColumn.setColumnType(columnType);
                if (columnType == 93 || columnType == 91) {
                    javaType = "java.util.Date";
                    tableColumn.setJavaType(3);
                } else if (columnType == 8 || columnType == 6) {
                    javaType = "Double";
                    tableColumn.setJavaType(2);
                } else if (columnType == -5) {
                    javaType = "Long";
                    tableColumn.setJavaType(2);
                } else if (columnType == 4) {
                    javaType = "Integer";
                    tableColumn.setJavaType(2);
                } else if (columnType == 12 || columnType == -9 || columnType == 2005 || columnType == -1) {
                    javaType = "String";
                    tableColumn.setJavaType(1);
                } else if (columnType == 1) {
                    javaType = "String";
                    tableColumn.setJavaType(1);
                } else if (columnType == -4) {
                    javaType = "byte[]";
                    tableColumn.setJavaType(4);
                } else {
                    System.out.println(columnName);
                    throw new RuntimeException(" type  validate error ");
                }
                tableColumn.setJavaTypeName(javaType);
                if (primaryColumnName == null || !primaryColumnName.equalsIgnoreCase(columnName)) continue;
                tableColumn.setPrimary(true);
            }
            rs.close();
            return tableColumns;
        }
        catch (Throwable throwable) {
            throw new SqlExecuteException(throwable.getMessage(), throwable);
        }
    }
}

