/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.query.page;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Page<E> {
    private long page;
    private int pageSize;
    private List<E> rows;
    private long total;
    private Long offset;
    private Class<E> cls;

    public Page() {
    }

    public Page(Class<E> cls) {
        this.cls = cls;
    }

    public static <T> Page<T> pageInstance(Class<T> cls) {
        return new Page<T>(cls){};
    }

    public Class<E> actualType() {
        if (this.cls != null) {
            return this.cls;
        }
        ParameterizedType parameterizedType = (ParameterizedType)this.getClass().getGenericSuperclass();
        Type[] types = parameterizedType.getActualTypeArguments();
        if (types != null && types.length > 0 && types[0] instanceof Class) {
            return (Class)types[0];
        }
        return null;
    }

    public long getPage() {
        return this.page;
    }

    public void setPage(long page) {
        this.page = page;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public List<E> getRows() {
        return this.rows;
    }

    public void setRows(List<E> rows) {
        this.rows = rows;
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public long getCurrentPage() {
        return this.page;
    }

    public long getOffset() {
        if (this.offset == null) {
            this.offset = (this.page - 1L) * (long)this.pageSize;
        }
        return this.offset;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }
}

