/*
 * Decompiled with CFR 0.152.
 */
package io.github.wycst.wast.jdbc.util;

import io.github.wycst.wast.common.reflect.UnsafeHelper;
import io.github.wycst.wast.common.utils.ObjectUtils;
import io.github.wycst.wast.jdbc.exception.ParameterException;
import io.github.wycst.wast.jdbc.query.sql.Sql;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlUtil {
    public static Map<String, String> totalSqlMapping = new ConcurrentHashMap<String, String>();

    public static String getTotalSql(String sql) {
        String totalSql = totalSqlMapping.get(sql);
        if (!totalSqlMapping.containsKey(sql)) {
            String baseSelectRegex = "([ ]*[Ss][Ee][Ll][Ee][Cc][Tt][ ]+).*([ ]+[Ff][Rr][Oo][Mm][ ]+.+)$";
            String uniconSelectRegex = "[( ]*" + baseSelectRegex + "[) ]+[Uu][Nn][Ii][Oo][Nn][( ]+" + baseSelectRegex + "[) ]*";
            totalSql = sql.matches(uniconSelectRegex) ? "SELECT count(*) FROM (" + sql + ") t" : (sql.matches(baseSelectRegex) ? sql.replaceAll(baseSelectRegex, "$1 count(*) $2") : "SELECT count(*) FROM (" + sql + ") t");
            totalSqlMapping.put(sql, totalSql);
        }
        return totalSql;
    }

    public static Sql getSqlObject(String tmpSql, Object target) {
        try {
            Sql sql = new Sql();
            StringBuilder builder = new StringBuilder();
            ArrayList<Object> values = new ArrayList<Object>();
            ArrayList<String> paramNames = new ArrayList<String>();
            boolean replaced = false;
            int paramIndex = 0;
            char[] chars = UnsafeHelper.getChars(tmpSql);
            int length = chars.length;
            int beginIndex = 0;
            boolean stringMode = false;
            char prev = '\u0000';
            for (int i = 0; i < length; ++i) {
                char ch = chars[i];
                if (ch == '\'') {
                    boolean bl = stringMode = !stringMode;
                }
                if (ch == '{') {
                    boolean is$;
                    boolean bl = is$ = prev == '$';
                    if (is$ || prev == '#' && !stringMode) {
                        int j;
                        int e = i - 1;
                        builder.append(chars, beginIndex, e - beginIndex);
                        beginIndex = e;
                        for (j = ++i; j < length && (ch = chars[j]) != '}'; ++j) {
                        }
                        if (ch == '}') {
                            String key = new String(chars, i, j - i).trim();
                            Object value = SqlUtil.getParamValue(target, key, paramIndex++);
                            if (is$) {
                                if (value != null) {
                                    if (value instanceof String) {
                                        String strValue = (String)value;
                                        if (strValue.indexOf(34) > -1) {
                                            strValue = strValue.replace("\"", "\\\"");
                                        }
                                        if (strValue.indexOf(39) > -1) {
                                            strValue = strValue.replace("'", "\\'");
                                        }
                                        value = strValue;
                                    } else if (value instanceof Date) {
                                        value = new io.github.wycst.wast.common.beans.Date(((Date)value).getTime()).format();
                                    }
                                }
                                builder.append(value);
                                replaced = true;
                            } else {
                                builder.append('?');
                                paramNames.add(key);
                                values.add(value);
                            }
                            beginIndex = j + 1;
                        }
                        i = j;
                    }
                }
                prev = ch;
            }
            if (beginIndex < length) {
                builder.append(chars, beginIndex, length - beginIndex);
            }
            sql.setOriginalSql(tmpSql);
            sql.setFormalSql(builder.toString());
            sql.setParamValues(values.toArray());
            sql.setParamNames(paramNames);
            sql.setReplaced(replaced);
            return sql;
        }
        catch (Exception e) {
            throw new ParameterException(" sql params parse error: " + tmpSql, e);
        }
    }

    static Object getParamValue(Object target, String key, int paramIndex) {
        if (target == null) {
            return null;
        }
        if (target instanceof byte[] || target instanceof Number || target instanceof Boolean || target instanceof CharSequence) {
            if (paramIndex > 0) {
                throw new ParameterException("No value specified for parameter " + (paramIndex + 1));
            }
            return target;
        }
        if (target.getClass().isArray()) {
            Object[] arr = (Object[])target;
            if (paramIndex > arr.length - 1) {
                throw new ParameterException("No value specified for parameter " + (paramIndex + 1));
            }
            return arr[paramIndex];
        }
        return ObjectUtils.get(target, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readSqlScripts(InputStream is) throws IOException {
        ArrayList<String> arrayList;
        BufferedReader bufferedReader;
        block6: {
            ArrayList<String> scriptList = new ArrayList<String>();
            bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(is));
                StringBuilder builder = new StringBuilder();
                String line = null;
                while ((line = bufferedReader.readLine()) != null) {
                    builder.append(line).append("\r\n");
                    String trimLine = line.trim();
                    if (trimLine.startsWith("--") || !trimLine.endsWith(";")) continue;
                    scriptList.add(builder.toString());
                    builder.setLength(0);
                }
                if (builder.length() > 0) {
                    scriptList.add(builder.toString());
                }
                arrayList = scriptList;
                Object var7_6 = null;
                if (is == null) break block6;
            }
            catch (Throwable throwable) {
                block7: {
                    Object var7_7 = null;
                    if (is != null) {
                        is.close();
                    }
                    if (bufferedReader == null) break block7;
                    bufferedReader.close();
                }
                throw throwable;
            }
            is.close();
        }
        if (bufferedReader != null) {
            bufferedReader.close();
        }
        return arrayList;
    }

    public static void clear() {
        totalSqlMapping.clear();
    }
}

